#include "SimulationMultiplexor.h"
#include "Main.h"
#include "Send.h"
#include "Recv.h"
#include "assert.h"

Send::Send(int xpid, int recvs, int xhowMany)
//    : ( "SEND", 1000, -xpid), rnd(0, recvs-1, &gen), gen(-xpid)
    : ( "SEND", 10000, (ThreadPriority)-xpid, (bool)0), rnd(0, recvs-1, &gen), gen(-xpid,xpid)
{
    pid = xpid;
    howMany = xhowMany;
}


void
Send::main()
{
    int i;
    for (i = 0; i < howMany; i++) {
	int to = int (rnd());
	CpuCerrLock.reserve();
	cout << "Send " << i << " to " << to << " at " << simulatedClock() <<"\n";
	CpuCerrLock.release();
	theRecvs[ to ] -> add( i );
	hold(1);
    }
}

Send::~Send()
{
    CpuCerrLock.reserve();
    cout << "Sender bids good bye at " << simulatedClock() <<"\n";
    CpuCerrLock.release();
}
