// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#ifndef SimulationMultiplexor_h
#define SimulationMultiplexor_h
#pragma once

#include <CpuMultiplexor.h>
#include <HardwareContext.h>

//
//	Like it says.
//
extern double CurrentSimulatedTime;
//extern const double NullTime;

class TimeSchedulerPQ;

class SimulationMultiplexor {
protected:
    CpuMultiplexor *cpu;

    TimeSchedulerPQ *myPendingEvents;

    virtual int advanceTime();

    friend class MultiCpuMux;

    virtual void allocateEventStructures(int,int);
    virtual void deallocateEventStructures();

public:
    SimulationMultiplexor(int debug = 0);
    ~SimulationMultiplexor();

    virtual void fireItUp(int Cpus = 1, unsigned shared = (4196 * 500));
    virtual void warmThePot(int);
    virtual void stirItAround();
    virtual void coolItDown();

    virtual void addAt(Thread *, double);
    virtual void addWithDelay(Thread *, double);
    virtual void hold( double time );
    virtual void await( double time );

    //
    //	The following are simply delegations to the CPU instance
    //
    void terminateAll();
    void add(Thread *);
    Thread * CurrentThread();
    char *name();
};

extern SimulationMultiplexor *ThisSimulationMultiplexor;

//
//	delegations
//
static inline void SimulationMultiplexor::terminateAll( )
{
    cpu -> terminateAll();
}

static inline void SimulationMultiplexor::add( Thread *t )
{
    cpu -> add(t);
}

static inline Thread * SimulationMultiplexor::CurrentThread()
{
    return( cpu -> CurrentThread() );
}

static inline char* SimulationMultiplexor::name()
{
    return( cpu -> name() );
}

static inline double simulatedClock() {
    return( CurrentSimulatedTime );
}

static inline void await(double till)
{
    if ( till > CurrentSimulatedTime ) {
	ThisSimulationMultiplexor -> await(till);
    }
}

static inline void hold(double holdFor)
{
    ThisSimulationMultiplexor -> await( CurrentSimulatedTime + holdFor );
}

#endif /* SimulationMultiplexor_h */
