// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef AWESIMEHEAP
#define AWESIMEHEAP
#pragma once

#define HEAP_NAME AwesimeHeap
#define HEAP_KEY double

#include <Awesime.h>

class AwesimeHeapItem {
    Awesime *pPtr;
    double pKey;
public:
    AwesimeHeapItem();
    AwesimeHeapItem(double key, Awesime *p);
    operator<=(AwesimeHeapItem &p);
    Awesime *ptr();
    double key();
};

inline Awesime*
AwesimeHeapItem::ptr()
{
    return(pPtr);
}

inline double
AwesimeHeapItem::key()
{
    return(pKey);
}

inline AwesimeHeapItem::AwesimeHeapItem()
{
    pPtr = 0; pKey = 0;
}

inline AwesimeHeapItem::AwesimeHeapItem(double k, Awesime *p)
{
    pPtr = p; pKey = k;
}

inline int AwesimeHeapItem::operator<=(AwesimeHeapItem &p)
{
    return ( pKey <= (p.key()) );
}

#include <GenericHeap.h>

#endif

