// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef BatchStatistic_h_
#define BatchStatistic_h_
#pragma once

#include <SampleStatistic.h>
#include <stream.h>

class BatchStatistic : public SampleStatistic {
    int pBatchTrigger;
    SampleStatistic batchStats;
public:
    BatchStatistic( int trigger = 0 );

    int batchTrigger();
    void batchTrigger(int);

    virtual void operator+=(double);

    virtual void batch();
    virtual void batchReset();
    virtual int batchSamples();
    virtual double batchMean();
    virtual double batchStdDev();
    virtual double batchVar();
    virtual double batchMin();
    virtual double batchMax();
    virtual double batchSum();
    virtual double batchConfidence(int p_percentage);
    virtual double batchConfidence(double p_value);

    virtual void classPrintOn(ostream&);
};

BatchStatistic::BatchStatistic(int trigger)
{
    pBatchTrigger = trigger;
}

inline ostream&
operator<<(ostream& strm, BatchStatistic& ob)
{
    ob.classPrintOn(strm);
    return strm;
}

#endif BatchStatistic_h_
