// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef FACILITYH
#define FACILITYH
#pragma once

//
//	Facility.
//
//	This models a simulation facility. A facility is composed of multiple
//	servers. Servers are utilized for a period of time. The fraction of
//	use of all servers over the total time the facility has existed
//	(or since it was reset) determines the utilization of the facility.
//
//	A facility is not owned by specific threads. An OwnedFacility,
//	however, is owned by specific threads.
//

#include <Semaphore.h>

class Thread;

class Facility : public Semaphore {

protected: 

    SpinLock dataLock;

    short servers;
    struct {
	double single;	// valid when servers == 1
	double *many;	// valid when servers > 1
    } whenServiced;

    double serviceStarted;
    double totalServiceTime;

    long pTotalReserves;
    long pTotalFailures;

    double pTotalDelay;

    virtual void reportErrorState(ostream&);
    void commonReserve(double);

    public :

    Facility(int servers = 1, ThreadContainer *scheduler =0);

    ~Facility();

    virtual void reserve();
    virtual void release();
    virtual bool reserveNoBlock();

    virtual void use(double);

    virtual void reset();

    virtual double utilization();

    virtual long totalAttempts();
    virtual long totalReserves();
    virtual long totalFailures();

    virtual double totalDelay();
    virtual double meanDelay();

    virtual double perceivedUtilization();

    virtual bool isEmpty();

    virtual unsigned queueLength();
    virtual unsigned activeServers();
    virtual unsigned size();

//    virtual void classPrintOn(ostream& s);
};

#endif FACILITYH
