// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef LOCKEDHEAPH
#define LOCKEDHEAPH
#pragma once

#include <Semaphore.h>
#include <AwesimeHeap.h>

class LockedHeap : public AwesimeHeap {

protected:
    Semaphore heapLock;
public:

    LockedHeap(int defaultLength = 0);
    //
    // Operations on the list -- these simply lock the list and
    // then use the AwesimeHeap routines to perform the action.
    //
    virtual void add(AwesimeHeapItem & t);
    virtual bool remove(AwesimeHeapItem & item);

    //
    // Over-ride the doStart and doDone; these use the semaphore
    // to lock out other threads.
    //

    virtual bool doStart( AwesimeHeapIndex& index);
    virtual void doDone();

    //
    // The size and printer also locks out other threads.
    //
    virtual unsigned int size();
    virtual void classPrintOn(ostream& s);
};
		     
#endif LOCKEDHEAPH
