// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "LowerBoundedFifo.h"
#include "CpuMultiplexor.h"
#include "stream.h"
#include "assert.h"

LowerBoundedFifo::LowerBoundedFifo(int defaultLength)
    : (defaultLength),
    lowerBoundLock(0, &lowerBoundLockFifo), lowerBoundLockFifo(2)
{
    //
    // do nothing
    //
}

void LowerBoundedFifo::add(AwesimeFifoItem *t) {
    LockedFifo::add(t);
    lowerBoundLock.release();
}

bool
LowerBoundedFifo::remove(AwesimeFifoItem *item)
{
    (void) lowerBoundLock.reserve();
    bool ok = LockedFifo::remove(item);
    //
    //	The remove had better have worked, or there's something screwy
    //  with the semaphores.
    //
    assert(ok);
    return(ok);
}

bool
LowerBoundedFifo::removeNoBlock(AwesimeFifoItem *item)
{
    bool ok = lowerBoundLock.reserveNoBlock();
    if ( ok ) {
	ok = LockedFifo::remove(item);
    }
    return(ok);
}

bool
LowerBoundedFifo::removeIfFound(AwesimeFifoItem *item) {
    bool ok = LockedFifo::removeIfFound(item);
    if (ok) {
	(void) lowerBoundLock.reserve();
    }
    return(ok);
}

bool
LowerBoundedFifo::doDelete(AwesimeFifoIndex& index) {
    //
    // This is problematic. Since this is a LockedFifo, this person
    // will be the only one with access to the list. If he blocks
    // at this point, he's dead-meat.
    //
    // So, is this an error? If so, should we protect him?
    //
    bool whaHap = AwesimeFifo::doDelete(index);
    if (whaHap) {
	bool noBlock = lowerBoundLock.reserveNoBlock();
	assert( noBlock );
    }
    return(whaHap);
}

unsigned int
LowerBoundedFifo::size()
{
    return(AwesimeFifo::size());
}

void LowerBoundedFifo::classPrintOn(ostream& s)
{
    s << "[LowerBoundedFifo " ;
    s << "\tSemaphore\n";
//    s << lowerBoundLock;
    s << "\n";
    s << "\tFifo";
    AwesimeFifo::classPrintOn(s);
    s << "\n]\n" ;
}
