// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "SpinEvent.h"
#include "Pragma.h"

C_EXTERNAL_FUNCTION( int getpid() );

void
SpinEvent::waitFor()
{
    int timesAround = 0;

    reserve();
    int gen = generation;
    garcon++;
    release();

    //
    // Waiting people just read generation, and the final process
    // just writes it, so we do not really even need to use the locks here.
    //
    
    while ( gen == generation ) {
	if (timesAround > pLoops) {
	    (void) getpid();
	    timesAround = 0;
	}
	timesAround++;
    }
}
