// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef SpinFetchAndOp_h
#define SpinFetchAndOp_h
#pragma once

//
//	Fetch and op for hardware CPUS
//

#include <SpinLock.h>
#include <AwesimeConfig.h>

class SpinFetchAndOp : public SpinLock {
    int	data;
public:
    SpinFetchAndOp(int);
    void set(int);
    int add(int);
    int unlockedAdd(int);
    int value();
};

inline
SpinFetchAndOp::SpinFetchAndOp(int d)
{
    data = d;
}

inline void
SpinFetchAndOp::set(int d)
{
    data = d ;
}

#ifdef __GNUG__
static inline int SpinFetchAndOp::add(int d)
{
#if defined(USE_SHARED_MEMORY)
    reserve();
#endif
    int was = data;
    data += d;
#if defined(USE_SHARED_MEMORY)
    release();
#endif
    return(was);
}
#endif

inline int
SpinFetchAndOp::unlockedAdd(int d)
{
    int was = data;
    data += d;
    return(was);
}

inline int
SpinFetchAndOp::value()
{
    return(data);
}
#endif /* SpinFetchAndOp_h */
