// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "SpinFuzzyBarrier.h"
#include "Pragma.h"

C_EXTERNAL_FUNCTION( int getpid() );

#ifdef USE_SHARED_MEMORY
static int
SpinFuzzyBarrier::rendez()
{
    reserve();
    pCount++;
    int gen = generation;

    if ( pCount == pHeight ) {
	pCount = 0;
	generation++;
    }
    release();
    return( gen );
}

static inline int
SpinFuzzyBarrier::vous(int gen)
{
    int timesAround = 0;
    int totalGetPids = 0;
    while ( gen == generation ) {
	if ( timesAround > pLoops ) {
	    (void) getpid();
	    timesAround = 0;
	    totalGetPids++;
	    if ( pMaxLoops > 0 && totalGetPids > pMaxLoops ) {
		return(0);
	    }
	}
	timesAround++;
    }
    return(1);
}
#endif
