// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef	THREADH
#define	THREADH
#pragma once

#include <Awesime.h>
#include <HardwareContext.h>
#include <ThreadContainer.h>
#include <stream.h>

enum ThreadState { SUSPENDED, RUNNING, RUNNABLE, ZOMBIED, TERMINATED };

static const double NullTime = -1;

typedef int ThreadPriority;

class CpuMultiplexor;
class SingleCpuMux;
class SingleSimMux;
class MultiCpuMux;
class MultiSimMux;
class SimulationMultiplexor;

class Thread : public Awesime {

    friend class HardwareContext;

    friend class CpuMultiplexor;
    friend class SingleCpuMux;
    friend class MultiCpuMux;

    friend class SimulationMultiplexor;
    friend class SingleSimMux;
    friend class MultiSimMux;

    HardwareContext pContext;

    ThreadState threadState;
    ThreadPriority threadPriority;
    short cpuAffinity;

    ThreadContainer suspendedOn;

    void startOff();
    void makeTerminated();
    char* threadName;

protected:

    void name(char *);
    void state(ThreadState s);

    void makeRunnable();

    virtual void main();

public:
    Thread(char* name ="", unsigned stacksize = 1010,
	   int checkStack = 1,
	   ThreadPriority priority = 0,
	   bool debug = 0);
    
    virtual ~Thread();

    //
    // access functions
    //
    
    const HardwareContext * context();
    char* name();
    ThreadState state();

    long maxStackDepth();
    void checkStack();

    void priority(ThreadPriority newPriority);
    ThreadPriority priority();

    //
    // action functions
    //
    
    virtual void classPrintOn(ostream& strm);
};

static inline char*
Thread::name()
{
    return threadName;
}

static inline void
Thread::name(char *name)
{
    threadName = name;
}

static inline void
Thread::state(ThreadState s)
{
    threadState = s;
}

static inline ThreadState
Thread::state()
{
    return threadState;
}

static inline long
Thread::maxStackDepth()
{
    return( pContext.maxStackDepth() );
}

static inline void
Thread::checkStack()
{
    pContext.checkStack();
}

static inline ThreadPriority
Thread::priority()
{
    return(threadPriority);
};

static inline void
Thread::priority(ThreadPriority newPriority)
{
    threadPriority = newPriority;
}
#endif	THREADH
