/* Collection.c -- implementation of abstract Collection class

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985


Function:
	
Collection is an abstract class that actually implements only the
addAll, removeAll, includes, isEmpty, and Collection conversion
functions.  Note that the functions Collection::asBag, asOrderedCltn,
asSet, and asSortedCltn are defined in the file that implements the
respective target Collection so that all of these classes are not loaded
whenever any one Collection is used.

$Log:	Collection.c,v $
 * Revision 2.204  89/10/07  23:19:00  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:26  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:26  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:27  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:12:39  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  22:38:22  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Make all constructors non-inline.
 * Add explicit base names to constructor initializer lists.
 * Change 2nd argument of DO to class name.
 * 
 * Revision 2.201.1.1  89/05/19  15:40:53  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:28  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:56:50  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:22  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:30  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:01  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:47  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Collection.h"
#include "ArrayOb.h"
#include "nihclIO.h"

#define	THIS	Collection
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_ABSTRACT_CLASS(Collection,0,"$Header: Collection.c,v 2.204 89/10/07 23:19:00 keith Stab $",NULL,NULL);

const unsigned Collection::DEFAULT_CAPACITY = 16;	// default initial collection capacity 
const unsigned Collection::EXPANSION_INCREMENT = 32;	// collection (OrderedCltn) expansion increment 
const unsigned Collection::EXPANSION_FACTOR = 2;	// collection (Set,Bag,Dictionary) expansion factor 

Collection::Collection() {}

Collection::Collection(OIOifd& fd) : BASE(fd) {}

Collection::Collection(OIOin& strm) : BASE(strm) {}

const Collection& Collection::addAll(const Collection& c)
{
	c.addContentsTo(*this);
	return c;
}

Collection& Collection::addContentsTo(Collection& c) const
{
	DO(*this,Object,o) c.add(*o); OD
	return c;
}

const Collection& Collection::removeAll(const Collection& c)
{
	DO(c,Object,o) remove(*o); OD
	return c;
}

void Collection::deepenShallowCopy() {}

bool Collection::includes(const Object& ob) const { return occurrencesOf(ob) != 0; }

bool Collection::isEmpty() const { return size() == 0; }

ArrayOb Collection::asArrayOb() const
{
	ArrayOb a(size());
	Object** q = &(a.elem(0));
	DO(*this,Object,o) *q++ = o; OD
	return a;
}
 
void Collection::doFinish(Iterator& pos) const {}

void Collection::doReset(Iterator& pos) const
{
	pos.index = 0;
	pos.ptr = NULL;
	pos.num = 0;
}

void Collection::dumpOn(ostream& strm) const
{
	strm << className() << '[';
	DO(*this,Object,o) o->dumpOn(strm); OD
	strm << "]\n";
}

void Collection::printOn(ostream& strm) const
{
	int n = 0;
	DO(*this,Object,o)
		if (n++ != 0) strm << '\n';
		o->printOn(strm);
	OD
}

void Collection::_storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << capacity() << size();
	DO(*this,Object,o) o->storeOn(strm); OD
}

void Collection::_storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << capacity() << size();
	DO(*this,Object,ob) ob->storeOn(fd); OD
}
