#ifndef	HEAP_H
#define	HEAP_H

/*$Header: Heap.h,v 2.204 89/10/07 23:19:38 keith Stab $*/

/* Heap.h -- declarations for abstract heap          

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	C. J. Eppich
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Heap.h,v $
 * Revision 2.204  89/10/07  23:19:38  keith
 * Pre-release
 * 
 * Revision 2.203.1.2  89/09/10  16:20:03  keith
 * Implement removeId().
 * 
 * Revision 2.203.1.1  89/09/09  20:11:52  keith
 * Eliminate isEqual() and species().
 * Enable compare().
 * Correct implementation of doNext(), implement doReset()
 * and doFinish().
 * 
 * Revision 2.203  89/08/08  15:22:07  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:09  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:07  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:13:45  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:15:52  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:47  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:06  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  10:58:10  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:57:54  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:08:07  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:46  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:39  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:49  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Collection.h"
#include "OrderedCltn.h"
#include "ArrayOb.h"

class Heap: public SeqCltn {
	DECLARE_MEMBERS(Heap);
	int endIndex;
	ArrayOb contents;
private:		// static member functions
	static int child(int i)		{ return (i << 1) + 1; }
	static int grandchild(int i)	{ return (child(i) << 1) + 1; }
	static int parent(int i)	{ return (i - 1) >> 1; }
	static int level(int);
private:
	void bubbleUp(int);
	void bubbleUpMax(int);
	void bubbleUpMin(int);
	int descendents(int) const;
	void errEmpty(const char* fn) const;
	int largest(int,int) const;
	Object* removeAtIndex(int i);
	int smallest(int,int) const;
	void swap(int a,int b) 	{
		Object* temp = contents[a];
		contents[a] = contents[b]; 
		contents[b] = temp;
	}
	void trickleDown(int);
	void trickleDownMax(int);
	void trickleDownMin(int);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Heap(int size=DEFAULT_CAPACITY);
	Heap(const ArrayOb&);
	void operator=(const Heap&);
	bool operator==(const Heap&) const;
	bool operator!=(const Heap& a) const {  return !(*this==a);  }
	virtual Object* add(Object&);
	virtual Object*& at(int index);
	virtual const Object *const& at(int index) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual	void doFinish(Iterator& pos) const;
	virtual Object* doNext(Iterator&) const;
	virtual	void doReset(Iterator& pos) const;
	virtual Object* first() const;
	virtual unsigned hash() const;
	virtual bool isEmpty() const;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&);
	virtual void removeAll();
	virtual Object* removeFirst();
	virtual Object* removeId(const Object&);
	virtual Object* removeLast();
	virtual void reSize(int newSize);
	virtual unsigned size() const;
	OrderedCltn sort();
private:					// shouldNotImplement()
	virtual void atAllPut(Object& ob);
	virtual int indexOf(const Object& ob) const;
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
};

#endif
