/* IdentDict.c -- implementation of Identifier Dictionary

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	October, 1985

Function:
	
An IdentDict is like a Dictionary, except keys are compared using
isSame() rather than isEqual().

$Log:	IdentDict.c,v $
 * Revision 2.204  89/10/07  23:19:44  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:12  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/08  19:11:37  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.1  89/07/01  21:54:15  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:13  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:13:58  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  22:58:46  keith
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:57:19  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:17:12  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:58:42  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:59  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:47  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:01  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "IdentDict.h"
#include "LookupKey.h"

#define	THIS	IdentDict
#define	BASE	Dictionary
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(IdentDict,0,"$Header: IdentDict.c,v 2.204 89/10/07 23:19:44 keith Stab $",NULL,NULL);

IdentDict::IdentDict(unsigned size) : BASE(size) {}

void IdentDict::operator=(const IdentDict& d)
{
	this->Dictionary::operator=(d);
}

int IdentDict::findIndexOf(const Object& ob) const
/*
Search this IdentDict for a LookupKey with the same key object as the
argument.

Enter:
	ob = pointer to LookupKey to search for

Returns:
	index of object if found or of nil slot if not found
	
Algorithm L, Knuth Vol. 3, p. 519
*/
{
	register int i;
	Object* keyob = LookupKey::castdown(ob).key();
	for (i = h((int)keyob); contents[i]!=nil; i = (i-1)&mask) {
		if (LookupKey::castdown(contents[i])->key()->isSame(*keyob)) return i;
	}
	return i;
}

Object* IdentDict::atKey(const Object& key) const
{
	return Dictionary::atKey(LookupKey((Object&)key));
}

Object* IdentDict::atKey(const Object& key, Object& newValue)
{
	return Dictionary::atKey(LookupKey((Object&)key), newValue);
}

LookupKey* IdentDict::assocAt(const Object& key) const
{
	return Dictionary::assocAt(LookupKey((Object&)key));
}

bool IdentDict::includesKey(const Object& key) const
{
	return Dictionary::includesKey(LookupKey((Object&)key));
}

IdentDict::IdentDict(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
}

IdentDict::IdentDict(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
}
