#ifndef	INTEGER_H
#define	INTEGER_H

/*$Header: Integer.h,v 2.204 89/10/07 23:19:52 keith Stab $*/

/* Integer.h -- declarations for Integer object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Integer.h,v $
 * Revision 2.204  89/10/07  23:19:52  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:23  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:27  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:24  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:14:17  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  23:02:38  keith
 * Remove copy constructor.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:04  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:06  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:40  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:59:00  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:27  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:59  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:20  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class Integer: public VIRTUAL Object {
	DECLARE_MEMBERS(Integer);
	long val;
	void parseInteger(istream& strm)	{ strm >> val; }
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Integer(long v =0)		{ val = v; }
	Integer(istream&);
	long value() const		{ return val; }
	long value(long newval)		{ return val = newval; }
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void scanFrom(istream& strm);
	virtual const Class* species() const;
};

#endif
