/* Link.c -- implementation of singly-linked list element

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	October, 1985

Function:
	
Link is an abstract class that is used to construct LinkedLists.  It
contains a pointer to the next Link in the list, or nil if this is the
last Link.

$Log:	Link.c,v $
 * Revision 2.204  89/10/07  23:20:02  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/12  23:41:29  keith
 * Pre-release
 * Add nilLink and isListEnd().
 * 
 * Revision 2.202.1.1  89/07/01  21:54:39  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:34  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/20  23:06:32  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:52:51  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:33:44  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:53  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:10  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:06:46  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 */

#include "Link.h"
#include "LinkOb.h"

#define	THIS	Link
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_ABSTRACT_CLASS(Link,1,"$Header: Link.c,v 2.204 89/10/07 23:20:02 keith Stab $",NULL,NULL);

extern const int NIHCL_DELLNK;

static LinkOb _nilLink;
Link *const Link::nilLink = &_nilLink;

Link::~Link()
{
	if (next != NULL) setError(NIHCL_DELLNK,DEFAULT,className(),next,this);
}

Object* Link::copy() const	{ return deepCopy(); }

void Link::deepenShallowCopy()
{
}

Link::Link(OIOifd& fd) : BASE(fd) { next = NULL; }

Link::Link(OIOin& strm) : BASE(strm) { next = NULL; }
