/* Range.c  -- implementation of NIHCL class Range

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
        C. J. Eppich
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5361
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1987

Function:

Class Range implements an ordered pair of ints that can be used to indicate
a segment of some array (possibly a character string or vector).

$Log:	Range.c,v $
 * Revision 2.204  89/10/07  23:21:09  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:53  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:37  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:36  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/21  11:13:43  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Add explicit base class names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/05/25  09:57:23  ted
 * Changed casts to call castdown.
 * 
 * Revision 2.201  89/05/12  11:19:53  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  11:00:37  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:09:38  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:17:30  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:30:50  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:08:26  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Range.h"
#include "nihclIO.h"

#define	THIS	Range
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Range,1,"$Header: Range.c,v 2.204 89/10/07 23:21:09 keith Stab $",NULL,NULL);

//======= Protected member functions:

Range::Range(OIOin& strm)
	: BASE(strm)
{
	strm >> first >> len;
}

void Range::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << first << len;
}

Range::Range(OIOifd& fd)
	: BASE(fd)
{
	fd >> first >> len;
}

void Range::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << first << len;
}


//======= Public member functions:

void Range::deepenShallowCopy()  {}

unsigned Range::hash() const
{
	return (first^len);
}

bool Range::isEqual(const Object& p) const
// Test two objects for equality
{
	return p.isSpecies(classDesc) && *this==castdown(p);
}

void Range::printOn(ostream& strm) const
{
	strm << first << ':' << len;
}

const Class* Range::species() const
// Return a pointer to the descriptor of the species of this class
{
	return Range::desc();
}

int Range::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
