/* Rectangle.c -- implementation of class Rectangle

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:
	
A Rectangle is defined by two points: an origin, which specifies the top
left corner, and corner, which specifies the bottom right corner.

$Log:	Rectangle.c,v $
 * Revision 2.204  89/10/07  23:21:15  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:56  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:40  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/24  13:39:36  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/24  13:37:47  keith
 * Remove include of OrderedCltn.h.
 * 
 * Revision 2.201.1.3  89/06/22  10:16:38  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/21  11:15:08  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Change value Rectangle args to const Rectangle& args.
 * Remove areasOutside().
 * Add explicit base class names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/05/25  09:57:19  ted
 * Changed casts to call castdown.
 * 
 * Revision 2.201  89/05/12  11:19:58  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  11:00:48  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:09:48  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:17:38  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:30:55  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:08:33  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Rectangle.h"
#include "nihclIO.h"

#define	THIS	Rectangle
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES Point::desc(),Point::desc()
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Rectangle,2,"$Header: Rectangle.c,v 2.204 89/10/07 23:21:15 keith Stab $",NULL,NULL);

Rectangle::Rectangle(int left, int top, int height, int width)
{
	tl = Point(left,top);
	br = Point(left+width,top+height);
}

Rectangle::Rectangle(const Point& o, const Point& c)
{
	tl = o;
	br = c;
}

bool Rectangle::operator==(const Rectangle& r) const
{
	return (tl==r.tl && br==r.br);
}

Rectangle Rectangle::operator&&(const Rectangle& r) const
{
	return Rectangle(tl.max(r.tl), br.min(r.br));
}

Rectangle Rectangle::operator||(const Rectangle& r) const
{
	return Rectangle(tl.min(r.tl),
		br.max(r.br));
}

void Rectangle::operator+=(const Point& p)
{
	tl += p;
	br += p;
}

void Rectangle::operator-=(const Point& p)
{
	tl -= p;
	br -= p;
}

bool Rectangle::contains(const Point& p) const
{
	return (tl <= p) && (p <= br);
}

bool Rectangle::contains(const Rectangle& r) const
{
	return (contains(r.tl) && contains(r.br));
}

bool Rectangle::intersects(const Rectangle& r) const
{
	if (tl.max(r.tl) < br.min(r.br)) return YES;
	return NO;
}

void Rectangle::moveTo(const Point& p)
/*
	Move this Rectangle so its origin is at p.
*/
{
	br += p-tl;
	tl = p;
}

void Rectangle::deepenShallowCopy()	{}

unsigned Rectangle::hash() const	{ return tl.hash()^br.hash(); }

bool Rectangle::isEqual(const Object& r) const
{
	return r.isSpecies(classDesc) && *this==castdown(r);
}

const Class* Rectangle::species() const { return &classDesc; }

void Rectangle::printOn(ostream& strm) const
{
	strm << tl << " corner: " << br;
}

Rectangle::Rectangle(OIOin& strm)
	: BASE(strm),
	tl(strm), br(strm)
{
}

void Rectangle::storer(OIOout& strm) const
{
	BASE::storer(strm);
	tl.storeMemberOn(strm);
	br.storeMemberOn(strm);
}

Rectangle::Rectangle(OIOifd& fd)
	: BASE(fd),
	tl(fd), br(fd)
{
}

void Rectangle::storer(OIOofd& fd) const 
{
	BASE::storer(fd);
        tl.storeMemberOn(fd);
	br.storeMemberOn(fd);
}

int Rectangle::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
