/* StackProc.c -- Implementation of Process with stack shared with main() process

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	January, 1988

Function:
	
Modification History:

$Log:	StackProc.c,v $
 * Revision 2.204  89/10/07  23:21:52  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/12  23:44:35  keith
 * Pre-release.
 * Remove shouldNotImplement storer() functions.
 * 
 * Revision 2.202.1.2  89/07/04  19:41:00  keith
 * Make storer() shouldNotImplement().
 * Add MAIN process to Scheduler runlist in MAIN process constructor.
 * 
 * Revision 2.202.1.1  89/07/01  21:56:18  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:56:19  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:17:55  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/21  12:53:36  keith
 * Add explicit base class names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/05/19  15:48:24  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:34:27  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/04/24  17:19:03  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:41  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:09:50  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.12  89/02/08  13:29:58  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.11  89/01/17  11:39:47  keith
 * Initial version.
 * 

*/

#include "StackProc.h"
#include "Scheduler.h"
#include "nihclIO.h"

#define	THIS	StackProc
#define	BASE	Process
#define	BASE_CLASSES BASE::desc()
#define	MEMBER_CLASSES
#define	VIRTUAL_BASE_CLASSES

DEFINE_ABSTRACT_CLASS(StackProc,1,"$Header: StackProc.c,v 2.204 89/10/07 23:21:52 keith Stab $",NULL,NULL);

StackProc::StackProc(const char* name, stackTy* bottom, int priority, unsigned long size)
	: BASE(name, bottom, priority)
{
	stack_top = topOfStack();
	stack_save_size = size;
	if (size != 0) stack_save = new stackTy[size];
	else stack_save = 0;
	saveStack();
}

StackProc::StackProc(stackTy* bottom, int priority)
	: BASE(bottom, priority)
// contructor for MAIN process
{
	stack_top = bottom;
	stack_save = 0;
	stack_save_size = 0;
	Scheduler::main_stack_process = this;
	add();			// add MAIN process to Scheduler runlist
}

StackProc::StackProc(OIOifd& fd) : BASE(fd) {}

StackProc::StackProc(OIOin& strm) : BASE(strm) {}

StackProc::~StackProc()
{
	delete stack_save;
}

void StackProc::saveStack()
// save the stack for this Process
{
#if STACK_GROWS_DOWN
	unsigned long size = stack_bottom - stack_top;
#else
	unsigned long size = stack_top - stack_bottom;
#endif
	if (stack_save_size < size) {
		if (stack_save_size != 0) delete stack_save;
		stack_save = new stackTy[size];
		stack_save_size = size;
	}
#if STACK_GROWS_DOWN
	copyStack(stack_top+1, stack_save, size);
#else
	copyStack(stack_bottom, stack_save, size);
#endif
}

unsigned StackProc::size() const
{
#if STACK_GROWS_DOWN
	return stack_bottom - stack_top;
#else
	return stack_top - stack_bottom;
#endif
}

void StackProc::switchContext(Process* new_process)
{
	stack_top = topOfStack();
	save();
	new_process->switchFrom(this);
}

void StackProc::switchFrom(HeapProc*)
// switch from active HeapProc to next StackProc
{
	if (Scheduler::main_stack_process == this)
		LONGJMP(env, Scheduler::resume_new_process);
	Scheduler::main_stack_process->saveStack();
	_LONGJMP(Scheduler::switcher, 1);
}

void StackProc::switchFrom(StackProc* active)
// switch from active StackProc to next StackProc
{
	active->saveStack();
	_LONGJMP(Scheduler::switcher, 1);
}
