/* Test classes Catch, ExceptionAction, and ExceptionTrap

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	error.c,v $
 * Revision 2.204  89/10/07  23:50:14  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:50:54  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:21:41  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/11  23:15:10  keith
 * Change OIOistream to OIOin.
 * 
 * Revision 2.200.1.2  89/05/11  22:24:14  keith
 * Update for R2.0.
 * 
 * Revision 2.200.1.1  89/05/05  09:34:38  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200  89/04/24  17:33:23  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:20:10  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.2  89/02/08  14:04:12  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.1  89/02/03  10:39:25  keith
 * Add ", ..." to xtrap argument list for R2.0 compatibility.
 * 
 * Revision 2.0  88/03/29  13:26:30  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:37  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: error.c,v 2.204 89/10/07 23:50:14 keith Stab $";

#include "Stack.h"
#include "Exception.h"
#include "nihclIO.h"
#include "nihclerrs.h"

void xtrap(unsigned& err, int& sev, ...)
{
	cerr << "xtrap(" << err << ',' << sev << ") called\n";
}

class MyClass : public VIRTUAL Object {
	DECLARE_MEMBERS(MyClass);
	int n;
	Catch catcherr;
public:
	MyClass(int i) : catcherr(this) {
		n = i;
		cerr << "MyClass(" << n << ") constructed\n";
	}
	virtual void deepenShallowCopy();
	virtual void destroyer() {
		cerr << "MyClass(" << n << ") destroyed\n";
	}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
private:			// shouldNotImplement()
	virtual int compare(const Object&) const;
};

#define	THIS	MyClass
#define	BASE	Object
#define	BASE_CLASSES BASE::desc()
#define	MEMBER_CLASSES
#define	VIRTUAL_BASE_CLASSES

DEFINE_CLASS(MyClass,1,"$Header: error.c,v 2.204 89/10/07 23:50:14 keith Stab $",NULL,NULL);

MyClass::MyClass(OIOifd& fd) : Object(fd) { fd >> n; }
 
MyClass::MyClass(OIOin& strm) : Object(strm) { strm >> n; }

void MyClass::deepenShallowCopy() {};

unsigned MyClass::hash() const	{ return (unsigned)this; }

bool MyClass::isEqual(const Object& a) const { return isSame(a); }

void MyClass::printOn(ostream& strm) const {}

int MyClass::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}

main()
{
	cerr << "Test classes Catch, ExceptionAction, and ExceptionTrap\n";
	Stack s;
	MyClass* p = new MyClass(-1);
	MyClass* q = new MyClass(-2);
	{
		MyClass a(1);
		MyClass b(2);
		RaiseException x(NIHCL__CLTNEMPTY);
		BEGINX
			MyClass c(3);
			MyClass d(4);
			{
				MyClass e(5);
				MyClass f(6);
				delete p;
				s.pop();
			}
		EXCEPTION
			case NIHCL__CLTNEMPTY: {
				MyClass g(7);
				MyClass h(8);
				cerr << "CLTNEMPTY error handled\n";
			}
		ENDX
	}
	delete q;
	{
		ExceptionTrap x(xtrap);
		s.pop();
	}
}
