/* FloatVect.c -- Data type-specific functions for class FloatVec

$Log:	FloatVect.c,v $
 * Revision 2.204  89/10/08  09:42:46  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/14  11:21:16  ted
 * New program for this revision
 * 
Author:
	Tom Keffer
	School of Oceanography, WB-10
	Univ. of Washington
	Seattle, WA 98195
	(206) 543-6455

	Internet: keffer@sperm.ocean.washington.edu
	uucp:     uw-beaver!sperm.ocean.washington.edu!keffer
	BITNET:   keffer%sperm.ocean.washington.edu@UWAVM
	Telemail: T.KEFFER/OMNET	 

Copied and modified from Gorlen's DoubleVect.c.  Frankly, I don't see
much here that couldn't have been included in the m4 templates.  The
one exception is the print formats: 7 significant digits instead of 14.

Function:
	
Data type -specific functions for class FloatVec.

Modification History:

	
*/

#include "FloatVec.h"
#include "DoubleVec.h"
#include "nihclconfig.h"
#include <libc.h>

#define	THIS	FloatVec
#define	BASE	Vector

// Conversion from double to float.  Added by tk.
FloatVec::FloatVec(const DoubleVec& dv) :
       BASE(dv.length())
{
  v = NULL;
  if(n){
    v = new float[n];
    float* fp = v;
    const double* dp = dv.pt();
    unsigned i = n;
    while(i--) *fp++ = float(*dp++);
  }
}

static int typeCmp(const void* a, const void* b)
{
	float t = (const float*)a-(const float*)b;
	if (t < 0) return -1;
	if (t > 0) return 1;
	return 0;
}

void THIS::sort()
{
	qsort(v,n,sizeof(float),typeCmp);
}

unsigned THIS::hash() const
{
	unsigned h = n;
#ifdef LOG2_INT
	unsigned i = n*sizeof(float) >> LOG2_INT;
#else
	unsigned i = n*sizeof(float)/sizeof(int);
#endif
	unsigned* vv = (unsigned*)v;
	while (i--) h ^= *vv++;
	return h;
}

void THIS::printOn(ostream& strm) const
{
	for (unsigned i=0; i<n; i++) {
		if (i>0 && (i%6 == 0)) strm << "\n\t";
		strm << form("%13.4g",v[i]);
	}
}

void THIS::scanFrom(istream& strm)
{
	extern const int NIHCL_NYET;
	seterror(NIHCL_NYET,DEFAULT,className(),"scanFrom");
}
