static char RcsId[] = "$Id: Coding.c,v 1.2 1992/08/31 21:36:55 kadhim Exp $";
/* GlaSym output module */

#include <stdio.h>
#include "err.h"
#include "csm.h"
#include "envmod.h"
#include "deftbl.h"
#include "pdl_gen.h"
#include "Coding.h"

static FILE *GlaSym;		/* Lexical token codes */
static PTGNode codepart;	/* Grammar token codes */
static DefTableKey EOFKey;	/* Key for the EOF token */

/***/
int
GlaSymInit(env)
Environment env;
/* Open the token code file
 *    On entry-
 *       env=environment for symbol definition
 *    On exit-
 *       The token file is open for writing
 *       GlaSymInit=last token code assigned
 ***/
{
   if ((GlaSym = fopen("GlaSym", "w")) == NULL)
      message(DEADLY, "Could not open GlaSym", 0, (POSITION *)0);
   codepart = PTGCoding(PTGEof(),PTGInt(1));
   EOFKey = DefineIdn(env,SymbolFor("EOF"));
   SetCode(EOFKey,1,1);
   SetCodeWritten(EOFKey,1,1);
   return 1;
}

/***/
void
GlaSymIdn(sym, ptg, code)
int sym; PTGNode ptg; int code;
/* Output the code for an identifier
 *    On entry-
 *       string[sym] is the identifier string
 *       ptg=node reflecting stacking status
 *       code=code for this identifier
 *    On exit-
 *       A line containing the coding has been written to GlaSym
 ***/
{
   (void)fprintf(GlaSym, "%s\t\t%d\n", string[sym], code);

   codepart = PTGLines(codepart, PTGCoding(ptg,PTGInt(code)));
}


static char protect[] = {	/* Characters to be protected */
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	1,0,1,0,1,0,0,0,1,1,1,1,0,0,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0};


/***/
void
GlaSymLit(txt, ptg, code)
int txt; PTGNode ptg; int code;
/* Output the code for a literal
 *    On entry-
 *       string[txt] is the literal string
 *       ptg=node reflecting stacking status
 *       code=code for this literal
 *    On exit-
 *       A line containing the coding has been written to GlaSym
 ***/
{
   char *p, *q;

   putc('$', GlaSym);

   q = string[txt] + 1; while (q[1]) q++;
   for (p = string[txt] + 1; p < q; p++) {
      if (*p == '\'') p++;
      if (protect[*p]) (void)(putc('\\', GlaSym));
      (void)(putc(*p, GlaSym));
   }
   (void)fprintf(GlaSym, "\t\t%d\n", code);

   codepart = PTGLines(codepart, PTGCoding(ptg,PTGInt(code)));
}

/***/
PTGNode
GlaSymFinl()
/* Close the token code file
 ***/
{
   (void)fclose(GlaSym);
   return codepart;
}


/***/
void
OutSym(f, s)
FILE *f; int s;
/* Print a symbol from the symbol table
 *    On entry-
 *       f=file on which the symbol is to be output
 *       s=index of the symbol to be output
 ***/
{ (void)fprintf(f, "%s", string[s]); }
