static char RCSid[] = "$Id: support.c,v 1.4 1993/02/22 23:12:48 kadhim Exp $";
/* Copyright (c) 1991, The Regents of the University of Colorado */

#include <stdlib.h>
#include "envmod.h"
#include "csm.h"
#include "pdl_gen.h"

#include "obstack.h"

struct obstack StrStack;

void
InitRuleStr ()
/* Initialize a stack for the strings we will create in this module */
{
  obstack_init(&StrStack);
}

void
CompleteStr (env)
Environment env;
/* After chaining together the portions of the rule, this function is
 * called to complete the string and define a key for it.
 ***/
{
  char *str;
  int temp, idn;

  obstack_1grow(&StrStack, '\0');
  str = (char *) obstack_finish(&StrStack);
  mkidn(str, strlen(str), &temp, &idn);
  DefineIdn(env, idn);
}

void
AddLhs (val)
int val;
/* This tacks on the identifier which is on the left-hand-side of the
 * production to the rule string.
 ***/
{
  obstack_grow(&StrStack, string[val], strlen(string[val]));
  obstack_grow(&StrStack, "::=", 3);
}

void 
AddRhs (env, val)
Environment env;
int val;
/* This tacks on an identifier which appears on the right-hand-side of
 * the production to the rule string.  It also checks to see if there is
 * an equivalence defined for the identifier using the IS construct.
 ***/
{
  DefTableKey key;
  int equiv;

  obstack_grow(&StrStack, " ", 1);
  key = KeyInEnv(env, val);
  if (key == NoKey)
    obstack_grow(&StrStack, string[val], strlen(string[val]));
  else {
    equiv = GetEquiv(key, 0);
    obstack_grow(&StrStack, string[equiv], strlen(string[equiv]));
  }
}

void
MakeEmpty (env, lhs)
Environment env;
int lhs;
/* This is used when processing a LISTOF construct which has an empty
 * alternative.
 ***/
{
  char *str;
  int temp, idn;

  obstack_grow(&StrStack, string[lhs], strlen(string[lhs]));
  obstack_grow(&StrStack, "::=", 3);
  obstack_1grow(&StrStack, '\0');
  str = (char *) obstack_finish(&StrStack);
  mkidn(str, strlen(str), &temp, &idn);
  DefineIdn(env, idn);
}

void
MakeAlt (RuleEnv, EquivEnv, lhs, rhs, empty)
Environment RuleEnv, EquivEnv;
int lhs;
int rhs;
int empty;
/* This is used to create a rule string for an alternative in the LISTOF
 * construct.  It also checks for equivalences defined by the IS construct.
 ***/
{
  char *str;
  int temp, idn, equiv;
  DefTableKey key;

  obstack_grow(&StrStack, string[lhs], strlen(string[lhs]));
  obstack_grow(&StrStack, "::= ", 4);
  obstack_grow(&StrStack, string[lhs], strlen(string[lhs]));
  obstack_1grow(&StrStack, ' ');
  key = KeyInEnv(EquivEnv, rhs);
  if (key == NoKey)
    obstack_grow(&StrStack, string[rhs], strlen(string[rhs]));
  else {
    equiv = GetEquiv(key, 0);
    obstack_grow(&StrStack, string[equiv], strlen(string[equiv]));
  }
  str = (char *) obstack_finish(&StrStack);
  mkidn(str, strlen(str), &temp, &idn);
  DefineIdn(RuleEnv, idn);
  if (!empty) {
    obstack_grow(&StrStack, string[lhs], strlen(string[lhs]));
    obstack_grow(&StrStack, "::= ", 4);
    key = KeyInEnv(EquivEnv, rhs);
    if (key == NoKey)
      obstack_grow(&StrStack, string[rhs], strlen(string[rhs]));
    else {
      equiv = GetEquiv(key, 0);
      obstack_grow(&StrStack, string[equiv], strlen(string[equiv]));
    }
    obstack_1grow(&StrStack, '\0');
    str = (char *) obstack_finish(&StrStack);
    mkidn(str, strlen(str), &temp, &idn);
    DefineIdn(RuleEnv, idn);
  }
}  
