static char rcs_id[]="$Id: func.c,v 1.2 1992/07/11 20:55:06 kadhim Exp $";
/* Attribute computations for C output generation */
/* Copyright (c) 1992, The Regents of the University of Colorado */

#include <stdio.h>
#include "err.h"		/* error module */
#include "deftbl.h"		/* definition table */
#include "envmod.h"		/* environment module */
#include "ptg_gen.h"		/* output generation functions */
#include "func.h"
#include "pdl_gen.h"		/* PDL generated functions */
#include "csm.h"		/* string table */

/* global constants */

#define FALSE      0
#define TRUE       1

/* string table indices for predefined operations */
extern int GetHandle, SetHandle;

/* Add a list of operations to those already associated with the given key */
void
addfunclist (key, list)
DefTableKey key;
funclist list;
{
  funclist olist, temp;

  /* Get the current list of operations for the key */
  olist = GetFuncList(key, dummyfunclist);

  /* For each of the functions to add, see if they are already in the list */
  /* and if not add them to the list */
  while (list) {
    temp = olist;
    while (temp && (temp->key != list->key))
      temp = temp->next;
    if (!temp) {
      temp = (funclist) malloc(sizeof(node));
      temp->key = list->key;
      temp->next = olist;
      olist = temp;
    }
    list = list->next;
  }  

  /* Set the appropriate property */
  SetFuncList(key, olist, olist);
}

/* Returns a null funclist */
funclist
nullfunclist ()
{
  return ((funclist) 0);
}

/* Concatenate the key for a single operation onto a list of operations */
funclist
concatfunclist (key, list)
DefTableKey key;
funclist list;
{
  funclist temp;

  if (key == NoKey)
    return list;
  else {
    temp = (funclist) malloc(sizeof(node));
    temp->key = key;
    temp->next = list;
    return temp;
  }
}

/* Return the appropriate operation definition for the given operation */
/* declaration key */
DefTableKey
FindOpKey (env, ident)
Environment env;
int ident;
{
  /* If it is Get or Set, return an invalid key as these operations are */
  /* always generated, otherwise look up the identifier in the operation */
  /* environment */
  if ((ident == GetHandle) || (ident == SetHandle))
    return NoKey;
  else
    return KeyInEnv(env, ident);
}

/* Generate the necessary functions associated with a type */
PTGNode
GenFunctions (key, type, env, list)
DefTableKey key;	/* deftbl key for the type */
int type;		/* string table index for the type name */
Environment env;	/* operation declaration environment */
funclist list;		/* list of operations declared for this type */
{
  PTGNode result;
  DefTableKey SetKey, GetKey;
  OpOutput out;

  /* If this output has not been generated yet, generate it - otherwise */
  /* return no output */
  if (!GetGenFuncs(key, FALSE)) {
    /* First generate both Get and Set operations */
    SetKey=KeyInEnv(env, SetHandle);
    GetKey=KeyInEnv(env, GetHandle);
    result=PTGTypeDef(PTGIdentifier(type), PTGIdentifier(type),
		      PTGIdentifier(type));
    out=GetFuncOut(GetKey,PTGNULL);
    result=PTGSeq(result,PTGOperationSpec(out.rettype,out.opname,
					  PTGIdentifier(type),out.paramlist,
					  out.paramdecls,PTGIdentifier(type),
					  out.text));
    out=GetFuncOut(SetKey,PTGNULL);
    result=PTGSeq(result,PTGOperationSpec(out.rettype,out.opname,
					  PTGIdentifier(type),out.paramlist,
					  out.paramdecls,PTGIdentifier(type),
					  out.text));

    /* For each operation declared in the list, append the output for that */
    /* function to the output already generated */
    while (list) {
      out=GetFuncOut(list->key,PTGNULL);
      result=PTGSeq(result,PTGOperationSpec(out.rettype,out.opname,
					    PTGIdentifier(type),out.paramlist,
					    out.paramdecls,PTGIdentifier(type),
					    out.text));
      list=list->next;
    }

    /* Indicate that the output has now been generated */
    SetGenFuncs(key, TRUE, TRUE);
    return PTGFunctions(PTGIdentifier(type), PTGIdentifier(type), result);
  } else
    return PTGNULL;
}

/* Print an identifier */
void
PrIdent (f, val)
FILE *f; int val;
{
  fprintf(f, "%s", string[val]);
}

/* Build up the structure to hold information for an operation declaration */
OpOutput
BuildOperationSpec (type, opname, paramlist, paramdecls, text)
PTGNode type, opname, paramlist, paramdecls, text;
{
  OpOutput *temp;

  if (!(temp = (OpOutput *) malloc(sizeof(OpOutput))))
    message(DEADLY, "BuildOperationSpec: malloc failed", 0, (POSITION *)0);
  else {
    temp->rettype = type;
    temp->opname = opname;
    temp->paramlist = paramlist;
    temp->paramdecls = paramdecls;
    temp->text = text;
    return *temp;
  }
}
