/** @(#)fo.h	94-09-08	Wil Baden **/

# include	<stdio.h>
# include	<string.h>
# include	<ctype.h>
# include	<limits.h>
# include	<time.h>
# include	<setjmp.h>
# include	<math.h>
# include	<errno.h>

# include	<stdlib.h>

# ifndef	FILENAME_MAX
# define	FILENAME_MAX	64
# endif

# define	MAXLINE			132

# ifndef	SEEK_SET
# define	SEEK_SET		0
# endif

# undef		FORTH83
# define	FORTH83		/* Use Forth-83 canonical true. */

# define    HIGH_BIT	0x80000000
typedef 	long		cell;
typedef		short		instruction;

# define	CODEROOM 	9000 /* was 4500 */
# define	DATAROOM 	21000
# define	NAMEROOM 	7000
# define	CHARACTERROOM  1000
# define	RETURN_STACK_CELLS 60
# define	STACK_CELLS 	250
# define	FSTACK_CELLS	8
# define	COUNTED_STRING_MAX 255
# define	LOCALNAMEROOM 1000
# define	LOCALNAME	(DATAROOM - LOCALNAMEROOM)
# define	maxfiles 8
# define	WIDTH		31
# define	HOLD_CHARS	80
# define	SHELF_CHARS	1024
# define	pocket		(NAMEROOM - HOLD_CHARS)
# define	wall		(pocket - SHELF_CHARS)

# define	UNBRACKET	']'
# define	PARAMETER	'~'
# define	EOL	'\n' /* or '\r' */
# define	EOS	'\0'
# define	SPACE	' '
# define	TICK '\''
# define	QUOTE '\"'

# undef 	FALSE
# undef 	TRUE
# define	FALSE	0
# define	TRUE	~0
# ifdef 	FORTH83
# define	LOGICAL ? TRUE : FALSE
# else
# define	LOGICAL
# endif
# ifndef EXIT_FAILURE
# define	EXIT_FAILURE	1
# endif
# ifndef EXIT_SUCCESS
# define	EXIT_SUCCESS	0
# endif

# define	CURRENT	7
# define	CONTEXT 8

# define	compilation	code[code[CURRENT]]

# define	WORDLISTS	8

/*# define LOWER(x,y) (((x)^(y))&HIGH_BIT?((y)&HIGH_BIT)!=0:(x)<(y))*/
# define LOWER(x,y) ((unsigned long)(x)<(unsigned long)(y))

/* Assumes sizeof(cell) is a power of 2. */
# define	aligned(x)	((x) + (sizeof(cell) - 1) & ~(sizeof(cell) - 1))
# define	data(x)	*(cell*)&data[x]
# define	c(x)	code[next++] = x
# define	char()	(cp != cpp ? *--cp : getc(usrin))
# define	code(w)	(w + 2)		/* Execution Token */
# define	element -
# define	emit(c) putc(c, usrout)
# define	filterword(s) \
 while(!lexer(&name[s]))if(!stream())exit(parg<pargc) 
# define	fpop	ftop = *F--, floatcheck()
# define	fpush	*++F = ftop, floatcheck(), ftop =
# define 	isshort(w) (SHRT_MIN <= (w) && (w) <= SHRT_MAX)
# define	leave	break
# define	lookup(link, s) link = (lookup)(s)
# define	name	data
# define	next	code[0]
# define 	operand code[next - 1]
# define	operation code[next - 1]
# define	pop	top = *S--
# define	push	*++S = top, top =
# define	recurse	goto RECURSE
# define	source	code[1]
# define	unchar(c)	*cp++ = (c)

void	adopt		(int x);
void	condition	(void);
void	fliteral		(void);
void	interpret	(int n);
long	IntSqrt		(long x);
int 	lexer		(unsigned char *charp);
void	literal		(void);
int	(lookup)	(int s);
int 	main		(int argc, char** argv);
void*   (move)          (void * dest, void * src, long len);
void	monocase	(int caddr);
void	parse		(int delimiter);
void	parseword	(int delimiter);
void	rake		(void);
void	restart		(void);
int	searchwordlist	(unsigned char* str, int wid);
void	scale		(void);
int     shelve      (void);
void	sorry		(char* error);
FILE*	stream		(void);
void	stringcompile	(void);
long    tonumber	(char *nptr, char **endptr, int base);
void	type		(unsigned char* str, int n);
void	udiv		(void);
void	umul		(void);
void	smul	        (void);
void	sdiv		(void);
void	fdiv		(void);

# ifdef THINK_C
# define main(argc,argv) MAIN(argc,argv)
# endif
# ifdef __MWERKS__
# define main(argc,argv) MAIN(argc,argv)
# endif

# ifdef main
int 	MAIN		(int argc, char** argv);
# endif

