static char sccsid[] = "@(#)ThisForth Beta Wil Baden 94-09-12";
# include "fo.h"

# define nestingcheck()	if ((unsigned)(R - rack) >= RETURN_STACK_CELLS - 2)\
			sorry("(Nesting Error)")

# define stackcheck() if ((unsigned)(S - stack) >= STACK_CELLS - 2)\
			sorry("(Stack Error)")

include(`llfc.m4')

static void literalize(int normally, int literally);

define(`OPTIMIZE')

/*` Optimize:	n `$1'    x n `$1'    '*/
define(`Literalize',
	`ifdef(`OPTIMIZE',

	`Immediate(`$1') ifelse(`$4',,,

	`if (state && equal(doLITERAL,previous,preceding))
		push code[next-3] `$4' code[next-1],
		next -= 4, previous = 0, literal();
	else')
	
	literalize(NEXT, incr(NEXT)); Done
	Behavior `$2'; Done	Behavior `$3'; Done',

	`Execution(`$1') `$2'; Done')')

define(`equal',`(`$1' == `$2' && `$1' == `$3')')

static void (nestingcheck)(void);
static void (stackcheck)(void);

define(`REDUNDANT')
define(`ENHANCEMENT')

/* This is sacred.*/

Primitive /* `For literals' */
	push code[I++];
Done

define(`beORDINARY',OPER)

Primitive /* `For ordinary words' */
	if (! state)
		interpret(xt);
	else
		latest = c(xt);
Done

define(`beNEST',OPER)

Primitive /* `For nesting' */
	nestingcheck();
	*++R = I, I = xt;
Done

Com(0) Com(0)

define(`doLITERAL',NEXT) /* Must contain 0 */ Com(0)

Execution(`EXIT') define(`doEXIT',THIS)
	stackcheck();
	I = *R--;
Done

/* The following are placed here to be easy to find. */

/* CURRENT */ Com(0) /* CONTEXT */ times(WORDLISTS,`Com(0)')

/* CURRENT and CONTEXT should be defined in fo.h */

define(`FORTH',NEXT) times(NEW_WORDLISTS,`Com(-1)')

define(`GILDED',(NEXT - CURRENT))dnl

/* Such is sacred. */

Behavior define(`doFILTEREXECUTE',THIS)
{
	char * pp;
	
	if (state) preceding = previous, previous = latest ;
	filterword(pocket);
	lookup(link, pocket);
	if (link) {
		latest = xt = code(link);
		recurse;
	}
	pp = (char *) &name[pocket + 1];
	w = tonumber(pp, &charp, BASE);
	if (* charp == EOS)
		push w, literal();
	else if (pp != charp && charp[0] == '.' && charp[1] == EOS)
		push w, literal(), push w < 0 ? -1 : 0, literal();
	else if (pp != charp && strchr("+-*/,<=>", charp[0]) != NULL) {
		push w, literal();
		unchar(SPACE);
		for (n = strlen(charp); n; unchar(charp[--n])) ;
	} else {
ifdef(`FLOAT',`
		if (BASE == 10
		&& (f = strtod((char *) &name[pocket + 1], &pp), *pp == EOS)
		)
			fpush f, fliteral();
		else
')
			HUH ;
	}
}
Done

void interpret(int n)
{
	code[TRAMPOLINE] = n;
	code[TRAMPOLINE + 1] = doEXIT;
	*++R = I, I = TRAMPOLINE;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

define(`doBRANCH',NEXT)
	Behavior I += code[I]; Done

define(`beCONSTANT',OPER)
	Primitive
		push code[xt], literal();
	Done

define(`beLCONSTANT',OPER)
	Primitive
		u.Short[0] = code[xt++], u.Short[1] = code[xt],
			push u.Long, literal();
	Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* `: EXPOUND BEGIN filterexecute AGAIN ;' */

WORD(`expound') ADOPT(beORDINARY) Com(beNEST)
	BEGIN Com(doFILTEREXECUTE) AGAIN dnl

/* `: QUIT restart EXPOUND ;' */

Execution(`QUIT') restart(); Done
	define(`doQUIT',THIS)

Execution(`ABORT')
	type(&name[source+1], name[source]);
	S = stack; top = *S = 0;
	restart();
Done
	define(doABORT,THIS)

Execution(`BYE') longjmp(jmpbuf, 2); Done
	define(`doBYE',THIS)

Immediate(`;') COMPILE_ONLY
	if (leaves) sorry("leave ?") ;
	if
	( previous != doBRANCH
	&& previous != doEXIT
	&& previous != doQUIT
	&& previous != doABORT
	&& previous != doBYE
	)
		c(doEXIT);
	state = FALSE;
	if (current && code[current + 1]) code[code[CURRENT]] = current ;
	code[next] = last = current ;
	if (level != S - stack)
		type(&name[code[current +1]+1],name[code[current+1]]),
			fprintf(usrout, " (Incomplete) " ) ;
	here = aligned(here);
	if (next >= TRAMPOLINE)
		sorry("(Code space exceeded)");
	if (finger >= wall - sizeof(cell))
		sorry("(Name space exceeded)");
Done

Execution(`:')
	adopt(beORDINARY), c(beNEST);
	last = code[last];
	level = S - stack;
	leaves = 0;
	state = TRUE;
Done

static void literalize(int normally, int literally)
{
	if (! state)
		interpret(normally);
	else if (previous == doLITERAL)
		latest = code[next-2] = literally, previous = preceding;
	else
		latest = c(normally);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Stack Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Execution(`DROP') pop; Done define(`doDROP',THIS)
Execution(`DUP') *++S = top; Done define(`doDUP',THIS)
Execution(`NIP') S--; Done
Execution(`OVER') push S[-1]; Done define(`doOVER',THIS)

Immediate(`ROT')
Optimization
	if (previous == NEXT) 
		latest = code[next-1] = incr(NEXT), previous = preceding;
	else if (previous == incr(NEXT))
		--next, latest = preceding, previous = 0;
Execution
	Behavior
		w = S[-1], S[-1] = *S, *S = top, top = w;
	Done
	Behavior
		w = top, top = *S, *S = S[-1], S[-1] = w;
	Done

Execution(`SWAP') w = top, top = *S, *S = w; Done define(`doSWAP',THIS)
Execution(`?DUP') if (top) *++S = top ; Done define(`doQUEDUP',THIS)
Execution(`2DROP') S--, pop; Done
Execution(`2DUP') w = *S, *++S = top, *++S = w; Done
Execution(`2OVER') push S[-2], w = S[-3], *++S = w; Done

Execution(`2SWAP')
	w = S[-1], S[-1] = top, top = w;
	w = S[-2], S[-2] = *S, *S = w;
Done

/*` Optimize:	n PICK    '*/
Literalize(`PICK',`top = S[-top]',`push S[-code[I++]]')

Execution(`ROLL')
	for (n = top, top = S[-top]; n; --n)
		S[-n] = S[-(n - 1)];
	S--;
Done

Execution(`>R') *++R = top, pop; Done
Execution(`R>')  push *R--; Done
Execution(`R@') push *R; Done

ENHANCEMENT(`
Execution(`BACK') w = *S--, S[-top] = w, pop; Done
Execution(`BACK+') w = *S--, S[-top] += w, pop; Done
Execution(`DISCARD') S -= top, pop; Done

Execution(`KEEP')
	/* Keep the top k of n stack elements. */
	for (n = 0; n < *S; ++ n)
		S[-(top - n)] = S[-(*S - n)];
	S -= top - *S + 1, pop;
Done
')

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Data Space Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*` Optimize:	x @    '*/
Literalize(`@',`top = data(top)',`push data(code[I++])')
/*` Optimize:	x !    '*/
Literalize(`!',`data(top) = *S--, pop',`data(code[I++]) = top, pop')
/*` Optimize:	x +!    '*/
Literalize(`+!',`data(top) += *S--, pop',`data(code[I++]) += top, pop')
Execution(`C@') top = data[top]; Done
Execution(`C!') data[top] = *S--, pop; Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Status Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Execution(`DEPTH') push S - stack - 1; Done
Execution(`HERE') push here; Done
Execution(`NESTING') push R - rack; Done
Execution(`OUTSIDE') push S - stack - 1 - level; Done
Execution(`SOURCE-ID') push files ? (cell) usrin : 0; Done
Execution(`UNUSED') push DATAROOM - here; Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Arithmetic and Logical Operations */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*` Optimize:	n LSHIFT    x n LSHIFT    '*/
Literalize(`LSHIFT',`top = *S-- << top',`top = top << code[I++]',`<<')

	define(`doLITLSHIFT',THIS)

/*` Optimize:	 n +    x n +    x + n +    0 +   '*/
Immediate(`+') define(`doPLUS',THIS)
Optimization
	if (previous == doLITERAL) {
		if (preceding == doLITERAL) {
			w = code[next-3] + code[next-1];
			if (isshort(w))
				next -= 2, operand = w, latest = doLITERAL;
			else
				push w, next -= 4, literal(), latest = c(NEXT);
			previous = 0;
		} else if (preceding == incr(NEXT)) {
			w = code[next-3] + code[next-1];
			if (w == 0)
				next -= 4, latest = 0;
			else if (isshort(w))
				next -= 2, operand = w, latest = incr(NEXT);
			else
				next -= 4, push w, literal(), latest = c(NEXT);
			previous = 0;
		} else {
			if (operand == 0)
				next += -2, latest = preceding, previous = 0;
			else
				latest = code[next-2] = incr(NEXT),
					previous = preceding;
		}
	}
Execution
	Behavior top += *S--; Done
	Behavior top += code[I++]; Done

/*` Optimize:	 n -    x n -    x + n -    0 -    SWAP -    '*/
Immediate(`-')
Optimization
	if (previous == doLITERAL && operand != SHRT_MIN) {
		operand = -operand, xt = latest = doPLUS;
		recurse;
		/*NOTREACHED*/
	} else if (previous == doSWAP)
		latest = operation = incr(NEXT), previous = preceding;
Execution
	Behavior top = *S-- - top; Done
	Behavior top -= *S--; Done

/*` Optimize:	x n *    b *    1 *    '*/
Immediate(`*')
Optimization
	if (previous == doLITERAL) {
		if (preceding == doLITERAL)
			push operand, next += -2,
				top *= operand, next += -2,
					previous = 0, literal();
		else if ((operand & operand - 1) == 0) {
			for (n = 0; (operand = (unsigned) operand >> 1) != 0; ++ n)
				;
			if (n)
				latest = code[next-2] = doLITLSHIFT, operand = n;
			else
				next -= 2, latest = previous, previous = preceding;
		} else
			c(NEXT);
	}
Execution
	Behavior top *= *S--; Done

/*` Optimize:	x n /    1 /    '*/
Immediate(`/')
Optimization
	if (previous == doLITERAL) {
		if (operand == 1)
			next -= 2, latest = preceding, previous = 0;
		else if (preceding == doLITERAL)
			push code[next-3] / code[next-1],
				next -= 4, previous = 0, literal();
		else
			latest = c(NEXT);
	}
Execution
	Behavior top = top ? *S-- / top : (S--, 0) ; Done

Execution(`2/') top = (signed long) top >> 1; Done

Execution(`>') top = *S-- > top LOGICAL; Done
/*` Optimize:	n <    '*/
Literalize(`<',`top = *S-- < top LOGICAL',`top = top < code[I++] LOGICAL')

/*` Optimize:	n =    n OVER =    DUP n =   '*/
Immediate(`=')
Optimization
	if (previous == doLITERAL) {
		if (preceding == doDUP)
			-- next,
				latest = code[next-2] = NEXT + 2,
					operand = code[next], previous = 0;
		else
			latest = code[next-2] = NEXT + 1, previous = preceding;
	} else if (previous == doOVER && preceding == doLITERAL)  {
		-- next; latest = code[next-2] = NEXT + 2, previous = 0;
	}
Execution
	Behavior top = *S-- == top LOGICAL; Done
	Behavior top = top == code[I++] LOGICAL; Done define(`doLITEQUAL',THIS)
	Behavior push top == code[I++] LOGICAL; Done

/*` Optimize:	n ALIGNED    '*/
Immediate(`ALIGNED')
Optimization
	if (previous == doLITERAL)
		operand = aligned(operand),
			latest = doLITERAL,
				previous = preceding;
Execution
	Behavior top = aligned(top); Done

Execution(`ALLOT') here += top, pop; Done

/*` Optimize:	n AND    x n AND    '*/
Literalize(`AND',`top &= *S--',`top &= code[I++]',`&')
	define(`doLITAND',THIS)

/*` Optimize:	n CELLS    '*/
Immediate(`CELLS')
Optimization
	if (previous == doLITERAL)
		push operand, next += -2, top *= sizeof(cell),
			previous = preceding, literal();
Execution
	Behavior top *= sizeof(cell); Done

Execution(`COMPARE') /* c-addr1 u1 c-addr2 u2 -- n */
/*
Compare the string specified by c-addr1 u1 to the string specified by
c-addr2 u2.

The strings are compared, beginning at the given addresses, character by
character, up to the length of the shorter string or until a difference
is found.

If the two strings are identical, n is zero.

If the two strings are identical up to the length of the shorter string,
n is minus-one (-1) if u1 is less than u2 and one (1) otherwise.

If the two strings are not identical up to the length of the shorter
string, n is minus-one (-1) if the first non-matching character in the
string specified by c-addr1 u1 has a lesser numeric value than the
corresponding character in the string specified by c-addr2 u2 and one
(1) otherwise.
*/
	n = S[-1] < top ? S[-1] : top;
	d = memcmp((char *) &data[S[-2]], (char *) &data[*S], n);
	if (d == 0 && S[-1] != top)
		d = S[-1] < top ? -1 : 1;
	S -= 3;
	top = d;
Done

/*` Optimize:	b MOD    '*/
Immediate(`MOD')
Optimization
	if (previous == doLITERAL && (operand & operand - 1) == 0)
		latest = code[next-2] = doLITAND,
			-- operand, previous = preceding;
Execution
	Behavior top = top ? *S-- % top: *S--; Done

Execution(`/MOD')
	if (top != 0)
		w = *S / top, *S -= w * top, top = w;
Done

WORD(`*/mod')define(`NAME',``SCALE'')
ADOPT(beORDINARY)Com(OPER)Primitive
	scale();
Done

Execution(`NEGATE') top = -top; Done

/*` Optimize:	n OR    x n OR    '*/
Literalize(`OR',`top |= *S--',`top |= code[I++]',`|')

/*` Optimize:	n RSHIFT   x n RSHIFT    '*/
Immediate(`RSHIFT')
	if (state && equal(doLITERAL, previous, preceding))
		w = code[next - 3],
			push (unsigned long) w >> code[next-1],
				next -= 4, previous = 0, literal();
	else
		literalize(NEXT, incr(NEXT));
Done
	Behavior top = (unsigned long) *S-- >> top; Done
	Behavior top = (unsigned long) top >> code[I++]; Done

Execution(`U>') top = LOWER(top, *S) LOGICAL; S--; Done

/*` Optimize:	n U<    '*/
Literalize(`U<',`top = LOWER(*S, top) LOGICAL; S--',
	`top = LOWER(top, code[I]) LOGICAL; I++')

/*` Optimize:	n UNDER+    '*/
Literalize(`UNDER+',`S[-1] += top, pop',`*S += code[I++]')
/*` Optimize:	n XOR    x n XOR    '*/
Literalize(`XOR',`top ^= *S--',`top ^= code[I++]',`^')

REDUNDANT(`
Execution(`WITHIN') /* OVER - >R - R> U< */
	w = *S--,
	top = LOWER(*S - w, top - w) LOGICAL;
	S--;
Done
')

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* `Control Flow' */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

define(`CONDITION',`condition();')dnl
define(`BRANCH',`c(doBRANCH);')dnl

/*` Optimize:
	{ DUP   ?DUP   0=   DUP 0=   ?DUP 0=   0<> } { IF WHILE UNTIL }
'*/
void condition(void)
{
	if (previous == doDUP)

		latest = operation = NEXT;
		
		Behavior I += top ? 1 : code[I]; Done
	
	else if (previous == doQUEDUP)

		latest = operation = NEXT;
	
		Behavior I += top ? 1 : (pop, code[I]); Done
	
	else if (previous == doLITERAL && operand == 0)
	
		-- next, latest = operation = doBRANCH;
ENHANCEMENT(`
	else if (previous == doEQUAL)
	
		latest = operation = NEXT;
		
		Behavior I += *S-- == top ? 1 : code[I], pop; Done
')
	else if (previous == doLITEQUAL && operand == 0) {

		if (preceding == doDUP)

			next -= 2, latest = operation = NEXT;

			Behavior I += top ? code[I] : 1; Done

		else if (preceding == doQUEDUP)
		
			next -= 2, latest = operation = NEXT;

			Behavior I += top ? code[I] : (pop, 1); Done
ENHANCEMENT(`
		else if (previous == doEQUAL)
		
			next -= 2, latest = operation = NEXT;
			
			Behavior I += *S-- != top ? 1 : code[I], pop; Done
')			
		else if (preceding == doLITEQUAL && code[next - 3] == 0)
		
			/* Must be the next to last test. */

			next -= 3, latest = operation = incr(NEXT);

		else
		
			-- next, latest = operation = NEXT;

			Behavior I += top ? code[I]: 1, pop; Done
		
	} else

		latest = c(NEXT);

		Behavior I += top ? 1 : code[I], pop; Done

}

Immediate(`IF') SELF_COMPILE
	CONDITION
	push next, c(0);
Done

Immediate(`ELSE') COMPILE_ONLY
	BRANCH
	if (top <= 0 || code[top]) HOW ;
	w = top, top = next, c(0);
	code[w] = next - w;
Done

Immediate(`THEN') COMPILE_ONLY
	if (top <= 0 || top >= next || code[top]) HOW ;
	code[top] = next - top, pop;
							COMPLETE
Done

Immediate(`CASE') SELF_COMPILE
	push 0;
Done

Immediate(`ESAC') COMPILE_ONLY
	while (top) {
		if (top <= 0 || top >= next || code[top]) HOW ;
		code[top] = next - top, pop;
	}
	pop; COMPLETE
Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Immediate(`BEGIN') SELF_COMPILE
	push next;
Done

Immediate(`WHILE') COMPILE_ONLY
	CONDITION
	*++S = next, c(0);
Done

Immediate(`UNTIL') COMPILE_ONLY
	if (previous == doLITERAL && operand)
		next -= 2;
	else {
		CONDITION
		n = next, c(top - n);
	}
	if (top <= 0 || ! code[top]) HOW ;
	pop; COMPLETE
Done

Immediate(`REPEAT') COMPILE_ONLY
	BRANCH
	if (top <= 0 || ! code[top]) HOW ;
	w = next, c(top - w), pop;
	if (top <= 0 || code[top]) HOW ;
	code[top] = next - top, pop;
							COMPLETE
Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Immediate(`DO') SELF_COMPILE
	c(NEXT), push -next;
Done
	Behavior
		*++R = *S, *++R = top - *S--, pop;
	Done

Immediate(`?DO') SELF_COMPILE
	c(NEXT), push -next, c(0);
Done
	Behavior
		I += top == *S ? code[I]
			: (*++R = *S, *++R = top - *S, 1),
				S--, pop;
	Done

Execution(`UNLOOP') define(`doUNLOOP',THIS)
	R -= 2;
Done

Immediate(`LEAVE') COMPILE_ONLY
	c(doUNLOOP), c(doBRANCH), c(leaves);
	leaves = next - 1;
Done

Immediate(`LOOP') define(`doLOOP',THIS) COMPILE_ONLY
	if (top >= 0) HOW ;
	c(NEXT);
	rake(); COMPLETE
Done
	Behavior
		if ((++ * R) == 0)
			++ I, R -= 2;
		else
			I += code[I];
	Done

/*` Optimize:	1 +LOOP   '*/
Immediate(`+LOOP') COMPILE_ONLY
	if (previous == doLITERAL && operand == 1) {
		next -= 2;
		xt = latest = doLOOP, previous = preceding;
		recurse;
	}
	if (top >= 0) HOW ;
	c(NEXT);
	rake(); COMPLETE
Done
	Behavior
		w = *R, *R += top;
		if ((w ^ *R) < 0 && (w ^ top) < 0)
			++ I, R -= 2;
		else
			I += code[I];
		pop;
	Done

void rake(void)
{	/* Gather the leaves.*/
	int n = next;
	top = - top;
	if (code[top])
		c(top - n);
	else
		c(top + 1 - n), code[top] = next - top;
	for ( ; leaves > top; leaves = n)
		n = code[leaves], code[leaves] = next - leaves;
	pop;
}

Execution(`I') push R[0] + R[-1]; Done
Execution(`J') push R[-2] + R[-3]; Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Nominate(`Left Parenthesis')define(`LENGTH',1)
1,40, /* 40 == left parenthesis */ ADOPT(OPER)Primitive
	if (state) latest = previous, previous = preceding ;
	while (
		(c = char()) != ')'
	&&
		c != EOF
	&&
		! (usrin == stdin && c == EOL)
	) ;
Done

/*` Optimize:	n >BODY   ['] x >BODY    '*/
Immediate(`>BODY')
Optimization
	if (previous == doLITERAL)
		operand = code[operand + 1],
			latest = doLITERAL,
				previous = preceding;
Execution
	Behavior top = code[top + 1]; Done

Immediate(`C\"')
	parse(QUOTE);
	if (! state)
		push shelve();
	else {
		latest = c(doLITERAL);
		stringcompile();
	}
Done

Execution(`GET-CHAR') *++S = top, top = char(); Done
Execution(`STACK-CHAR') unchar(top), pop; Done

Execution(`NEXT-CHAR')
	*++S = top, top = char();
	if (top != EOF) unchar(top) ;
Done

/*` Optimize:	n COUNT    C" ccc" COUNT    '*/
Literalize(`COUNT',`*++S = top + 1; top = data[top]',
	`w = code[I++];	push data[w]; *++S = w + 1'
)
	define(`doSLITERAL',THIS)

Execution(`CR') emit(EOL); Done
Execution(`EMIT') emit(top); pop; Done
Execution(`EXECUTE') xt = top, pop; recurse; Done

Execution(`FIND')
	memcpy(&name[finger], &name[top], name[top] + 1);
	lookup(link, finger);
	if (link)
		*++S = code(link),
			top = code[code(link)] == beORDINARY ? -1 : 1;
	else
		push 0;
Done

Execution(`FILL')
	memset(data + S[-1], top, *S), S -= 2, pop;
Done

Execution(`IMMEDIATE')
	if (code[code(last)] == beORDINARY)
		code[code(last)] = eval(OPER + 1);
	else if (code[code(last)] == beCONSTANT)
		code[code(last)] = eval(OPER + 2);
	else
		sorry("(Can't be made `IMMEDIATE')") ;
Done
	define(`beIMMEDIATE',OPER)
	Primitive recurse; Done
	Primitive push code[xt]; Done

Execution(`INLINE')
	if (code[code(last)] != beORDINARY || code[code(last) + 1] != beNEST)
		HOW ;
	/* Set immediate behavior to copy compiled code to object. */
	code[code(last)] = incr(OPER);
	code[code(last) + 1] = next - 3 - code(last);
Done
	Primitive
		if (state)
			for (n = 0; n < code[xt]; ++ n)
				c(code[xt + 1 + n]);
		else
			*++R = I, I = xt + 1;
	Done

Immediate(`LITERAL') literal(); Done

void literal(void)
{
	if (! state) return ;
	if (isshort(top))
		latest = c(doLITERAL), c(top);
	else
		u.Long = top, latest = c(NEXT),
			c(u.Short[0]), c(u.Short[1]);
	pop;
}
	Behavior
		u.Short[0] = code[I++], u.Short[1] = code[I++], push u.Long;
	Done

Execution(`MOVE')
	move(&data[*S], &data[S[-1]], top), S -= 2, pop;
Done

Execution(`:NONAME')
	current = next, dataspace = here, namespace = finger;
	c(0), c(0); push next;
	c(beORDINARY), c(beNEST);
	level = S - stack;
	leaves = 0;
	state = TRUE;
Done

Immediate(`PLEASE') SELF_COMPILE
	c(NEXT);
	n = 0;
	do d = char(); while (! isgraph(d)) ;
	while ((c = char()) != d && c != EOF) {
		if (n < COUNTED_STRING_MAX)
			name[++ n + finger] = c ;
		if (c == EOL) {
			while (isspace(c = char())) ;
			unchar(c);
		}
	}
	name[finger] = n;

	stringcompile();
	COMPLETE
Done
	Behavior
		latest = previous, previous = preceding;
		d = 1; /* Non-zero */
		for (n = name[code[I]]; n; -- n)
			if ((c = name[code[I] + n]) != PARAMETER)
				unchar(c);
			else if (n > 1
			&& name[code[I] + n - 1] == PARAMETER)
				unchar(PARAMETER), -- n;
			else
				for (d = top; d > 0; )
					unchar(data[* S + --d]);
		I++;
		if (! d) S-- , pop ;
	Done

Immediate(`RECURSE') COMPILE_ONLY
	c(code(current) + 1);
Done

Execution(`SEARCH-WORDLIST') /* c-addr u wid -- 0 | xt 1 | xt -1 */
/*
Find the definition identified by the string c-addr u in the word list
identified by wid . If the definition is not found, return zero. If
the definition is found, return its execution token xt and one (1) if
the definition is immediate, minus-one (-1) otherwise.
*/
	/* Make counted string at finger from S[-1],*S */
	move(&name[finger + 1], &data[S[-1]], data[* S]);
	name[finger] = *S--, S--;
	monocase(finger);
	source = finger;
	if ((link = searchwordlist(&name[finger], top)) != 0)
		*++S = code(link),
			top = code[code(link)] == beORDINARY ? -1 : 1;
	else
		top = 0;
Done

Execution(`SPACES')
	while (top-- > 0) emit(SPACE) ;
	pop;
Done

Execution(`STATE')
	data(wall - sizeof(cell)) = state;
	push wall - sizeof(cell);
Done

Execution(`TIME&DATE')
{
	struct tm * broken_down_time;
	time_t time_now;

	time_now = time(NULL);
	broken_down_time = localtime(&time_now);
	push broken_down_time->tm_sec;
	push broken_down_time->tm_min;
	push broken_down_time->tm_hour;
	push broken_down_time->tm_mday;
	push broken_down_time->tm_mon + 1;
	push broken_down_time->tm_year + 1900;
}
Done

Execution(`TYPE') type(&data[*S--], top), pop; Done

Execution(`WORD')
	parseword(top);
	top = shelve();
Done

Execution(`PARSE')
	parse(top);
	*++S = shelve() + 1, top = name[*S - 1];
Done

Immediate(`SLITERAL')
	if (state) {
		/* Make counted string at finger from *S,top */
		move(&name[finger+1], &data[*S--], top);
		name[finger] = top, pop;
		latest = c(doSLITERAL);
		stringcompile();
	}
Done

Immediate(`[')
	if (state) latest = previous, previous = preceding ;
	state = FALSE;
Done

Immediate(`\\')
	if (state) latest = previous, previous = preceding ;
	while ((c = char()) != EOF && c != EOL) ;
	unchar(EOL);
Done

Execution(`]') state = TRUE; Done

Execution(`D+')
	S[-2] += *S;
	top += S[-1] + LOWER(S[-2], *S);
	S -= 2;
Done

Execution(`D-')
	top = S[-1] - top - LOWER(S[-2], *S);
	S[-2] -= *S;
	S -= 2;
Done

Execution(`UM*') umul(); Done
Execution(`UM/MOD') udiv(); Done
Execution(`M*') smul(); Done
Execution(`SM/REM') sdiv(); Done
Execution(`FM/MOD') fdiv(); Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* `CONSTANT' `DOES>' */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Execution(`CONSTANT')
	if (isshort(top))
		adopt(beCONSTANT), c(top);
	else
		adopt(beLCONSTANT),
			u.Long = top, c(u.Short[0]), c(u.Short[1]);
	pop;
	code[code[CURRENT]] = code[next] = last = current;
	here = aligned(here);
Done

Execution(`DOES>')
	if (code[code(last)] == beCONSTANT) {
		code[next-2] = OPER + 1, c(OPER + 2), c(I);
		code[next] = last = current;
	} else if (code[code(last)] == OPER + 1
	       || code[code(last)] == OPER + 3)
	{
		code[code(last) + 3] = I;
	} else if (code[code(last)] == beIMMEDIATE + 1)  {
		code[next-2] = OPER + 3, c(OPER + 2), c(I);
		code[next] = last = current;
	} else HOW ;
	I = *R--;
Done
	Primitive
		if (! state)
			interpret(++xt);
		else
			c(++xt);
	Done
	Primitive
		push code[xt - 2];
		*++R = I, I = code[xt];
	Done
	Primitive
		++xt; recurse;
	Done

Execution(`|') if (anonymous) HOW ;
	anonymous = TRUE;
Done

Execution(`||') if (anonymous) HOW ;
	for (link = code[code[CURRENT]]; localname != LOCALNAME; link = code[link]
)
		if (code[link + 1] >= LOCALNAME)
			localname = code[link + 1], code[link + 1] = 0;
	anonymous = FALSE;
Done

WORD(`base') ADOPT(beCONSTANT) Com(NAMEROOM)

Execution(`MARKER') if (anonymous) HOW ;
	adopt(beORDINARY), c(incr(OPER)), c(namespace), c(here);
	for (n = 0; n < GILDED; ++ n)
		c(code[CURRENT + n]);
	code[code[CURRENT]] = code[next] = last = current;
Done
Primitive
	next = xt - 4;
	finger = code[xt++];
	here = code[xt++];
	for (n = 0; n < GILDED; ++ n)
		code[CURRENT + n] = code[xt++];
	code[code[CURRENT]] = last = current = code[next];
Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* File primitives. */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Execution(`STREAM')
	cpps[files] = cpp, cpp = cp;
	file[files ++] = usrin;
	usrin = top ? (FILE *) top : stdin;
	pop;
Done

Execution(`UNSTREAM')
	if (files)
		usrin = file[--files],
			cp = cpp,
				cpp = cpps[files];
	else
		if (stream() == NULL)
			usrin = stdin;
Done

Execution(`DISPLAY')
	usrout = top ? (FILE *) top : stdout;
	pop;
Done

Execution(`FOPEN')
{	/* Standard C Library */
	char filemode[4];
	/* Make NUL-terminated string at &name[pocket+1] from S[-2],S[-1] */
	move(&name[pocket + 1], &name[S[-2]], S[-1]),
		name[pocket + S[-1] + 1] = EOS,
			name[pocket] = S[-1];
	/* Make NUL-terminated string at filemode from *S,top */
	move(filemode, &name[* S], top), filemode[top] = EOS;
	S -= 3;
	top = (cell) fopen((char *)&name[pocket + 1], filemode);
}
Done

Execution(`FFLUSH') top = fflush((FILE *) top); Done

Execution(`FCLOSE')
	top = (cell) fclose(top ? (FILE *) top : usrin);
Done

Execution(`FSEEK')
	if (! S[-1] || (FILE *) S[-1] == usrin) cp = cpp ;
	top = fseek(S[-1] ? (FILE *) S[-1] : usrin, *S, top);
	S -= 2;
Done

Execution(`FTELL')
	top = ftell(top ? (FILE *) top : usrin) - (cp - cpp);
Done

Execution(`ERROR?') push errno, errno = 0; Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Implementation Words */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

Execution(`HAS') top = code[top]; Done

Execution(`PATCH') code[top] = *S--, pop; Done

Execution(`ARGUMENT')
	if (++parg < pargc) {
		name[finger] = strlen(pargv[parg]);
		strcpy((char *) &name[finger + 1], pargv[parg]);
	} else
		name[finger] = 0;
	n = shelve();
	push name[n], *++S = n + 1;
Done

Execution(`SYSTEM')
	/* Make NUL-terminated string at &name[finger] from *S,top */
	move(&name[finger], &name[*S--], top);
	name[finger + top] = EOS;
	top = system((char *) &name[finger]);
Done

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

sinclude(`custom.m4')

Execution(`VERSION')
	fprintf(stderr, "%s   OPER Primitives\n", sccsid);
	fprintf(stderr, "Used: Codespace %d, Namespace %d, Dataspace %d\n",
		next, finger, here);
Done

ifdef(`EXTENDED',`include(`rth.m4')')

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

divert(MAIN)

# define SELF_COMPILE if (! state) namespace=finger,dataspace=here,\
	state=TRUE,progress=next,next=TRAMPOLINE+2,colevel=S-stack;
# define COMPLETE if (progress && colevel == S-stack)\
	c(doEXIT),finger=namespace,next=progress,progress=0,state=FALSE,\
		*++R=I, I=TRAMPOLINE+2;
# define HOW sorry("(Misused)");
# define HUH sorry("(Unknown)");
# define COMPILE_ONLY if (! state) sorry("(Compile Only)") ;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

FILE * usrin = stdin, * usrout = stdout;
int parg; int pargc; char ** pargv;

unsigned char * word;

unsigned char data[DATAROOM] = { 0, /* `Next name at' FINGER */
	undivert(NAMESPACE)
};

instruction code[CODEROOM]={ /* `Next instruction at' NEXT */
	undivert(CODESPACE)
};

char CS[CHARACTERROOM];

union { double Double; long Long; short Short[4]; } u;

cell rack[RETURN_STACK_CELLS], *R = rack;
cell stack[STACK_CELLS], *S = stack, top;
double fstack[FSTACK_CELLS], *F = fstack, ftop; /* floating point stack */

unsigned int current, context, last, link, I;
int colevel, finger, here, leaves, level, progress, state = FALSE;
int shelf = wall;
int dataspace, namespace;
int latest, previous, preceding;
int localname = LOCALNAME;
int anonymous = FALSE;

FILE * file[maxfiles];
char* cpps[maxfiles]; /* Character Pointer Pointer Stack */
char* cpp = CS; /* Character Pointer Pointer */
char* cp = CS; /* Character Pointer */
int files = 0;

jmp_buf jmpbuf;

undivert(UTILITIES)

int main(int argc, char ** argv)
{ /* Skeleton for the Kernel */
	register xt;
	register int n;
	register int c;
	int d;
	cell w;
	char *charp;
ifdef(`FLOAT',`
	double f;
')
	pargc = argc, pargv = argv;
	BASE = 10;
	finger = FINGER;
	next = NEXT;
	current = 0, code[next] = code[FORTH] = last = LAST;
	code[CURRENT] = code[CONTEXT] = FORTH;
	here = NAMEROOM + sizeof(cell);

	if (stream() == NULL) return EXIT_FAILURE ;
# ifdef HI
	unchar(EOL), unchar('I'), unchar('H');
# endif
	switch (setjmp(jmpbuf))
	{
	case 0: case 1: break;
	case 2: return EXIT_SUCCESS;
	default: return EXIT_FAILURE;
	}
	I = START;
	R = rack;
	rack[0] = 0;
	for (;/* ever */;) { /* `INNER INTERPRETER' */
		xt = code[I++]; /* `Number of codes' = OPER */
		RECURSE: switch(code[xt++]) { /* `NATIVE OPERATIONS' */
			undivert(PRIMITIVES)
		default:
			fprintf(usrout, "(%ld: %ld ", I - 1, code[--xt]);
			sorry("(Trolley Error)");
		}
	}
}
