/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private static final long julianDayOffset = 2440588L;
    private static final int millisPerDay = 86400000;
    private static final int[] NUM_DAYS;
    private static final int[] LEAP_NUM_DAYS;
    private static final int[] MONTH_LENGTH;
    private static final int[] LEAP_MONTH_LENGTH;
    private long gregorianCutover = -12219292800000L;
    private static long JULIAN_ONSET;
    private static final long ONE_SECOND = 1000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    static final long serialVersionUID = -8125100834729963327L;
    private static final int[] MinValues;
    private static final int[] GreatestMinValues;
    private static final int[] LeastMaxValues;
    private static final int[] MaxValues;

    private static final long millisToJulianDay(long l) {
        if (l >= 0L) {
            return 2440588L + l / 86400000L;
        }
        return 2440588L + (l - 86400000L + 1L) / 86400000L;
    }

    private static final long julianDayToMillis(long l) {
        return (l - 2440588L) * 86400000L;
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone timeZone) {
        this(timeZone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone timeZone, Locale locale) {
        super(timeZone, locale);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public GregorianCalendar(int n, int n2, int n3) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public GregorianCalendar(int n, int n2, int n3, int n4, int n5, int n6) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        return this.getTimeInMillis() == calendar.getTimeInMillis() && this.isLenient() == calendar.isLenient() && this.getFirstDayOfWeek() == calendar.getFirstDayOfWeek() && this.getMinimalDaysInFirstWeek() == calendar.getMinimalDaysInFirstWeek() && this.getTimeZone().equals(calendar.getTimeZone());
    }

    public boolean before(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
    }

    public boolean after(Object object) {
        return object instanceof Calendar && this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    private static final int julianDayToDayOfWeek(long l) {
        int n;
        return n + ((n = (int)((l + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private final void timeToFields(long l) {
        int n;
        int n2;
        long l2;
        long l3;
        int n3 = 1;
        long l4 = l3 = l >= 0L ? 2440588L + l / 86400000L : 2440588L + (l - 86400000L + 1L) / 86400000L;
        if (l >= this.gregorianCutover) {
            long l5 = (long)(((double)(l3 - 1867216L) - 0.25) / 36524.25);
            l2 = l3 + 1L + l5 - (long)(0.25 * (double)l5);
        } else {
            l2 = l3;
        }
        long l6 = l2 + 1524L;
        long l7 = (long)Math.floor(6680.0 + ((double)(l6 - 2439870L) - 122.1) / 365.25);
        long l8 = (long)Math.floor((double)(365L * l7) + 0.25 * (double)l7);
        long l9 = (long)((double)(l6 - l8) / 30.6001);
        int n4 = (int)(l6 - l8 - (long)(30.6001 * (double)l9));
        int n5 = (int)l9 - 1;
        if (n5 > 12) {
            n5 -= 12;
        }
        int n6 = (int)(l7 - 4715L);
        if (n5 > 2) {
            --n6;
        }
        if (n6 <= 0) {
            n3 = 0;
            n6 = 1 - n6;
        }
        this.fields[0] = n3;
        this.fields[1] = n6;
        this.fields[2] = n2 = n5 - 1;
        this.fields[5] = n4;
        this.fields[7] = n = GregorianCalendar.julianDayToDayOfWeek(l3);
        int n7 = this.isLeapYear(n6) ? LEAP_NUM_DAYS[n5 - 1] + n4 : NUM_DAYS[n5 - 1] + n4;
        this.fields[6] = n7;
        this.fields[3] = n2 = this.weekNumber(n7, n);
        this.fields[4] = n2 = this.weekNumber(n4, n);
        this.fields[8] = n2 = (n4 - 1) / 7 + 1;
    }

    private int weekNumber(int n, int n2) {
        int n3 = (n2 - this.getFirstDayOfWeek() - n + 1) % 7;
        if (n3 < 0) {
            n3 += 7;
        }
        int n4 = (n + n3 - 1) / 7;
        if (7 - n3 >= this.getMinimalDaysInFirstWeek()) {
            ++n4;
        }
        return n4;
    }

    public boolean isLeapYear(int n) {
        long l = (long)((double)(n - 1970) * 365.2422 * 8.64E7);
        if (l < JULIAN_ONSET) {
            return false;
        }
        if (l > this.gregorianCutover) {
            return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        }
        return n % 4 == 0;
    }

    protected void computeFields() {
        int n;
        int n2;
        int n3 = this.getTimeZone().getRawOffset();
        long l = this.time + (long)n3;
        this.timeToFields(l);
        int n4 = this.fields[0];
        int n5 = this.fields[1];
        int n6 = this.fields[2];
        int n7 = this.fields[5];
        int n8 = this.fields[7];
        long l2 = l / 86400000L;
        int n9 = (int)(l - l2 * 86400000L);
        if (n9 < 0) {
            n9 += 86400000;
        }
        if ((n9 += (n2 = this.getTimeZone().getOffset(n4, n5, n6, n7, n8, n9) - n3)) >= 86400000) {
            n9 -= 86400000;
            this.timeToFields(l += (long)n2);
        }
        this.fields[14] = n = n9 % 1000;
        this.fields[13] = n = (n9 /= 1000) % 60;
        this.fields[12] = n = (n9 /= 60) % 60;
        this.fields[11] = n9 /= 60;
        this.fields[9] = n = n9 / 12;
        this.fields[10] = n = n9 % 12;
        this.fields[15] = n3;
        this.fields[16] = n2;
        n = 0;
        while (n < 17) {
            this.stamp[n] = 1;
            ++n;
        }
        int n10 = 0;
        while (n10 < 17) {
            this.isSet[n10] = true;
            ++n10;
        }
    }

    boolean inDaylightTime() {
        if (!this.getTimeZone().useDaylightTime()) {
            return false;
        }
        this.complete();
        return this.fields[16] != 0;
    }

    private final int monthLength(int n, int n2) {
        if (this.isLeapYear(n2)) {
            return LEAP_MONTH_LENGTH[n];
        }
        return MONTH_LENGTH[n];
    }

    private boolean validateFields() {
        int n;
        block7: {
            block9: {
                block8: {
                    int n2 = 0;
                    while (n2 < 17) {
                        if (n2 != 5 && n2 != 6 && this.stamp[n2] != 0 && ((n = this.fields[n2]) < this.getMinimum(n2) || n > this.getMaximum(n2) && !false)) {
                            return false;
                        }
                        ++n2;
                    }
                    if (this.stamp[5] == 0) break block7;
                    n = this.fields[5];
                    if (n < this.getMinimum(5)) break block8;
                    int n3 = this.fields[2];
                    int n4 = this.fields[1];
                    if (n <= (this.isLeapYear(n4) ? LEAP_MONTH_LENGTH[n3] : MONTH_LENGTH[n3])) break block9;
                }
                return false;
            }
            return true;
        }
        if (this.stamp[6] != 0) {
            n = this.fields[6];
            if (this.isLeapYear(this.fields[1]) ? n < 1 || n > 366 : n < 1 || n > 365) {
                return false;
            }
        }
        return this.stamp[8] == 0 || this.fields[8] != 0;
    }

    private boolean boundsCheck(int n, int n2) {
        return n >= this.getMinimum(n2) && n <= this.getMaximum(n2);
    }

    private final int aggregateStamp(int n, int n2) {
        if (n != 0 && n2 != 0) {
            if (n >= n2) {
                return n;
            }
            return n2;
        }
        return 0;
    }

    protected void computeTime() {
        int n;
        int n2;
        long l;
        int n3;
        if (!this.isLenient() && !this.validateFields()) {
            throw new IllegalArgumentException();
        }
        long l2 = 0L;
        int n4 = this.stamp[0] != 0 ? this.fields[0] : 1;
        if (n4 < 0 || n4 > 1) {
            throw new IllegalArgumentException();
        }
        int n5 = this.stamp[1] != 0 ? this.fields[1] : 1970;
        int n6 = 0;
        int n7 = 0;
        if (n4 == 0) {
            n5 = 1 - n5;
        }
        long l3 = 0L;
        int n8 = this.stamp[2];
        int n9 = this.stamp[5];
        int n10 = this.stamp[4];
        int n11 = this.stamp[8];
        int n12 = this.stamp[6];
        int n13 = this.stamp[3];
        int n14 = n3 = n8 > n9 ? n8 : n9;
        if (n10 > n3) {
            n3 = n10;
        }
        if (n11 > n3) {
            n3 = n11;
        }
        if (n12 > n3) {
            n3 = n12;
        }
        if (n13 > n3) {
            n3 = n13;
        }
        if (n3 != 0 && (n3 == n8 || n3 == n9 || n3 == n10 || n3 == n11)) {
            n6 = (n8 != 0 ? this.fields[2] : 0) + 1;
            if (n6 < 1) {
                n5 += n6 / 12 - 1;
                n6 = 12 + n6 % 12;
            } else if (n6 > 12) {
                n5 += n6 / 12;
                n6 %= 12;
            }
            if (n6 > 2) {
                ++n6;
            } else {
                --n5;
                n6 += 13;
            }
            l3 = (long)(Math.floor(365.25 * (double)n5) + Math.floor(30.6001 * (double)n6) + 1720995.0);
            if (n3 == n9 || n3 == n8) {
                n7 = n9 != 0 ? this.fields[5] : 1;
            } else {
                l = l3;
                if ((l3 - 2440588L) * 86400000L >= this.gregorianCutover) {
                    long l4 = (long)(0.01 * (double)n5);
                    l += 2L - l4 + (long)(0.25 * (double)l4);
                }
                if ((n2 = GregorianCalendar.julianDayToDayOfWeek(l + 1L) - this.getFirstDayOfWeek()) < 0) {
                    n2 += 7;
                }
                n7 = 1 - n2 + (this.stamp[7] != 0 ? this.fields[7] - this.getFirstDayOfWeek() : 0);
                if (n3 == n10) {
                    if (7 - n2 < this.getMinimalDaysInFirstWeek()) {
                        n7 += 7;
                    }
                    n7 += 7 * (this.fields[4] - 1);
                } else {
                    int n15;
                    if (n7 < 1) {
                        n7 += 7;
                    }
                    if ((n15 = this.fields[8]) >= 0) {
                        n7 += 7 * (n15 - 1);
                    } else {
                        n = this.fields[2];
                        n7 += (((this.isLeapYear(n5) ? LEAP_MONTH_LENGTH[n] : MONTH_LENGTH[n]) - n7) / 7 + n15 + 1) * 7;
                    }
                }
            }
            l3 += (long)n7;
        } else {
            l3 = (long)(Math.floor(365.25 * (double)(--n5)) + 428.0 + 1720995.0);
            if (n3 == 0) {
                ++l3;
            } else if (n3 == n12) {
                l3 += (long)this.fields[6];
            } else if (n3 == n13) {
                l = l3;
                if ((l3 - 2440588L) * 86400000L >= this.gregorianCutover) {
                    long l5 = (long)(0.01 * (double)n5);
                    l += 2L - l5 + (long)(0.25 * (double)l5);
                }
                if ((n2 = GregorianCalendar.julianDayToDayOfWeek(l + 1L) - this.getFirstDayOfWeek()) < 0) {
                    n2 += 7;
                }
                n7 = 1 - n2 + (this.stamp[7] != 0 ? this.fields[7] - this.getFirstDayOfWeek() : 0);
                if (7 - n2 < this.getMinimalDaysInFirstWeek()) {
                    n7 += 7;
                }
                l3 += (long)(n7 += 7 * (this.fields[3] - 1));
            }
        }
        l2 = (l3 - 2440588L) * 86400000L;
        if (l2 >= this.gregorianCutover) {
            l = (long)(0.01 * (double)n5);
            l2 = ((l3 += 2L - l + (long)(0.25 * (double)l)) - 2440588L) * 86400000L;
        }
        int n16 = 0;
        n2 = this.stamp[10];
        int n17 = this.stamp[11];
        int n18 = n3 = n2 > n17 ? n2 : n17;
        if (n3 != 0) {
            if (n3 == n17) {
                n16 += this.fields[11];
            } else {
                n16 += this.fields[10];
                n16 += 12 * this.fields[9];
            }
        }
        n16 *= 60;
        n16 += this.fields[12];
        n16 *= 60;
        n16 += this.fields[13];
        n16 *= 1000;
        TimeZone timeZone = this.getTimeZone();
        n = this.stamp[15] >= 2 ? this.fields[15] : timeZone.getRawOffset();
        l2 += (long)(n16 += this.fields[14]);
        int n19 = 0;
        if (this.stamp[15] >= 2) {
            n19 = this.fields[16];
        } else {
            if (this.stamp[2] == 0 || this.stamp[5] == 0) {
                this.timeToFields(l2);
            }
            n19 = timeZone.getOffset(n4, this.fields[1], this.fields[2], this.fields[5], GregorianCalendar.julianDayToDayOfWeek(l3), n16) - n;
        }
        this.time = l2 - (long)n - (long)n19;
    }

    public synchronized int hashCode() {
        return this.getFirstDayOfWeek() ^ this.getMinimalDaysInFirstWeek();
    }

    public void add(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.complete();
        if (n == 1) {
            int n3 = this.fields[1];
            if (this.fields[0] == 1) {
                if ((n3 += n2) > 0) {
                    this.set(1, n3);
                    return;
                }
                this.set(1, 1 - n3);
                this.set(0, 0);
                return;
            }
            if ((n3 -= n2) > 0) {
                this.set(1, n3);
                return;
            }
            this.set(1, 1 - n3);
            this.set(0, 1);
            return;
        }
        if (n == 2) {
            int n4 = this.fields[2] + n2;
            if (n4 >= 0) {
                this.add(1, n4 / 12);
                this.set(2, n4 % 12);
            } else {
                this.add(1, (n4 + 1) / 12 - 1);
                if ((n4 %= 12) < 0) {
                    n4 += 12;
                }
                this.set(2, n4);
            }
            int n5 = this.fields[2];
            int n6 = this.fields[1];
            n5 = this.isLeapYear(n6) ? LEAP_MONTH_LENGTH[n5] : MONTH_LENGTH[n5];
            n6 = this.fields[5];
            if (n6 > n5) {
                this.set(5, n5);
                return;
            }
        } else {
            if (n == 0) {
                int n7 = this.fields[0] + n2;
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n7 > 1) {
                    n7 = 1;
                }
                this.set(0, n7);
                return;
            }
            long l = this.fields[16];
            long l2 = n2;
            switch (n) {
                case 3: 
                case 4: 
                case 8: {
                    l2 *= 604800000L;
                    break;
                }
                case 9: {
                    l2 *= 43200000L;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    l2 *= 86400000L;
                    break;
                }
                case 10: 
                case 11: {
                    l2 *= 3600000L;
                    break;
                }
                case 12: {
                    l2 *= 60000L;
                    break;
                }
                case 13: {
                    l2 *= 1000L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
                case 14: 
            }
            this.setTimeInMillis(this.time + l2);
            l -= (long)this.fields[16];
            if (l2 != 0L) {
                this.setTimeInMillis(this.time + l);
            }
        }
    }

    public void roll(int n, boolean bl) {
        this.roll(n, bl ? 1 : -1);
    }

    void roll(int n, int n2) {
        int n3;
        if (n2 == 0) {
            return;
        }
        this.complete();
        int n4 = this.getMinimum(n);
        int n5 = this.getMaximum(n);
        switch (n) {
            case 2: {
                int n6 = (this.fields[2] + n2) % 12;
                if (n6 < 0) {
                    n6 += 12;
                }
                this.set(2, n6);
                int n7 = this.fields[1];
                n7 = this.isLeapYear(n7) ? LEAP_MONTH_LENGTH[n6] : MONTH_LENGTH[n6];
                int n8 = this.fields[5];
                if (n8 > n7) {
                    this.set(5, n7);
                }
                return;
            }
            case 3: {
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = this.fields[7] - this.getFirstDayOfWeek();
                if (n16 < 0) {
                    n16 += 7;
                }
                if ((n15 = (n16 - this.fields[6] + 1) % 7) < 0) {
                    n15 += 7;
                }
                if ((n14 = (this.fields[6] + n2 * 7 - (n13 = 7 - n15 < this.getMinimalDaysInFirstWeek() ? 8 - n15 : 1 - n15)) % (n12 = (n11 = (n10 = this.isLeapYear(this.fields[1]) ? 366 : 365) + 7 - (n9 = (n10 - this.fields[6] + n16) % 7)) - n13)) < 0) {
                    n14 += n12;
                }
                if ((n14 += n13) < 1) {
                    n14 = 1;
                }
                if (n14 > n10) {
                    n14 = n10;
                }
                this.set(6, n14);
                this.clear(2);
                return;
            }
            case 4: {
                int n17;
                int n18 = this.fields[7] - this.getFirstDayOfWeek();
                if (n18 < 0) {
                    n18 += 7;
                }
                if ((n17 = (n18 - this.fields[5] + 1) % 7) < 0) {
                    n17 += 7;
                }
                int n19 = 7 - n17 < this.getMinimalDaysInFirstWeek() ? 8 - n17 : 1 - n17;
                int n20 = this.fields[2];
                int n21 = this.fields[1];
                n20 = this.isLeapYear(n21) ? LEAP_MONTH_LENGTH[n20] : MONTH_LENGTH[n20];
                int n22 = n20 + 7 - (n21 = (n20 - this.fields[5] + n18) % 7);
                int n23 = n22 - n19;
                int n24 = (this.fields[5] + n2 * 7 - n19) % n23;
                if (n24 < 0) {
                    n24 += n23;
                }
                if ((n24 += n19) < 1) {
                    n24 = 1;
                }
                if (n24 > n20) {
                    n24 = n20;
                }
                this.set(5, n24);
                return;
            }
            case 5: {
                n3 = this.fields[2];
                int n25 = this.fields[1];
                n5 = this.isLeapYear(n25) ? LEAP_MONTH_LENGTH[n3] : MONTH_LENGTH[n3];
                break;
            }
            case 6: {
                long l = (long)n2 * 86400000L;
                long l2 = this.time - (long)(this.fields[6] - 1) * 86400000L;
                int n26 = this.isLeapYear(this.fields[1]) ? 366 : 365;
                this.time = (this.time + l - l2) % ((long)n26 * 86400000L);
                if (this.time < 0L) {
                    this.time += (long)n26 * 86400000L;
                }
                this.setTimeInMillis(this.time + l2);
                return;
            }
            case 7: {
                long l = (long)n2 * 86400000L;
                int n27 = this.fields[7] - this.getFirstDayOfWeek();
                if (n27 < 0) {
                    n27 += 7;
                }
                long l3 = this.time - (long)n27 * 86400000L;
                this.time = (this.time + l - l3) % 604800000L;
                if (this.time < 0L) {
                    this.time += 604800000L;
                }
                this.setTimeInMillis(this.time + l3);
                return;
            }
            case 8: {
                long l = (long)n2 * 604800000L;
                int n28 = (this.fields[5] - 1) / 7;
                int n29 = this.fields[2];
                int n30 = this.fields[1];
                n29 = ((this.isLeapYear(n30) ? LEAP_MONTH_LENGTH[n29] : MONTH_LENGTH[n29]) - this.fields[5]) / 7;
                long l4 = this.time - (long)n28 * 604800000L;
                long l5 = 604800000L * (long)(n28 + n29 + 1);
                this.time = (this.time + l - l4) % l5;
                if (this.time < 0L) {
                    this.time += l5;
                }
                this.setTimeInMillis(this.time + l4);
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
            case 0: 
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
        }
        int n31 = n5 - n4 + 1;
        n3 = this.fields[n] + n2;
        n3 = (n3 - n4) % n31;
        if (n3 < 0) {
            n3 += n31;
        }
        this.set(n, n3 += n4);
    }

    public int getMinimum(int n) {
        return MinValues[n];
    }

    public int getMaximum(int n) {
        return MaxValues[n];
    }

    public int getGreatestMinimum(int n) {
        return GreatestMinValues[n];
    }

    public int getLeastMaximum(int n) {
        return LeastMaxValues[n];
    }

    static {
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        NUM_DAYS = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        LEAP_NUM_DAYS = nArray2;
        MONTH_LENGTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        LEAP_MONTH_LENGTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        JULIAN_ONSET = -62893584000000L;
        int[] nArray3 = new int[17];
        nArray3[1] = 1;
        nArray3[5] = 1;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = -1;
        nArray3[15] = -43200000;
        MinValues = nArray3;
        int[] nArray4 = new int[17];
        nArray4[1] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[8] = -1;
        nArray4[15] = -43200000;
        GreatestMinValues = nArray4;
        LeastMaxValues = new int[]{1, 5000000, 11, 53, 4, 28, 365, 7, 4, 1, 11, 23, 59, 59, 999, 43200000, 3600000};
        MaxValues = new int[]{1, 5000000, 11, 54, 6, 31, 366, 7, 6, 1, 12, 23, 59, 59, 999, 43200000, 3600000};
    }
}

