(* -------------------------------------------
               Unification 
   -------------------------------------------*)

(* Martelli, Montanari: An Efficient Unification Algorithm;
   ACM Transactions on Programming Languages and Systema,
   vol. 4, no. 2 (April 1982), pp. 258-282
   (Transcripted by Miki Hermann)
*)

let del_triv = make_set o (filter_neg (prefix =))
;;

let sub_snd  s (x,y) = (x, substitute [s] y)
and sub_both s (x,y) = (ss x, ss y) where ss = substitute [s]
;;

let unify (x,y) = unify_mm_rec [] (del_triv [(x,y)])
where rec unify_mm_rec sbst =
fun ((Var n1, term2) :: l) ->
         if occurs n1 term2 then fail       (* Occur check *)
       else unify_mm_rec ((n1,term2) :: (map (sub_snd (n1, term2)) sbst))
            (del_triv(map (sub_both (n1, term2)) l)) (* Variable elimination *)
  | ((term1, Var n2) :: l) -> unify_mm_rec sbst ((Var n2, term1) :: l)
  | ((Term(op1,sons1), Term(op2,sons2)) :: l) ->
         if op1 = op2 then   (* Term decomposition *)
            unify_mm_rec sbst (del_triv(combine(sons1,sons2) @ l))
       else fail  (* Clash *)
  | [] -> sbst
  ? failwith "unify"
;;
