#!/bin/sh
#************************************************************************
#
#			Projet     Formel
#
#			    ML in ML
#
#*************************************************************************
#
#            			Inria
#			Domaine de Voluceau
#			78150  Rocquencourt
#				France
#
#*************************************************************************
#
# camlyacc.sh	Extracts yacc tables and actions from yacc output.
#
ed - y.tab.c <<FINI
E y.tab.c
/define yyclearin/,/^# *line/d
/^(\* Caml part \*)\$/;\$d
g/# *define */d
1i

directive open_env "$1";;

(* BEGINNING OF LEXICALS *)

let syntax_name = "$1";;
.
/let current_syntax/d
1,\$p
E y.tab.c
1,/yytabelem yyexca/-d
/typedef struct/,\$d
g/yytabelem/s//let /
g/\[\].*/s// = [|/
g/,/s//;/g
g/};/s//|];;/
g/# *define/s/# *define *\([A-Z]*\)/let \1 =/\\
s/\$/;;/
g/let  yyr2 =/s/let  yyr2 =/let  yyr2 = let f n = (n - ( n mod 2))\\/2 in/
/let  yyr2 =/,/;;/s/;   /; f /g
/let  yyr2 =/,/let  yychk =/s/^   /f /
?let YYNPROD = ?-2s/;\$//
1i

(* BEGINNING OF TABLES *)

.
\$a

(* END OF TABLES *)
.
1,\$p
E y.tab.c
1,/switch( yytmp )/d
1d
/goto/-,\$d
g/^case /s/case /vect_assign($1_yyact_vect, /\\
s/:/, (fun () -> /
g/^# line/s/^# line/(* action line/\\
s/\$/ *)/
g/^{/s//Repr (/
g/} break;/s//)));;/
g/yypvt\[-\([0-9]*\)\]/s//(peek_val \1)/g
1i

let $1_yytabs = Parse_table(yyexca,yyact,yypact,yypgo,yyr1,yyr2,yychk,yydef);;

(* BEGINNING OF ACTIONS *)

let $1_yyact_vect = vector (YYNPROD+1) of (fun () -> !yy_val);;
.
\$a

let $1_yyactions n = vect_item($1_yyact_vect, n) ();;

(* END OF ACTIONS *)

let $1_lsyntax =
 Scan_syntax($1_strings,$1_double,
	     ($1_NUM,$1_INT,$1_FLOAT,$1_IDENT,$1_BOOL,$1_STRING,$1_INFIX),
	     ($1_strdelim,$1_cmndelim),
	     $1_sub_syntaxes)
;;

let $1_psyntax = Parse_syntax($1_yyactions,$1_yytabs,YYLAST);;

let $1_syntax = Syntax("$1",$1_syntax_flag,$1_lsyntax,$1_psyntax);;
	
(* syntax_flag = (yy_)lex; syntax_type = syntax/value *)

add_syntax (make_parser $1_syntax_type  $1_syntax);();;

.
1,\$p
E y.tab.c
1,/^(\* Caml part \*)\$/-d
/yytabelem yyexca/,\$d
1,\$p
Q
FINI
