
#  Le Makefile de fabrication des diffe'rents syste`mes 
#  Le-Lisp version 15.2 > 1-Aout-1987 
#  -- Maintenance: Ce Makefile est ge'ne're' automatiquement --

# la permiere entree pour tout demarrer
all: default

# A editer selon le mode BSD ou S5
# le systeme type: par defaut:
#if      SYSTYPE == bsd4.3 
TYPESYS=bsd4.3
CCSYSTYPE=-A systype,$(TYPESYS) -A runtype,$(TYPESYS) -DBSD4x -DBSD42 -DINRIA
#else   
#TYPESYS=sys5.3
#CCSYSTYPE=-A systype,$(TYPESYS) -A runtype,$(TYPESYS) -DS5
#endif

# A editer pour optimisation (mineure) selon la machine
# [cf man cc; cf man cpuhelp]
APOLLOFLAG= -A cpu,3000 

SYSTEM= apollo

HOST=$(SYSTEM)
MAKE=make

SHELL=/bin/sh

CC=/bin/cc

################################
# Les noms des binaires standard
################################

BIN=lelisp31

lelispbin: $(BIN)bin
	@rm -f lelispbin
	ln $(BIN)bin lelispbin

leX11bin: $(BIN)X11bin
	@rm -f leX11bin
	ln $(BIN)X11bin leX11bin

leM11bin: $(BIN)M11bin
	@rm -f leM11bin
	ln $(BIN)M11bin leM11bin

##########################################################################
# Les options de'pendant du syste`me
##########################################################################
#
# pour les includes C propres a Le-Lisp:

LLINCLUDE=-I../common

# Pour avoir des messages en breton 

FOREIGN=-DFOREIGN

# Pour l'edition de liens dynamique

CLOAD= -DNOCLOAD

# Pour preciser la taille des pages en me'moire

LLPAGESIZE=

# Le fichier initial au lancement d'un lelispbin sans argument

FILEINI=-DFILEINI=\"../llib/startup.ll\"

# le nom du syste`me : Le-Lisp ou CAML ou ...

LLSYSNAME=-DLLSYSNAME=\"CAML\"

# le timbre d'unicite

STAMP=-DSTAMP=\"$$$$\"

# Pour faire du debug

DEBUG=

#
# LOCALVARS = -x par defaut, pas de symboles locaux.
#           = -X pour aider au debug  (toutes les variables 
#             locales sont conserve'es dans la table des symboles).

LOCALVARS=-x

# Les flags pour le link

LDFLAGS= -z $(LOCALVARS)

# Les librairies du linker

LDLIBS= 

# Les flags de compilation C pour Le-Lisp

LL_CFLAGS= 	$(LLPAGESIZE) $(CLOAD) $(FOREIGN) \
		$(FILEINI) $(LLINCLUDE) $(LLSYSNAME)

##############################################
# Les flags de compilation C pour C sur apollo

C_CFLAGS=-O -DNBSYST=4 $(CCSYSTYPE) $(APOLLOFLAG) -DAPOLLO 

# Les flags de compilation C
CFLAGS= $(C_CFLAGS) $(DEBUG) $(LL_CFLAGS)

########################################
# les flags de compilation C pour X11

WINDOW= -DX11

# Pour ld qui doit trouver les lib*.a
# de la forme: $(XLIB)/libX*.a

XLIB= 

# Pour les includes qui doivent trouver les *.h:
# de la forme: $(XINCLUDE)/X/?*.h

XINCLUDE=/usr/include

# les flags de compilations C pour X11

X11_CFLAGS=$(WINDOW) -I$(XINCLUDE)

X11_LDFLAGS= $(XLIB)

X11_LDLIBS= 

########################################
# les flags de compilation C pour Motif

# Pour ld qui doit trouver les lib*.a

MOTIFLIB=-L/usr/lib

MXtLIB=$(XLIB)

# Pour les includes qui doivent trouver les *.h:
# de la forme: $(MOTIFINCLUDE)/X11/?*.h

MOTIFINCLUDE=/usr/include

MXtINCLUDE=$(XINCLUDE)

# les options de compilations C pour Motif

MOTIFVERSION=MOTIF1_1

MOTIFOPTIONS= -DSTRINGS_ALIGNED -DXT_BV -DMOTIF_BV -D_NO_PROTO -D$(MOTIFVERSION)

# les flags de compilations C pour motif

MOTIF_LDFLAGS= $(MOTIFLIB) $(MXtLIB)

MOTIF_LDLIBS= -lXm -lXt

MOTIF_CFLAGS= $(MOTIFOPTIONS) -I$(MXtINCLUDE) -I$(MOTIFINCLUDE)

#########################################################################
##
## les fichiers C utilise's pour fabriquer les binaires 
##
#########################################################################
# les fichiers C communs a tous

common_cobj=o/llmain.o o/camlstdio.o o/llfloat.o o/icacheflush.o o/time.o

cobj=	$(common_cobj) o/caml.o \
	o/Xlib_runtime.o o/Xlib_stubs.o o/c-fail.o o/ddr_ext.o

# les fichiers C pour le bitmap X11 
 
x11cobj= o/x11.o o/evloop.o

# les fichiers C pour le bitmap avec MOTIF
 
motifcobj= o/mintrinsic.o o/motifobj.o o/evloop.o

#########################################################################
##
## fabrication de tous les binaires possibles
## selon les options disponibles sur cette machine
##
#########################################################################

lefpu31bin: $(cobj) lefpu31bin.o
	$(CC) $(CFLAGS) $(LDFLAGS) -o lefpu31bin \
	$(cobj) lefpu31bin.o \
	$(LDLIBS) 

lefpu64bin: $(cobj) lefpu64bin.o
	$(CC) $(CFLAGS) $(LDFLAGS) -o lefpu64bin \
	$(cobj) lefpu64bin.o \
	$(LDLIBS) 

# camlispbin

camlispbin: camlisp31$(EXE)bin
	@/bin/rm -f camlispbin
	ln camlisp31$(EXE)bin camlispbin

camlisp31bin: $(cobj) $(BIN)bin.o
	$(CC) $(CFLAGS) $(X11_LDFLAGS) $(LDFLAGS) -o camlisp31bin \
	$(cobj) $(BIN)bin.o \
	$(X11_LDLIBS) $(LDLIBS)

lefpu31X11bin: $(cobj) $(x11cobj) lefpu31bin.o
	$(CC) $(CFLAGS) $(X11_CFLAGS) -o lefpu31X11bin \
		$(cobj) $(x11cobj) lefpu31bin.o  \
		$(X11_LDFLAGS) $(X11_LDLIBS) $(LDFLAGS) $(LDLIBS) 

lefpu64X11bin: $(cobj) $(x11cobj) lefpu64bin.o
	$(CC) $(CFLAGS) $(X11_CFLAGS) -o lefpu64X11bin \
		$(cobj) $(x11cobj) lefpu64bin.o  \
		$(X11_LDFLAGS) $(X11_LDLIBS) $(LDFLAGS) $(LDLIBS) 

lefpu31M11bin: $(cobj) $(motifcobj) lefpu31bin.o
	$(CC) $(CFLAGS) $(MOTIF_CFLAGS) $(X11_CFLAGS) -o lefpu31M11bin \
		$(cobj) $(motifcobj) lefpu31bin.o  \
		$(MOTIF_LDFLAGS) $(MOTIF_LDLIBS) \
		$(X11_LDFLAGS) $(X11_LDLIBS) \
		$(LDFLAGS) $(LDLIBS) 

lefpu64M11bin: $(cobj) $(motifcobj) lefpu64bin.o
	$(CC) $(CFLAGS) $(MOTIF_CFLAGS) $(X11_CFLAGS) -o lefpu64M11bin \
		$(cobj) $(motifcobj) lefpu64bin.o  \
		$(MOTIF_LDFLAGS) $(MOTIF_LDLIBS) \
		$(X11_LDFLAGS) $(X11_LDLIBS) \
		$(LDFLAGS) $(LDLIBS) 

##########################################################
# Les entre'es classiques
##########################################################

DEFAULTS= cmplc++ lelisp leX11bin

ALLCORES= lelisp cmplc lelispX11 cmplc++ lelisps ceyx lelisp64 camlisp camlispbig

ALLBINS= lefpu31bin  lefpu64bin    lefpu31X11bin  lefpu64X11bin    lefpu31M11bin   lefpu64M11bin camlisp31bin camlispbin

# Pour faire les systemes clients : $(DEFAULTS)
# % make
default: $(DEFAULTS)
allcore: $(ALLCORES)
allbin:	$(ALLBINS)

# Pour nettoyer tout ce qui est fabrique' par ce makefile: Les binaires, 
# les commandes standard.
# % make clean
clean: cleanbin cleancore cleano
cleanbin:
	rm -f $(ALLBINS)
cleancore:
	rm -f $(ALLCORES)
	rm -f llcore/?*.core
cleano:
	rm -f o/?*.o

# Pour effacer tout ce qui n'est pas indispensable a` une utilisation minimale
#  de Le-Lisp.  Attention, plus aucun binaire, plus aucune image me'moire de 
#  Le-Lisp ne sera faisable de`s que cette commande aura e'te' lance'e!
#
# Il est e'vident qu'aucune  maintenance ne pourra etre effectue'e
#  sans une distribution COMPLETE de Le-Lisp.
#
# % make minimal
minimal:
	@( echo "Voulez-vous vraiment ne garder qu'un Le-Lisp minimun?(o/n) ";\
	read rep ;\

	if [ $$rep = "o" ] ;\
	then \
		echo "OK, on y va..." ;\
		(cd .. ;\
		/bin/rm -f TAR* LL*FILES ;\
		/bin/rm -rf benchmarks ;\
		/bin/rm -rf ceyx ;\
		/bin/rm -rf common ;\
		/bin/rm -rf info ;\
		/bin/rm -rf lltest ;\
		) ;\
		/bin/rm -f *.o
		/bin/rm -rf conf ;\
		/bin/rm -rf recette ;\
		/bin/rm -rf o ;\
		/bin/rm -ri llcore ;\
		/bin/rm -f *FILES* ;\
		/bin/rm -f Make* ;\
		echo "C'est fait." ;\
	fi )

#########################################################################
#                 Les fichiers .c
#########################################################################
LINTFLAGS=-nchxa
lint:
	mv $(cobj) .
	$(MAKE) CC=/bin/lint \
		CFLAGS="$(LINTFLAGS) $(LL_CFLAGS)" \
		$(cobj) 

o/llmain.o: ../common/llmain.c
	$(CC) $(CFLAGS) -c ../common/llmain.c
	mv llmain.o o

o/lelisp.o: ../common/lelisp.c
	@if [ "$$SYSTYPE" != "$(TYPESYS)" ] ; \
	then \
		echo "** incompatibility between your SYSTYPE environment variable and your Makefile" ; \
		echo "** Please, reconfigure your Makefile" ;\
		exit 1 ; \
	else \
	$(CC) $(CFLAGS) -DSTAMP=\"$$$$\" -c ../common/lelisp.c ;\
	mv lelisp.o o/lelisp.o ;\
	fi

# CAML
o/caml.o: ../common/caml.c
	@if [ "$$SYSTYPE" != "$(TYPESYS)" ] ; \
	then \
		echo "** incompatibility between your SYSTYPE environment variable and your Makefile" ; \
		echo "** Please, reconfigure your Makefile" ;\
		exit 1 ; \
	else \
	$(CC) $(CFLAGS) -DSTAMP=\"$$$$\" -c ../common/caml.c ;\
	mv caml.o o/caml.o ;\
	fi

o/llstdio.o: ../common/llstdio.c
	$(CC) $(CFLAGS) -c ../common/llstdio.c
	mv llstdio.o o

# CAML
o/camlstdio.o: ../common/camlstdio.c
	$(CC) -DMAXCHAR=1024 $(CFLAGS) -c ../common/camlstdio.c
	mv camlstdio.o o

o/evloop.o: ../common/evloop.c
	$(CC) $(CFLAGS) -c ../common/evloop.c
	mv evloop.o o

o/llfloat.o: ../common/llfloat.c
	$(CC) $(CFLAGS) -c ../common/llfloat.c
	mv llfloat.o o

o/llnumb.o:  ../common/llnumb.c
	$(CC) $(CFLAGS) -c ../common/llnumb.c
	mv llnumb.o o

o/cstruct.o: ../common/cstruct.c
	$(CC) $(CFLAGS) -c ../common/cstruct.c
	mv cstruct.o o

# (* CAML

o/icacheflush.o: icacheflush.c
	$(CC) $(CFLAGS) -c icacheflush.c
	mv icacheflush.o o

o/time.o: ../Xlib/time.c
	gcc $(CFLAGS) $(X11_CFLAGS) -c ../Xlib/time.c
	mv time.o o

o/Xlib_runtime.o: ../Xlib/Xlib_runtime.c
	gcc $(CFLAGS) $(X11_CFLAGS) -c ../Xlib/Xlib_runtime.c
	mv Xlib_runtime.o o

o/Xlib_stubs.o: ../Xlib/Xlib_stubs.c
	gcc $(CFLAGS) $(X11_CFLAGS) -c ../Xlib/Xlib_stubs.c
	mv Xlib_stubs.o o

o/c-fail.o: ../Xlib/c-fail.c
	gcc $(CFLAGS) $(X11_CFLAGS) -c ../Xlib/c-fail.c
	mv c-fail.o o

o/ddr_ext.o: ../Xlib/ddr_ext.c
	gcc $(CFLAGS) $(X11_CFLAGS) -c ../Xlib/ddr_ext.c
	mv ddr_ext.o o/.
# CAML *)

# Pour le bitmap X11
o/x11.o: ../virbitmap/X11/x11lib.c ../virbitmap/X11/x11share.c
	@if [ -f $(XINCLUDE)/X11/Xlib.h ] ;\
	then \
		( cd ../virbitmap/X11 ; \
		$(MAKE) ../../$(SYSTEM)/o/x11.o \
			SYSTEM=$(SYSTEM) \
			CC=$(CC) \
			CFLAGS='$(CFLAGS) $(X11_CFLAGS)' ) ;\
	else \
		echo "make: ** Les bibliotheques de X11 ne sont pas en $(XINCLUDE)/X11" ;\
		echo "      ** Editer la variable XINCLUDE dans le makefile." ;\
		exit 1 ;\
	fi 

# pour le bitmap Motif
o/mintrinsic.o:
	@if [ -f $(MXtINCLUDE)/X11/Shell.h ] ;\
	then \
		( cd ../virbitmap/X11/intrinsic; \
		$(MAKE) ../../../$(SYSTEM)/o/mintrinsic.o \
			SYSTEM=$(SYSTEM) \
			CC=$(CC) \
			CFLAGS='$(CFLAGS) $(MOTIF_CFLAGS) $(X11_CFLAGS)' );\
	else \
		echo "make: ** Xt's *.h are not in $(MXtINCLUDE)" ;\
		echo "      ** Edit Makefile's variable MXtINCLUDE." ;\
		exit 1 ;\
	fi

o/motifobj.o:
	@if [ -f $(MOTIFINCLUDE)/Xm/Xm.h ] ;\
	then \
		( cd ../virbitmap/X11/intrinsic/motif; \
		$(MAKE) ../../../../$(SYSTEM)/o/motifobj.o \
			SYSTEM=$(SYSTEM) \
			CC=$(CC) \
			CFLAGS='$(CFLAGS) $(MOTIF_CFLAGS) $(X11_CFLAGS)' );\
	else \
		echo "make: ** Motif's *.h are not in $(MOTIFINCLUDE)" ;\
		echo "      ** Edit Makefile's variable MOTIFINCLUDE." ;\
		exit 1 ;\
	fi

#####################################################################
#       D'autres fichiers C
# 
# 
# Pour tester les callexterns (sans cload)
letestextbin: $(cobj) $(BIN)bin.o o/testext.o
	$(CC) $(CFLAGS) $(LDFLAGS) -o letestextbin \
		$(cobj) o/testext.o $(BIN)bin.o \
		$(LDLIBS) 

o/testext.o: ../lltest/testext.c
	$(CC) -c ../lltest/testext.c
	mv testext.o o/testext.o

leftestbin: $(cobj) $(BIN)bin.o o/testfortran.o
	$(CC) $(CFLAGS) $(LDFLAGS) -o leftestbin \
		$(cobj) o/testfortran.o $(BIN)bin.o \
		$(LDLIBS) 

o/testfortran.o: ../lltest/testfortran.f
	f77 -c ../lltest/testfortran.f
	mv testfortran.o o/testfortran.o

# pour les tests de pilotage de Le-Lisp par C
fromcbin: o/lelisp.o o/llstdio.o o/llfloat.o lesoft31bin.o o/fromc.o
	$(CC) $(LDFLAGS) -o fromcbin \
		o/lelisp.o o/llstdio.o o/llfloat.o o/fromc.o lesoft31bin.o \
		$(LDLIBS) 

o/fromc.o: ../lltest/fromc.c
	$(CC) $(CFLAGS) -c ../lltest/fromc.c
	mv fromc.o o

################################################
# FABRICATION DES IMAGES
# 
# si rien n'est precise' on range les cores dans ./llcore/
# si on veut les ranger ailleurs, en conformite' avec le configurateur
# % make lelisp LLCORE=/tmp
LLCORE=
# # # # # # # # # # # # # # # # # # # # # # # # 
# Les tailles par de'faut des zones de donne'es
################################################

# tailles des flottants pour les xxxx31bin
SIZEF31= 0

# tailles des flottants pour les xxxx64bin
SIZEF64= 16

# tailles des flottants pour les xxxxbin

# par defaut: les flottants sont sur 31 bits
FLOAT= $(SIZEF31)

 

# normal avec plutot des CONS <~ 1.5 Mega-octets
STACK_C=6
CODE_C=400
HEAP_C=128
NUMBER_C=0
VECTOR_C=1
STRING_C=5
SYMBOL_C=5
CONS_C=9
SZCONS=  -stack $(STACK_C) -code $(CODE_C) -heap $(HEAP_C) \
	-number $(NUMBER_C) -vector $(VECTOR_C) -string $(STRING_C) \
	-symbol $(SYMBOL_C) -cons $(CONS_C) -float $(FLOAT)

# normal avec plutot du code  <~ 1.5 Mega-octets
STACK_D=6
CODE_D=600
HEAP_D=256
NUMBER_D=0
VECTOR_D=4
STRING_D=5
SYMBOL_D=5
CONS_D=4
SZCODE=  -stack $(STACK_D) -code $(CODE_D) -heap $(HEAP_D) \
	-number $(NUMBER_D) -vector $(VECTOR_D) -string $(STRING_D) \
	-symbol $(SYMBOL_D) -cons $(CONS_D) -float $(FLOAT)

# gros  <~ 2.8 Mega-octets
STACK_P=8
CODE_P=1200
HEAP_P=512
NUMBER_P=0
VECTOR_P=8
STRING_P=12
SYMBOL_P=11
CONS_P=8
SZ++= -stack $(STACK_P) -code $(CODE_P) -heap $(HEAP_P) \
	-number $(NUMBER_P) -vector $(VECTOR_P) -string $(STRING_P) \
	-symbol $(SYMBOL_P) -cons $(CONS_P) -float $(FLOAT)

# petit <~ 700k octets
STACK_M=6
CODE_M=1
HEAP_M=96
NUMBER_M=0
VECTOR_M=2
STRING_M=2
SYMBOL_M=2
CONS_M=4
SZ-= -stack $(STACK_M) -code $(CODE_M) -heap $(HEAP_M) \
	-number $(NUMBER_M) -vector $(VECTOR_M) -string $(STRING_M) \
	-symbol $(SYMBOL_M) -cons $(CONS_M) -float $(FLOAT)
 
# caml
SIZEZ= -stack 64 -code 1200 -heap 1024 -number 0 \
        -vector 30 -string 40 -symbol 8 -cons 15 -float $(FLOAT)

# Tailles courantes
SIZE=$(SZCODE)
SIZEM=$(SZ-)
SIZEH=$(SZ++)

##########################################################
# Les points d'entre'e permettant de faire les syste`mes
##########################################################

# (* CAML
camlispSIZEZ= -stack 24 -code 1200 -heap 1200 -number 0 \
      -vector 30 -string 50 -symbol 4 -cons 15 -float 0

camlispbigSIZEZ= -stack 24 -code 2400 -heap 1500 -number 0 \
      -vector 30 -string 60 -symbol 4 -cons 15 -float 0

camlisp:  conf/camlispconf.ll camlispbin
	./config camlisp camlispbin camlispconf.ll $(camlispSIZEZ)

camlispbig:  conf/camlispconf.ll camlispbin
	./config camlispbig camlispbin camlispconf.ll $(camlispbigSIZEZ)
# CAML *)

### lelisp "systeme standard modulaire"
lelisp:  conf/lelispconf.ll lelispbin llcore/lelisp.core
	./config lelisp lelispbin lelispconf.ll $(LLCORE) $(SIZE)
llcore/lelisp.core:

### lelisp- "systeme standard interprete"
lelisp-:  conf/lelisp-conf.ll lelispbin llcore/lelisp-.core
	./config lelisp- lelispbin lelisp-conf.ll $(LLCORE) $(SIZEM)
llcore/lelisp-.core:

### lelisp++ "gros systeme standard modulaire"
lelisp++:  conf/lelispconf.ll lelispbin llcore/lelisp++.core
	./config lelisp++ lelispbin lelispconf.ll $(LLCORE) $(SIZEH)
llcore/lelisp++.core:

### lelisps "systeme standard compile"
lelisps:  conf/lelispsconf.ll lelispbin llcore/lelisps.core
	./config lelisps lelispbin lelispsconf.ll $(LLCORE) $(SZCONS)
llcore/lelisps.core:

### cmplc "systeme complice modulaire"
cmplc:  conf/cmplcconf.ll lelispbin llcore/cmplc.core
	./config cmplc lelispbin cmplcconf.ll $(LLCORE) $(SIZE)
llcore/cmplc.core:

### cmplc++ "gros systeme complice modulaire"
cmplc++:  conf/cmplcconf.ll lelispbin llcore/cmplc++.core
	./config cmplc++ lelispbin cmplcconf.ll $(LLCORE) $(SIZEH)
llcore/cmplc++.core:

### ceyx "systeme standard modulaire avec CEYX"
ceyx:  conf/ceyxconf.ll lelispbin llcore/ceyx.core
	./config ceyx lelispbin ceyxconf.ll $(LLCORE) $(SIZE)
llcore/ceyx.core:

### lelispX11 "systeme standard modulaire avec BV sur X11"
lelispX11:  conf/leX11conf.ll leX11bin llcore/lelispX11.core
	./config lelispX11 leX11bin leX11conf.ll $(LLCORE) $(SIZE)
llcore/lelispX11.core:

### lelisp: systeme standard modulaire sur 64bitfloats

lelisp64: conf/lelispconf.ll  lefpu64$(EXE)bin
	./config lelisp64 lefpu64$(EXE)bin lelispconf.ll $(LLCORE) $(SIZE) -float $(SIZEF64)

### qq exemples de configurations spe'cifiques:

cpfpu31: conf/cpfpuconf.ll  lefpu31bin
	./config cpfpu31 lefpu31bin cpfpuconf.ll $(LLCORE) $(SIZE)

# etc etc

#########################################################################
# une entre'e ge'ne'riques pour les utilisateurs exigents
# tous les fichiers etant parametre's, on peut refaire son propre binaire
# (on peut meme redifinir le compilo: ex: CC=/bin/f77
# ex: 
# % make monlelispbin USERBIN=monlelispbin USERO="foo.o bar.o"
# pour eventuellement changer de mode flottants
USERBINO=$(BIN)bin.o
# pour le nom du binaire 
USERBIN=monlelispbin
USERXBIN=monlelispX11bin

# les fichiers *.o utilisateurs
USERO=
# pour avoir des flags supplementaires
USERFLAGS=

# le binaire le plus simple
$(USERBIN): $(cobj) $(USERBINO) $(USERO)
	$(CC) $(CFLAGS) -o $(USERBIN) \
		$(cobj) $(USERBINO) $(USERO) \
		 $(LDFLAGS) $(LDLIBS) $(USERFLAGS) 

# le binaire qui integre X
$(USERXBIN): $(cobj) $(x11cobj) $(USERBINO) $(USERO)
	$(CC) $(CFLAGS) $(X11_CFLAGS) -o $(USERXBIN) \
		$(cobj) $(x11cobj) $(USERBINO) $(USERO) \
		$(X11_LDFLAGS) $(X11_LDLIBS) $(LDFLAGS) $(LDLIBS) \
		$(USERFLAGS) 

USERMBIN=monlelispM11bin
$(USERMBIN): $(cobj) $(olitcobj) $(USERBINO) $(USERO)
	$(CC) $(CFLAGS) $(OLIT_CFLAGS) $(X11_CFLAGS) -o $(USERMBIN) \
		$(cobj) $(olitcobj) $(USERBINO) $(USERO) \
		$(OLIT_LDFLAGS) $(OLIT_LDLIBS) \
		$(X11_LDFLAGS) $(X11_LDLIBS) \
		$(LDFLAGS) $(LDLIBS) \
		$(USERFLAGS)

# Une entre'e ge'ne'rique pour aider l'utilisateur
#  a` faire des cores lie's a` son binaire
# 
# Le nom de la commande lancant le systeme 
USERLELISP=monlelisp
# 
# Le configurateur qui dit ce qu'on met dans ce core
# Attention: ce fichier doit etre adresse' par un path absolu
#            ou etre range' dans lelisp/$(SYSTEM)/conf
USERCONF= $(USERLELISP)conf.ll
# 
# Le re'pertoire ou` ranger les cores: par de'faut lelisp/$(SYSTEM)/llcore
#  Attention si on en change $(USERCONF) doit l'inte'grer
USERLLCORE=
# 
# Le binaire de l'utilisateur pour fabriquer ce systeme
#  par defaut c'est le USERXBIN classique integrant X
#  mais on peut aussi avoir:
#  USERLELISPBIN=" \$(USERBIN)" pour ne pas integrer X
#   ou
#  USERLELISPBIN=/home/moi/monbin pour faire ce qu'on veut
#  
USERLELISPBIN=$(USERXBIN)
USERSIZE=$(SIZE)

$(USERLELISP):  $(USERLELISPBIN) $(USERLLCORE)/$(USERLELISP).core
	./config $(USERLELISP) $(USERLELISPBIN) $(USERCONF) $(USERLLCORE) $(USERSIZE)
$(USERLLCORE)/$(USERLELISP).core:
