; .EnTete "Le-Lisp (c) version 15.2" " " "Les modules"
; .EnPied " " "%" " "
; .Chapitre 5 "Les Modules"
;
; .Centre "*****************************************************************"
; .Centre " Ce fichier est en lecture seule hors du projet ALE de l'INRIA.  "
; .Centre " Il est maintenu par ILOG SA, 2 Avenue Gallie'ni, 94250 Gentilly "
; .Centre " (c) Le-Lisp est une marque de'pose'e de l'INRIA                 "
; .Centre "*****************************************************************"

; .Centre "$Header: /nfs/work/lelisp/llib/RCS/module.ll,v 7.2 91/01/08 12:05:43 kuczynsk Exp $"

(unless (>= (version) 15.2)
        (error 'load 'erricf 'module))

(defvar #:sys-package:colon 'module)

; .Section "Les variables globales"

;; Tous les modules charge's en me'moire sont pre'sents dans une
;; des 2 listes suivantes :

(defvar :compiled-list
        (if (boundp ':compiled-list) :compiled-list ()))

(defvar :interpreted-list
        (if (boundp ':interpreted-list) :interpreted-list ()))

;; Les messages d'erreur.

(defmessage :ERRNMD (french "module inexistant")
	            (english "module not found"))
(defmessage :ERRFPR (french "fichier prote'ge'")
	            (english "protected file"))
(defmessage :WARINM (french "chargement du module interpre'te'")
	            (english "load interpreted module"))
(defmessage :ERRNODEF (french "Je ne trouve pas la de'finition de")
                      (english  "can't find definition of"))

; .Section "Fonctions sur les de'finitions de module"

; Une <de'finition de module> est une A-liste de la forme :
;      ((key1 . val1) ... (keyN . valN) (:header . <liste de chai^nes>))
; La clef interne :header contient une liste de chai^nes correspondant
; au fichier de description de module jusqu'a` l'occurrence de la premie`re
; clef qui ne fait pas partie des clefs connus de l'utilisateur (cette liste
; est contenue dans la variable :list-of-user-key).
; Cette clef est remplace'e par :deadheader si les lignes repre'sentant
; la de'finition des clefs utilisateurs ne peuvent plus e^tre utilise'es.
; Dans ce cas les lignes sont quand me^me imprime'es, pre'ce'de'es d'un ;


;; Contient la liste des clefs connus de l'utilisateur.
(defvar :list-of-user-key '(defmodule files import export include))

;; Chai^ne de se'paration des clefs utilisateur et des clefs syste`me.
;; Comme son nom l'indique, cette chai^ne est ajoute'e automatiquement.
;; mais n'a qu'une valeur cosme'tique.
(defvar :EndOfHeader ";;; Added automatically, don't type beyond this line.")

;; Le stockage (durant la lecture du fichier de description des modules)
;; des lignes du fichier est re'alise' au moyen des IT programmables.
;; Il demande l'utilisation des 2 variables globales suivantes :

(defvar :header ())            ; contient la liste des lignes courantes.
(defvar :in-user-part ())      ; indicateur d'e'tat de l'automate.


; .SSection "Lecture d'une de'finition de module"

(defun readdefmodule (module-name)
   ; retourne une de'finition de module.
   (let ((module-file (probepathm module-name)))
        (ifn module-file
	     (error 'readdefmodule ':ERRNMD module-name)
	     (with ((inchan (openi module-file)) )
		   (let ((defmod ())
			 (header ())
			 (keyheader ':header)
			 (#:sys-package:colon  #:sys-package:colon)
			 (#:sys-package:itsoft (cons 'module
						     #:sys-package:itsoft)))
		     ; pre'paration de l'automate
		     (setq :header () :in-user-part t)
		     ; lecture des clefs
		     (untilexit eof
			   ; lecture d'une clef
			   (newl defmod
				 (cons (let ((#:system:read-case-flag ()))
					    (read))
				       (let ((#:system:read-case-flag t))
					    (read))))
			   ; changement de :colon
			   (when (eq (caar defmod) 'defmodule)
				 (setq #:sys-package:colon (cdar defmod)))
			   (if (memq (caar defmod) :list-of-user-key)
			       (if :in-user-part
				   ; rajout des chai^nes correspondant
				   ; a` la clef utilisateur
				   (setq header (append :header header)
					 :header ())
				   ; cas e'trange ou` des clefs
				   ; utilisateur apparaissent apre`s
				   ; les clefs syste`me 
				   (setq keyheader ':deadheader))
			       (setq :in-user-part ())))
		     ; fabrique la de'finition de module :
		     ; ((key1 . val1) .. (keyN . valN) (:header . strings))
		     (setq defmod (nreverse (acons keyheader
						   (nreverse header)
						   defmod)))
		     defmod)))))

(defun :bol ()
   (super-itsoft 'module 'bol ())
   (when :in-user-part
	 (newl :header (substring (inbuf) 0 (sub (inmax) 2)))))


; .SSection "Fonctions de manipulation des de'finitions de modules"

(defun getdefmodule (defmod key)
   (cassq key defmod) )

(defun setdefmodule (defmod key val)
   (let ((slot (assq key defmod)))
        (if (consp slot)
	    (progn (rplacd slot val) defmod)
	    (nconc1 defmod (cons key val)))))


; .SSection "Impression des de'finitions de modules"

(de printdefmodule (defmod mod)
    (let ((oldmod (readdefmodule mod))
	  (header (getdefmodule defmod ':header)))
      (unless (equal oldmod defmod)
	      ; ce n'est pas la me^me description de module
	      ; sinon le fichier n'est pas me^me touche'.
	      (let ((outchan (outchan))
		    (out (probepathm mod)))
		(ifn out
		     (error 'printdefmodule ':ERRNMD mod)
		     (ifn (catcherror () (setq out (openo out)))
			  (error 'printdefmodule ':ERRFPR out)
			  (outchan out)
			  (if (and header
				   (every (lambda (key)
					    (equal (getdefmodule defmod key)
						   (getdefmodule oldmod key)))
					  :list-of-user-key))
			      ; les clefs utilisateur n'ont pas change'
			      (with ((rmargin (1+ (slen (outbuf)))))
				    (let ((#:system:print-for-read ()))
				      (mapc 'print header)
				      (print)
				      (print :EndOfHeader)
				      (:print-rest-of-keys defmod
							   :list-of-user-key)))
			      ; les clefs utilisateur ont change'es
			      (when (getdefmodule defmod ':deadheader)
				    (let ((#:system:print-for-read ()))
				         (mapc (lambda (x) (print "; " x))
					       (getdefmodule defmod
							     ':deadheader))))
			      (:print-rest-of-keys defmod ()))))
		     (close (outchan))
		     (outchan outchan))))
    mod)

(defun :print-rest-of-keys (defmod except)
  (let ((#:system:print-for-read t))
    (mapc (lambda (slot)
	    (let ((key (car slot))
		  (value (cdr slot))
		  )
	      (unless (or (memq key '(:header :deadheader))
			  (memq key except))
		      (cond ((consp value) ; affiche sur plusieurs lignes.
			     (prin key)
			     (princn #/ )
			     (princn #/()
			     (terpri)
			     (mapc 'print value)
			     (princn #/))
			     (terpri)
			     )
			    (t
			     (print key)
			     (print value))))))
	  defmod)))



; .Section "Chargement des modules"

(de loadmodule (name . flags)
   (let ( (loaded (cons () ())) )
      (:loadmodule-aux (concat name) loaded (car flags) (cadr flags))
      ; Traitement des modules charge's en compile'.
      (mapc
         (lambda (m)
            (setq :compiled-list (delq m :compiled-list))
            (setq :interpreted-list (delq m :interpreted-list))
            (newl :compiled-list m) )
         (car loaded) )
      ; Traitement des modules charge's en interpre'te'.
      (mapc
         (lambda (m)
            (setq :compiled-list (delq m :compiled-list))
            (setq :interpreted-list (delq m :interpreted-list))
            (newl :interpreted-list m) )
         (cdr loaded) )
      name ))

(defun :loadmodule-aux (module loaded clos? inter?)
   (let ((def (readdefmodule module))
	 (file-obj? (and (not inter?) (:find-object-file module))))
      ; On se place dans les fichiers charge's.
      (if file-obj?
         (rplaca loaded (cons module (car loaded)))
         (rplacd loaded (cons module (cdr loaded))) )
      (let ( (interp (cdr loaded)) )
         ; On charge si besoin tous les modules importe's.
         (mapc
            (lambda (m)
               (when (and (not (memq m (car loaded)))
                          (not (memq m (cdr loaded))) 
                          (or clos?
                              (not (memq m :compiled-list)) ))
		     (if (and (not clos?) (memq m :interpreted-list))
			 ; Un module importe' est de'ja` en interpre'te'.
			 (setq interp t)
		       ; Sinon on charge ce module.
		       (:loadmodule-aux m loaded clos? inter?) )))
            (getdefmodule def 'import) )
         ; Si le module est compile' on ve'rifie que les modules importe's
         ;  sont bien compile's et que le chargeur existe.
         (when (and file-obj?
                   (or (neq (cdr loaded) interp)
                       (not (featurep 'loader)) ))
            (setq file-obj? ())
            (rplaca loaded (delq module (car loaded)))
            (rplacd loaded (cons module (cdr loaded))) ))
      (if file-obj?
         ; Chargement module compile'.
         (let ( (deb (#:system:ccode)) )
            (protect
	     ; Attention au :READ-CASE-FLAG: cf le code de LOADOBJECTFILE
	     (let ((save #:system:read-case-flag))
	       (setq #:system:read-case-flag 'loadmodule)
	       (funcall (car file-obj?) (cdr file-obj?) t)
	       (when (eq #:system:read-case-flag 'loadmodule)
		     ; Personne n'y a touche: on remet l'ancienne
		     (setq #:system:read-case-flag save)))
	     (putprop module (cons deb (#:system:ccode)) ':limit) ))
         ; Chargement module interpre'te'.
         (when #:system:error-flag (printerror 'loadmodule ':WARINM module))
         (mapc
            (lambda (f) (libloadfile f t))
            (getdefmodule def 'files) ))))

(defun :find-object-file (module)
  ;; recherche de module compile' en plusieurs format.
  ;; Si on trouve un fichier objet, un cons de la fonction de chargement
  ;; et le path du fichier a` charger est retourne'.
  (any (lambda ((search-fn load-fn))
	 (let ((obj-file (funcall search-fn module)))
	   (if obj-file (cons load-fn obj-file))))
       #:system:object-file-formats))

;; Liste de'crivant les formats des fichiers objets.  Chaque e'le'ment
;;  contient le pre'dicat de recherche et la fonction de chargement.
;; Recherche: probepatho   pour chercher dans le #:system:path courant
;; Chargement: loadfile    pour charger un fichier dont le path complet 
;;                         est de'ja` calcule' [loadobjectfile ne fait pas
;;                         l'affaire car il impose alors la pre'sence
;;                         de "" dans la liste des paths]
;;                         [?!?! mais attention au read-case-flag !?!?!]
(defvar #:system:object-file-formats
  '((probepatho loadfile)))

; .Section "De'finition des modules autoload"
  
(defun filegetdef (file symb)
   (let ((real-file (probepathf file)))
     (ifn real-file
	  (error 'filegetdef 'errfile file)
	  (let (us
		(def ()))
            (with ((inchan (openi real-file)))
		  (untilexit eof
		     (when (consp (setq us (read)))
			   (selectq (car us)
				    ((de defun df defmacro dm dmd)
				     (when (eq (cadr us) symb)
					   (close (inchan))
					   (exit eof (setq def us)) ))
				    (t ; Il faut traiter les synonym et ds.
				     )))))
            def ))))

(df autoloadmodule list-of-module
   (mapc (lambda (module)
	   (let ((defmod (readdefmodule module)))
	     (mapc (lambda (fnt)
		     (when (symbolp fnt)
			   (:makeautoload fnt module
					  (getdefmodule defmod 'files))))
		   (getdefmodule defmod 'export) )))
	 list-of-module))

(defun :makeautoload (fnt module files)
   (let ( (def ()) type )
      (while (and (null def) files)
         (setq def (filegetdef (nextl files) fnt)) )
      (ifn def
         (error 'autoload ':ERRNODEF fnt)
         (selectq (car def)
            ((de defun)
               (setq def `(:args (:std-autoload ',fnt) (apply ',fnt :args))
                     type 'expr ))
            (df
               (setq def `(:args (:std-autoload ',fnt) (apply ',fnt :args))
                     type 'fexpr ))
            ((defmacro dmd)
               (setq def `(:args (:std-autoload ',fnt) (cons ',fnt :args))
                     type 'dmacro ))
            (dm
               (setq def `(:args (:std-autoload ',fnt) :args)
                     type 'macro ))
            (t (error 'autoload 'ERRBDF def)) )
         (setfn fnt type def)
         (putprop fnt (or module files) 'autoload) )))

(defun :std-autoload (fnt)
   (let ( (of (valfn fnt)) (files (getprop fnt 'autoload)) rep )
      (if (consp files)
         (mapc (lambda (f) (libloadfile f t)) files)
         (loadmodule files) )
       (when (eq (valfn fnt) of)
          (error 'autoload ':ERRNODEF (cons fnt files)) )))

(defun autoloadp (fnt)
   (getprop fnt 'autoload))
