;;; .EnTete "Le-Lisp (c) version 15.2" " " "Logical Pathnames"
;;; .EnPied "pathname.ll" "%" " "
;;;
;;; .SuperTitre "Fonctions sur les Noms de fichier logiques"
;;; .Auteur "Michel Dana, ENST"
;;;
;;; .Centre "*****************************************************************"
;;; .Centre " Ce fichier est en lecture seule hors du projet ALE de l'INRIA.  "
;;; .Centre " Il est maintenu par ILOG SA, 2 Avenue Gallie'ni, 94250 Gentilly "
;;; .Centre " (c) Le-Lisp est une marque de'pose'e de l'INRIA                 "
;;; .Centre "*****************************************************************"

;;; .Centre "$Header: /nfs/work/lelisp/llib/RCS/path.ll,v 6.27 90/12/10 19:20:00 kuczynsk Exp $"

;;; This file contains the code which handles the virtual pathname
;;; scheme for Le-Lisp. It contains also the special handlers for the
;;; VMS and UNIX operating systems . So it must be re-compiled
;;; during a new installation on a different OS.


;;; Notice for the implementors of Le-Lisp on other operating systems:
;;; 
;;; if you want to extend this module for an other O.S., which name
;;; as the result of (system) is `newsys`, you have to write a driver for
;;; your OS.  This driver must contain the following functions, which
;;; must be explicitely exported by COMPLICE.

;;; #:newsys:namestring : this function takes a pathname as argument
;;; and  evaluates to the external name of the pathname for the O.S.

;;; #:newsys:pathname :  this function takes an external string as an
;;; argument and gives a pathname 


;;; #:newsys:homedir-pathname : This function has no argument and
;;; gives the pathname which represents the "home-directory" of the
;;; current user . If there is no such facility in the current O/S,
;;; this function gives a valid directory.


;;; #:newsys:directory-namestring: This function accepts a pathname as
;;; an argument and gives the external string which represents the
;;; directory part of the pathname 


;;;  #:newsys:temporary-file-pathname : This function takes a string
;;;  as an argument, and builds a pathname which should be a temporary
;;;  file   pathname, as /tmp/foo for UNIX

;;; #:newsys:file-namestring : this function takes a pathname as
;;; argument and gives the external string representing the name type
;;; et version fields of the pathname. If your OS doesn't provide ant
;;; mechanism for version support, you are supposed to emulate it in
;;; the most convenient way.



;;; #:newsys:host-namestring : takes a pathname as argument, and gives
;;; the external string representing the host on which resides the
;;; file... if your host doesn't support network access , you must
;;; return the empty string


;;; #:newsys:device-namestring : takes a pathname as argument and 
;;; returns the external string which represents the physical device 
;;; on which the file system resides. If this facility doesn't exist,
;;; returns the empty string

;;; #:newsys:current-directory : this function will get/set the
;;; working directory of  Lisp process, and also that of the
;;; shell/process (if there is one)

;;; #:newsys:wild : this function will return the list of all pathname
;;; in the file systeme, which can be found according to the pattern
;;; which is the argument .



;;;  You may also write a function #:newsys:check-pathname which will
;;;  check that its argument is a valid pathname for your operating
;;;  system . (i.e. No special character,etc..) 
;;;  this function returns () if the syntax is illegal


(unless (>= (version) 15.2)
	 (error 'load 'erricf 'pathname))


;;;
;;; Les messages d'erreurs.

(defmessage ERRPATHVERSION (french "Version n'est pas un numerique")
                           (english "Version is not numerical"))

(defmessage ERRPATHNOTPATH (french "N'est pas un pathname")
                           (english "not a pathname"))

(defmessage ERRPATHFIELDS
             (french "Attention: un des champs Host, Device ou Version n'est pas vide")
	     (english "Warning : Host, Device or Version fields are not empty"))

(defmessage ERRPATHNOTVMS  (french "Pas une spe'cification VMS")
                           (english "not a VMS specification"))

(defmessage ERRPATHNOTBSD  (french "Pas une spe'cification BSD")
                           (english "not a BSD specification"))

(defmessage ERRPATHNOTSYS5 (french "Pas une spe'cification SYS5")
                           (english "not a SYS5 specification"))

(defmessage ERRPATHNOTAEGIS (french "Pas une spe'cification AEGIS")
                            (english "not an AEGIS specification"))

(defmessage ERRPATHBADNAME
  (french "Pas un champ NAME correct")
  (english "Bad NAME field")
  )

(defmessage ERRPATHOVERFLOW
  (french "Resultat trop long")
  (english "Result too long")
  )



(setq #:sys-package:colon 'pathname)
(add-feature 'pathname)


;;;
;;; Previous name of :wild-string was :wild, but :wild is a keyword too,
;;; and we were never sure which of both was used.

(when (boundp ':wild) ; in case of previous definition.
      (makunbound ':wild))
(defvar :wild-string "*")


;;;
;;; Gross galere : la racine vaut "" dans Unix et "000000" dans VMS
;;; donc on essaie de parametrer ca au mieux.

#+#:system:unixp
(defvar :root-string "")
#-#:system:unixp
(defvar :root-string "000000")

(defvar :colon ".")
(defvar :slash "/")
(defvar :semicolon ":")

;;; the mechanism which calls easily new operating systems
;;;
;;;
(dmd to-system (cmd . larg)
      `(funcall (getfn (system) ,cmd ()) ,@larg))
;;;
;;;


; 1) definition of a  pathname

(defstruct pathname
           host		; name of the host of the file-system
	   device       ; physical device
           directory    ; list of directories
	   name         ; file name
           type         ; extension 
           version      ; version number, or ()

 )


;;;
;;; The predicate for pathnames 

(de pathnamep (p)
    (eq (type-of p) 'pathname)))


;;;
;;; A macro to ensure that an object is a pathname.
;;; Achtung : Pas de eval-when ici !!!

(defmacro :assert (:x :f)
  `(unless (pathnamep ,:x)
	   (error ,:f 'ERRPATHNOTPATH ,:x))
  )


;;;
;;; Another one for the field NAME

(defmacro :assert-name (:x :f)
  `(unless (or (null ,:x) (stringp ,:x) (eq ,:x ':wild))
	   (error ,:f 'ERRPATHBADNAME ,:x)))



;;;1) Let's convert a pathname in an external string

;;;
;;; Given any object (string, symbol, pathname) returns corresponding string.

(defun namestring (p)
  (cond
   ((stringp p)
    p)
   ((symbolp p)
    (string p))
   ((not (pathnamep p))
    (error 'namestring 'errbpa p))
   (#:system:unixp (#:unix:namestring p))
   ((eq (system) 'vaxvms) (#:vaxvms:namestring p))
   (t (to-system 'namestring p))
   ))


;;1.1) Unix Case.. actually no hosts or device .... poor man's
;;     Operating system
(de #:unix:namestring (p)
    (catenate 
     (#:unix:directory-namestring p)
     (#:unix:file-namestring p)))


;;1.2) the same for VMS.. No comments
;;
(de #:vaxvms:namestring (p)
    (catenate
     (#:vaxvms:host-namestring p)
     (#:vaxvms:device-namestring p)
     (#:vaxvms:directory-namestring p)
     (#:vaxvms:file-namestring p)))


;;;
;;; the get functions in the common-lisp flavour

(de pathname-host(p)
    (unless (pathnamep p) (setq p (pathname p)))
    (:host p)))

(de pathname-device (p)
    (unless (pathnamep p) (setq p (pathname p)))
    (:device p)))

(de pathname-directory (p)
    (unless (pathnamep p) (setq p (pathname p)))
    (:directory p)))

(de pathname-name (p)
    (unless (pathnamep p) (setq p (pathname p)))
    (:name p)))

(de pathname-type (p)
    (unless (pathnamep p) (setq p (pathname p)))
    (:type p)))

(de pathname-version (p)
    (unless (pathnamep p) (setq p (pathname p)))
    (:version p)))


;;;
;;; the set functions in the common-lisp flavour

(defun set-pathname-host (p h)
  (:assert p 'set-pathname-host)
  (unless (or (null h) (stringp h))
	  (error 'set-pathname-host 'errnsa h))
  (:host p h)
  )

(defun set-pathname-device (p d)
  (:assert p 'set-pathname-device)
  (unless (or (null d) (stringp d))
	  (error 'set-pathname-device 'errnsa d))
  (:device p d)
  )

(defun set-pathname-directory (p d)
  (:assert p 'set-pathname-directory)
  (unless (listp d)
	  (error 'set-pathname-directory 'errnla d))
  (let ((d2 d) x)
    (while d2
      (setq x (nextl d2))
      (unless (or (stringp x) (memq x '(:current :up :wild)))
	      (error 'set-pathname-directory 'errbpa x))))
  (:directory p d)
  )

(defun set-pathname-name (p n)
  (:assert p 'set-pathname-name)
  (:assert-name n 'set-pathname-name)
  (:name p n)
  )

(defun set-pathname-type (p x)
  (:assert p 'set-pathname-type)
  (unless (or (null x) (stringp x))
	  (error 'set-pathname-type 'errnsa x))
  (:type p x)
  )

(defun set-pathname-version (p v)
  (:assert p 'set-pathname-version)
  (unless (or (numberp v)(null v))
	  (error 'set-pathname-version 'errpathversion v))
  (:version p v)
  )


;;;
;;; Full copy of a pathname.

(defun copy-pathname (p)
   (let ((q (new 'pathname)))
      (:host q (:host p))
      (:device q (:device p))
      (:directory q (copylist (:directory p)))
      (:name q (:name p))
      (:type q (:type p))
      (:version q (:version p))
      q)))



;;;2)  and now, let's convert an external namestring into a pathname..
;;;    that is  more difficult 


;;;
;;; Given any object (string, symbol or pathname), returns corresponding
;;; pathname.

(defun pathname (f)
  (if (pathnamep f)
      f
    (when (symbolp f)
	  (setq f (string f)))
    (cond
     ((not (stringp f))
      (error 'pathname 'errbpa f))
     ((equal f "")(new 'pathname))
     (#:system:unixp (#:unix:pathname f))
     ((eq (system) 'vaxvms) (#:vaxvms:pathname f))
     (t (to-system 'pathname f ))))                
  )



;2.1)  UNIX case

;;; if the string begins with a /, it is an absolute pathname.
;;;                             ../ , you want to go upward in the hierarchy
;;;                             ./ or nothing, it is relative to the
;;;                             current directory. if it contains /,
;;;                             it starts with a directory part,
;;;                             otherwise there is only a filename
;;;                             . : there is only the type field
;;;                             ..N : there is only the version number
;;;                             

(de #:unix:pathname (s)
    (let (( p (new 'pathname))
	  (s1 (string s))
	  (s2 ())
          (s3 ())
          (s4 ())
          (loccurs ())
	  l d
	  )
      (if (eq (slen s1) 0) p		; empty path
	(cond 
	 ((eq (sref s1 0) #//)          ; absolute pathname
	  (setq s1 (substring s1 1))
	  (setq d (ncons ':root)))
	 (( eq (index "../" s1) 0)
	  (setq s1 (substring s1 3))
	  (setq d (ncons ':up)))
	 (( eq (index "./" s1) 0)
	  (setq s1 (substring s1 2))
	  (setq d (ncons ':current)))
	 (( index :slash s1)
	  (setq d (ncons ':current))))

	;; we have parsed the beginning of the string, and we do
	;; actually know if we are an absolute or relative
	;; specification...
	;; we must now parse the directory specification
	
	(while (setq l (index :slash s1))
	  (setq s2 (substring s1 0 l))
	  (cond ((eqstring s2 "..")
		 (unless (eq (car d) ':root)
			 (newl d ':up))
		 )
		((eqstring s2 :colon)
		 (unless (eq (car d) ':root)
			 (newl d ':current)))
		((eqstring s2 :wild-string)
		 (newl d ':wild))
		((eqstring s2 :root-string)
		 )
		(t
		 (newl d s2)))
	  (setq s1 (substring s1 (add1 l))))
	(setq d (nreverse d))
	;; But unfortunately, the keyword :root doesn't exist...
	(when (eq (car d) ':root)
	      (if (cdr d)
		  (nextl d)
		(setq d (ncons :root-string))))
	(:directory p d)
	
	;; here, there are  only the name, type and version fields left
        (let ((slen (slen s1)))
	  (unless  (eqn slen 0)
		   (let ((point (:lastindex s1 (sub1 slen))))
		     (if (null point)
			 (:name* p s1)
		       (let* ((s2 (substring s1 (add1 point)))
			      (version (stratom (slen s2) s2 ())))
			 (if (fixp version)
			     (let (point2)
			       (:version p version)
			       (setq point2 (:lastindex s1 (sub1 point)))
			       (if (null point2)
				   (progn
				     (:version p ()) ;backtrack
				     (:type* p s2)
				     (:name* p (substring s1 0 point)))
				 (:type* p 
					 (substring s1
						    (add1 point2)
						    (sub point (add1 point2))))
				 (:name* p (substring s1 0 point2))) )
			   (:type* p s2)
			   (:name* p (substring s1 0 point)))
			 )))))
    p)))

(de :type* (p s)
    (:type p (if (eqstring s :wild-string) ':wild s)))
(de :name* (p s)
    (:name p (if (eqstring s :wild-string) ':wild s)))

(de :lastindex (strg i)
  (cond 
   ((lt i 0) ())
   ((eq (sref strg i) #/.) i)
   (t (:lastindex strg (sub1 i)))))



;;;2.2 the same for VMS
;;;
;;;the syntaxe is much more complex, but probably easier to parse...
;;;we don't support rooted directory syntax!!!
;;;we don't support the [...] syntax because it has no equivalent in UNIX
;;;for wild carding, we only support
;;; - in a directory specification
;;; * as a full word in directory, file type or version


    (de #:vaxvms:pathname (s)
	(let ((p (new 'pathname))
	      (s1 (string s))
	      (l ())	;to maintain directory list
	      (ll ()))	;just a local variable

	  ;;a- is it a decnet file ?
	  ;no wildcard allowed for node or device spec
	  (when (setq l (index "::" s1 ))
		(:host p (substring s1 0 l))
		(setq s1 (substring s1 (add l 2))))

	  ;;b- on which physical device ?
	  (when (setq l (index :semicolon s1 ))
		(:device p (substring s1 0 l))
		(setq s1 (substring s1 (add1 l))))

	  ;;c- is there a directory part ?
	  ;;    it is possible to have a wildcard

	  (when (and (neq (slen s1) 0)(eq (sref s1 0) #/[))
		(setq s1 (substring s1 1))
		(when (eq (sref s1 0) #/.)
		      (setq s1 (substring s1 1))
		       (:directory p (ncons ':current)))	
		(while (index "]" s1)
		  (if (setq l (scanstring s1 ".]"))
		      (progn (setq ll (substring s1 0 l))
		             (:directory p 
				  (cons (cond ((equal ll "-") ':up)
					      ((equal ll :wild-string) ':wild)
					      ( t ll))
				        (:directory p))))
		    (error '#:vaxvms:pathname 'ERRSXT s))
		  (setq s1 (substring s1 (add1 l))))		  
		(:directory p (nreverse (:directory p))))

	  ;;e- is there a file name ?

	  (if (or (eq (slen s1)0)
		  (eq (sref s1 0) #/.))
	      (setq s1 (substring s1 1))
	    (setq ll (substring s1 0
			  (if (setq l (index :colon s1 )) 
				l 
				(setq l (slen s1)))))
	    (:name p (if (equal ll :wild-string) ':wild ll))
	    (setq s1 (substring s1 (min (add1 l) (slen s1)))))

	  ;;e- is there a type ?
	  (unless (eq (slen s1) 0)
	          (setq ll (substring s1 0
			(if (setq l (index ";" s1 )) l (setq l (slen s1)))))

		  (:type p (if (equal ll :wild-string) ':wild ll))
		  (setq s1 (substring s1 (min (add1 l)(slen s1)))))
	  ;;f- is there a version ?
	  (unless (eq (slen s1) 0)
		  (:version p
                            (if (equal s1 :wild-string) ':wild
			    (or (fixp (stratom (slen s1) s1 ()))))
				))p ))))

	


;;;
;;; Given a pathname, returns its canonical form,
;;; which allows comparaison between pathnames.

(defun c-pathname (p0)
  (let ((p (copy-pathname p0))
	dir dir2 x)
    (setq dir (pathname-directory p))
    (when dir
	  ;; Assainissement.
	  (when (stringp (car dir))
		(setq dir2 (ncons ':root))
		(when (eqstring (car dir) :root-string)
		      (nextl dir))
		)
	  ;; Maintenant, si le pathname est absolu alors dir2 = '(:root)
	  ;; dir contient une liste correcte (sans "" ...)
	  (while dir
	    (setq x (nextl dir))
	    (selectq x
		     (:up
		      (unless (eq (car dir2) ':root)
			      (newl dir2 ':up)))
		     (:current
		      )
		     (t
		      (newl dir2 x))))
	  ;; Restauration du merdier.
	  (setq dir2 (reverse dir2))
	  (if (eq (car dir2) ':root)
	      (if (cdr dir2)
		  (nextl dir2)
		(setq dir2 (ncons :root-string)))
	    (when (and (neq (car dir2) ':up) (pathname-directory p))
		  (newl dir2 ':current)))
	  (set-pathname-directory p dir2))
    p))


;;;
;;; A equal for the pathnames.
;;; #u"/a/./b"  =  #u"/a/b"
;;; #u"/a/../b" <> #u"/b" because of symbolic links in unix.

(defun equal-pathname (p1 p2)
  (:assert p1 'equal-pathname)
  (:assert p2 'equal-pathname)
  (equal (c-pathname p1) (c-pathname p2)))



;;; Now, some funny functions...
;;; let'us give a standard way to get the user home-directory.. this
;;; will be useful for the layered product, as DEC says...



  
(de user-homedir-pathname()
    (cond 
     (#:system:unixp (#:unix:pathname(catenate (getenv "HOME") :slash)))
     ((eq (system) 'vaxvms) (#:vaxvms:pathname(vaxvms_trnlnm "sys$login" "")))
     (t (to-system 'homedir-pathname)))))



;;;
;;; now, let'us build the run-time control file for a layered product 

(de control-file-pathname (appli)
    (let ((s (string appli))
	  (p (user-homedir-pathname)))
      (when (gt (slen s) 12) (setq s (substring s 0 11)))
      (:type  p (catenate s "rc"))
      p)))))

;;;  here is a standard way to create temporary files...
;;;  this is mainly useful for test programms, and other utilities..

;;
(de temporary-file-pathname (seed)
    (cond 
     (#:system:unixp (pathname (catenate"/tmp/" seed)))
     ((eq (system) 'vaxvms)
      (pathname (catenate "sys$scratch:" seed)))
     (t (to-system 'temporary-file-pathname seed))))




;;; a bit more complex : a function that checks that a pathname
;;; adheres to the syntaxe of all operating systems which support
;;; le-lisp... of course, this is not a finite problem...  so there is
;;; no guarantee, but just a help to write portable code...

;;; first the fields device and host are not supported by all O.S and
;;; have a very special syntax and semantic, depending on the O.S.. so
;;; no check needs to be performed for these fields..


(de #:bsd:pathname-check (p) t)
(de #:sys5:pathname-check(p) 
    (let ((l (mcons (:type p)(:name p)(:directory p))))
      (every (lambda(x) (if x (le (slen (string x)) 14) t)) l )
      )))


(de #:aegis:pathname-check(p) t)


(de #:vaxvms:pathname-check (p)
    (let ((l (mcons (:type p)(:name p) (:directory p))))
      (and
       ;;no more than 8 subdirectories
       (le (length (:directory p)) 8)
       ;;only  32 characters each
       (every (lambda(x) (if x (le (slen (string x)) 32) t)) l )
       ;;many characters are illegal...
       (every
	(lambda(x)
	  (not (spanstring x 
			   "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890_-$")))
	l)
       ;;version is a number
       (if (:version p) (fixp (:version p))
	 t)
       ))))))


(de portable-pathname-p (p)
    (with ((outchan t))
	  (:assert p 'portable-pathname-p)
	  (when (and (or (:host p)(:device p)(:version p))
		     #:system:error-flag)
		(printerror 'portable-pathname-p 
			    'ERRPATHFIELDS
			    p))
	  (not (or (:host p)
		   (:device p)
		   (:version p)
		   (or
		     (unless (#:vaxvms:pathname-check p) 
			     (and #:system:error-flag
				  (printerror 'portable-pathname-p 
					      'ERRPATHNOTVMS
					      p)))
		     (unless (#:bsd:pathname-check p) 
			     (and #:system:error-flag
				  (printerror 'portable-pathname-p 
					      'ERRPATHNOTBSD
					      p)))
		     (unless (#:sys5:pathname-check p) 
			     (and #:system:error-flag
				  (printerror 'portable-pathname-p 
					      'ERRPATHNOTSYS5
					      p)))
		     (unless (#:aegis:pathname-check p)
			     (and #:system:error-flag
				  (printerror 'portable-pathname-p 
					      'ERRPATHNOTAEGIS
					      p)))
		     )))
	  ))

;;; a method to print pathames in a fair way
;;;default printing is
;;; #p:the-string-in-the-os-syntaxe, or the typed vector syntax...

(de :prin (p)
    (if #:system:print-for-read
	(progn
	  (let (( #:system:print-for-read ()))
	    (prin "#:" '#.#:sys-package:colon ":#[ "))
	  (mapvector
	   (lambda(x)
	     (prin x)
	     (princn #/ ))
	   p)
	  (princn #/] ))
      (prin (catenate "#p"""  (namestring p) """"))) 
    p)

(defsharp p ()
  (ncons (pathname(read))))

(defsharp u ()
  (ncons (#:unix:pathname (read))))

;;; default values for parsing and merging as defined bye
;;; CLtL

(defvar *default-pathname-defaults* #p"")
(defvar *portable-pathname* ())


(de make-pathname liste-of-elements
    (let ((p (new 'pathname)))
      (:host p 
	     (or (car liste-of-elements) 
		 (:host *default-pathname-defaults*)))
      (:device p
	       (or (cadr liste-of-elements)
		   (:device *default-pathname-defaults*)))
      (:directory p
		  (or (caddr liste-of-elements)
		      (:directory *default-pathname-defaults*)))
      (:name p
	     (let ((name (cadddr liste-of-elements)))
	       (ifn name
		    (:name *default-pathname-defaults*)
		    (:assert-name name 'make-pathname)
		    name)))
      (:type p
	     (or (car (cddddr liste-of-elements))
		 (:type *default-pathname-defaults*)))
      (:version p
		(or (fixp (cadr (cddddr liste-of-elements)))
		    (:version  *default-pathname-defaults*)))
      p)))

           
(defun file-namestring (p)
  (:assert p 'file-namestring)
  (cond
   (#:system:unixp (#:unix:file-namestring p))
   ((eq (system) 'vaxvms) (#:vaxvms:file-namestring p))
   (t( to-system 'file-namestring p))
   ))

(defun directory-namestring (p)
  (:assert p 'directory-namestring)
  (cond
   (#:system:unixp (#:unix:directory-namestring p))
   ((eq (system) 'vaxvms) (#:vaxvms:directory-namestring p))
   (t (to-system 'directory-namestring p))
   ))

(defun host-namestring (p)
  (:assert p 'host-namestring)
  (cond
   (#:system:unixp (#:unix:host-namestring p))
   ((eq (system) 'vaxvms) (#:vaxvms:host-namestring p))
   (t(to-system 'host-namestring p))
   ))
 
(defun device-namestring (p)
  (:assert p 'device-namestring)
  (cond
   (#:system:unixp (#:unix:device-namestring p))
   ((eq (system) 'vaxvms) (#:vaxvms:device-namestring p))
   (t (to-system 'device-namestring p))
   ))


(de #:unix:host-namestring (p)   "")
(de #:unix:device-namestring (p) "")

(de #:unix:directory-namestring (p)
    (ifn (:directory p) ""
	 (let ((q :slash)
	       (y (stringp (car (:directory p)))) )
	   (setq y (if (and y (gt (slen y) 0)) :slash ""))
	   (mapc (lambda(x) (setq y
				  (catenate y 
					    (cond ((stringp x) x)
						  ((eq x ':up) "..")
						  ((eq x ':wild) :wild-string)
						  ((eq x ':current) :colon))
					    q)))
		 (:directory p))
	   y)))

(de #:unix:file-namestring (p)
    (catenate
     (cond ((stringp (:name p)))
	   ((not (:name p)) "")
	   ((eq (:name p) ':wild) :wild-string))
     (when (:type p) :colon)
     (cond ((stringp (:type p))(:type p))
	   ((not (:type p))"")
	   ((eq (:type p) ':wild) :wild-string))
     (when (:version p) :colon)
     (cond ((fixp (:version p))(string (:version p)))
	   ((eq (:version p) ':wild) :wild-string)
	   (t ""))))

(de #:vaxvms:host-namestring (p)
    (if (:host p)
	(catenate (:host p) "::")
      ""))
(de #:vaxvms:device-namestring(p)
    (if (:device p)
	(catenate (:device p) :semicolon)
      ""))

(de #:vaxvms:directory-namestring (p)
    (let ((y "["))
      (if   (:directory p)
	  (progn 
	    (mapc (lambda(x) 
		    (setq y 
			  (cond ((stringp x)
				 (if (or (eq (sref y (sub1 (slen y))) #/[)
					 (eq (sref y (sub1 (slen y))) #/.))
				     (catenate y x)
				   (catenate y :colon x)))
                                        
				((eq x ':wild)
                                 (if (or (eq (sref y (sub1 (slen y))) #/[)
					 (eq (sref y (sub1 (slen y))) #/.))
				     (catenate y :wild-string)
				   (catenate y ".*")))
				((eq x ':current) (catenate y :colon))
				((eq x ':up) (catenate y "-")))))
		  (:directory p))
	    (if (eq (sref y (sub1 (slen y))) #/.)
                (sset y (sub1 (slen y)) #/])
	      (setq y (catenate y "]")))
            (if (eqstring y "[]") "" y))
	"")))

(de #:vaxvms:file-namestring (p)
    (catenate
     (cond
      ((stringp (:name p)) (:name p))
      ((eq (:name p) ':wild) :wild-string)
      ((not (:name p)) "")
      (t (error 'file-namestring 'ERRSXT (:name p))))
     (if (:type p) :colon "")
     (cond
      ((stringp (:type p)) (:type p))
      ((eq (:type p) ':wild) :wild-string)
      ((not (:type p)) "")
      (t (error 'file-namestring 'ERRSXT (:type p))))
     (if (:version p) ";" "")
     (string (:version p))))


(defun merge-pathnames ( p default)
  (:assert p 'merge-pathnames)
  (:assert default 'merge-pathnames)
  (let ((p1 (new 'pathname)))
    (:host p1
	   (or (:host p)
	       (:host default)))
    (:device p1
	     (or (:device p)
		 (:device default)))
    (:directory p1
		(or (:directory p)
		    (:directory default)))
    (:name p1
	   (or (:name p)
	       (:name default)))
    (:type p1
	   (or (:type p)
	       (:type default)))
    (:version p1
	      (or (:version p)
		  (:version default)))
    p1))


;;;
;;; Combination of two pathnames.
;;; Returns a new pathname equal to p2 if it is absolute, else a combination.
;;; This function ignores symbolic links of unix, that is :
;;; (combine-pathnames #u"/a/b/" #u"../c") -> #u"/a/c"

(defun combine-pathnames (p1 p2)
  (:assert p1 'combine-pathnames)
  (:assert p2 'combine-pathnames)
  (let ((dir2 (:directory p2))
	(p1 (c-pathname p1))
	(p2 (c-pathname p2))
	dir x
	)
    (ifn (symbolp (car dir2))
	 ;; dir2 est absolu.
	 (setq dir dir2)
	 ;; dir2 est relatif
	 (setq dir (reverse (:directory p1)))
	 (while (eq (car dir2) ':up)
	   (nextl dir2)
	   (selectq (car dir)
		    (:up
		     (newl dir ':up))
		    (:current
		     (setq dir (cons ':up (cdr dir))))
		    (t
		     (nextl dir)))
	   (unless dir (setq dir (ncons :root-string)))
	   )
	 (when (eq (car dir2) ':current)
	       (nextl dir2)
	       )
	 (setq dir (nreconc dir dir2))
	 (when (and (equal (car dir) :root-string) (cdr dir))
	       (nextl dir))
	 )
    (unless (:host p2) (:host p2 (:host p1)))
    (unless (:device p2) (:device p2 (:device p1)))
    (:directory p2 dir)
    p2))
			     

(de enough-namestring (p . defaults)
    (cond
     ((not  defaults ) (setq defaults *default-pathname-defaults*))
     ((not (pathnamep (setq  defaults (car defaults))))
      (setq defaults (pathname defaults))))
    (let ((p1 (new 'pathname)))
      (unless (equal (:host defaults)
		     (:host p))
	      (:host p1 (:host p)))
      (unless (equal (:device defaults)
		     (:device p))
	      (:device p1 (:device p)))
      (unless (equal (:directory defaults)
		     (:directory p))
	      (:directory p1 (:directory p)))
      (unless (equal (:name defaults)
		     (:name p))
	      (:name p1 (:name p)))
      (unless (equal (:type defaults)
		     (:type p))
	      (:type p1 (:type p)))
      (unless (equal (:version defaults)
		     (:version p))
	      (:version p1 (:version p)))
      (namestring p1)))))
 
             

;;; this part of the code handles the true pathname facility of CLtL..
;;; The hidden mechanism may be different , depending on the operating
;;; system . UNIX has environnment variables which may be put as the
;;; beginning of a word.. VMS has logfical name translations.. etc...

(defun true-pathname (p)
  ;; P is a pathname or a string
  (when (stringp p)(setq p (pathname p)))
  (:assert p 'true-pathname)
  (cond
   (#:system:unixp (#:unix:true-pathname p))
   ((eq (system) 'vaxvms) (#:vaxvms:true-pathname  p))
   (t (to-system 'true-pathname p))
   ))


(de #:unix:true-pathname (p)
    ;; the convention assumed here is that environnement variables
    ;; have been inserted somewhere in the pathname... as the first
    ;; element of the directory list (which will start with :current,)
    ;; or instead of the name of the file... we recognize it because
    ;; it starts with a "$" sign... so we use (getenv) to see if by
    ;; chance...... 
    (let ((new-p (new 'pathname))
          (new-s ()))
      (if
	  (and (eq (car (:directory p)) ':current)
	       (stringp (cadr (:directory p)))
	       (eq (sref (cadr (:directory p)) 0) #/$)
	       (setq new-s (getenv (substring  (cadr (:directory p))
					       1)))
	       (setq new-s (string new-s)))
	  (:directory new-p 
		      (cons 
		       (ifn (eq (sref new-s 0)#//)
			    new-s
			    (substring new-s 1))
		       (caddr (:directory p))))
	(:directory new-p (:directory p)))
      (if (and (stringp (:name p))
	       (eq (sref (:name p) 0 ) #/$)
               (setq new-s (string (getenv (substring (:name p) 1)))))
	  (:name new-p new-s)
	(:name new-p (:name p)))
      (:type new-p (:type p))
      (:version new-p (:version p))
     (#:unix:pathname (#:unix:namestring new-p))))
       


;;; the kernel for  VMS... but it doesn't work yet  since it requires
;;; the help of an internal operating system routine 


(de #:vaxvms:true-pathname (s)
    ;; On VAX/VMS the normal way is to use logical names...
    ;; so what we do is to build the external string, and call the
    ;; system service.. then we build the new pathname
    (pathname (vaxvms_trnlnm (#:vaxvms:namestring p) "")))



;;; now, much greater... 
;;; a get/set working directory, the portable way

(de current-directory &nobind
     ;; P is a pathname, a string, or ()
    (if (gt (arg) 1)
	(error 'current-directory 'errwna 0)
      (let ((p (if (eq (arg) 0) () (arg 0))))
	(cond
	 (#:system:unixp (#:unix:current-directory p))
	 ((eq (system) 'vaxvms) (#:vaxvms:current-directory p))
	 (t (to-system 'current-directory p)) ))
      ))

;; the unix-way
#+ #:system:unixp
(progn
   (de #:unix:current-directory (p)
       (cond ((not p)
	      (let ((the_string (makestring 1024 #/ ))
		    (ret-length 0))
		(setq ret-length (_llgetwd the_string 1024))
		(unless (eq (sref the_string (sub1 ret-length)) #//)
			(sset the_string ret-length #//))
		(substring the_string 0 (add1 ret-length))))
	     ((or (pathnamep p) (stringp p))
	      (let ((the_directory 
		     (or (stringp p)
			 (directory-namestring p))))
		(_llglobb the_directory the_directory 0)))
	     (t (error 'current-directory 'ERRBPA p))))
)

;; the VMS way
#+ (eq (system) 'vaxvms)
(progn
   (de #:vaxvms:getwd ()
       (let ((p0 (vaxvms_trnlnm "SYS$DISK" "")))
	 (catenate p0 
		   (if (eq (sref p0 (sub1 (slen p0))) #/: ) "" 
		     :semicolon)
		   (vaxvms_setddir "" ""))))

   (de #:vaxvms:current-directory (p)
       (ifn p (#:vaxvms:getwd) 
	    (cond
	     ((stringp p)(setq p (#:vaxvms:pathname p)))
	     ((pathnamep p))
	     (t (error 'current-directory 'ERRBPA p)))
	    (vaxvms_setddir
	     (#:vaxvms:device-namestring p)
	     (#:vaxvms:directory-namestring p))
	    (let ((p1 (#:vaxvms:getwd)))
	      (comline (catenate "set default " p1))
	      p1)))
)

#- #:system:unixp
(de #:unix:current-directory (p) ())
#- (eq (system) 'vaxvms)
(de #:vaxvms:current-directory (p) ())


;;; The predicat about directory
;;;
(de directoryp (p)
  (if (or (stringp p) 
	  (pathnamep p))
      (cond (#:system:unixp (if (eq (_lldirectoryp (namestring p)) 0)
				p
			      ()))
	    ((eq (system) 'vaxvms) (#:vaxvms:directoryp p))
	    (t (to-system 'directoryp p)) )
    (error 'directoryp 'errbpa p) ))

(de #:vaxvms:directoryp (s) (error 'eval 'errudf '#:vaxvms:directoryp))

#+#:system:unixp
(progn
  (defextern _llgetwd(string fix) fix )
  (defextern _llglobb (string string fix) fix)
  (defextern _lldirectoryp (string) fix)
)
#-#:system:unixp
(defun _lldirectoryp (a) 0)



;;; And Now, ladies and gentlemen.... The wild carding process
;;; very special ....
;;; the following code uses a pathname or an external string as
;;; argument and returns all wildcarding possibilities... it is the
;;; user's responsability to do what it needs with it...

(de expand-pathname (p)
    ;;p is a pathname or a string which follows the full convention of
    ;;the host system
    (let (currentdir)
      (protect
       (let ((pattern (cond ((stringp p) (pathname p))
			    ((pathnamep p) p)
			    (t (error 'expand-pathname
				      'ERRPATHNOTPATH
				      p))) )
	     savedir
	     savepath
	     list-files
	     )
	 (when (and (setq savedir (pathname-directory pattern))
		    (or (probefile (setq savepath
					 (make-pathname ()()savedir()()())))
			(directoryp savepath))
		    )
	       (setq currentdir (current-directory))
	       (set-pathname-directory pattern ())
	       (current-directory savepath)
	       (setq p pattern)
	       )
	 (setq list-files
	       (cond
		(#:system:unixp (#:unix:wild  p))
		((eq (system) 'vaxvms) (#:vaxvms:wild  p))
		(t (to-system 'wild p))) )
	 (when currentdir
	       (mapc #'(lambda(p)
			 (set-pathname-directory p savedir))
		     list-files))
	 list-files)
       (when currentdir
	     (current-directory currentdir)))
      ))


;;; for documentation compatibility
(defun wildcard (x)
  (expand-pathname x))


#+ #:system:unixp
(progn
; lg de la chaine d'expansion Unix
;  [voir egalement lelisp.c]
(defvar #:unix:wildbuffer (makestring 4096 #/ ))

(de #:unix:wild (p)
    (let ((the_string #:unix:wildbuffer)
	  (the_pattern (or (stringp p) (namestring p)))
	  (the_result ())		; list of the returned pathnames
          (the_slen ())
	  (i ())
          (j ()))			; working indexes
      (setq the_slen (slen the_string))
      (setq i (_llglobb the_pattern the_string the_slen))

      ;; strange return-codes from lelisp.c
      (when (< i 0)
         (setq i (_llglobb the_pattern the_string the_slen))
         (if (< i 0)
            (error 'expand-pathname 'errios i)))
      
      ;; buffer limits exceeded
      (when (lt (differ the_slen i) 6)

         (_llglobb "" "" -1)
         (error 'expand-pathname 'ERRPATHOVERFLOW the_pattern))

      ;;in i, we have now the effective size of the buffer
      ;;the_string : the returned buffer
      (setq the_string (substring the_string 0 i))

      (chrset (sub1 (slen the_string)) the_string #/ )
      (while (neq i 0)
	(setq j (chrpos 32 the_string))
	(let ((file_string (substring the_string 0 j)))
	  (when (probefile file_string)
		(newl the_result (#:unix:pathname file_string))))
	(setq i (slen (setq the_string (substring the_string (add1 j))))))
      (nreverse the_result)))
)
#-#:system:unixp
(de #:unix:wild (p) ())                                  

#+(eq (system) 'vaxvms)
(de #:vaxvms:wild (p)
	(mapcar '#:vaxvms:pathname (vaxvms_wild (or (stringp p)
						   (#:vaxvms:namestring p)))))


;;stubs for VMS special code.. the compiler won't complain
#-(eq (system) 'vaxvms)
(progn
 (de #:vaxvms:wild (p) ())
;;inutile (de vaxvms_setddir (p pp) ()) 
;;inutile (de vaxvms_wild (p) ())
 (de vaxvms_trnlnm (a b) "")
)


;;; this function coerces an external string, and when required,
;;; checks the syntaxe of the pathname

(de coerce-namestring (file-name)
    (if (pathnamep file-name)
	(progn          
	  (when *portable-pathname* (portable-pathname-p file-name))
	  (namestring file-name))  
      file-name))


#+(eq (system) 'vaxvms)
    (progn
	(defextern vaxvms_trnlnm "" (string string) string)
	(defextern vaxvms_wild  "" (string) t)
	(defextern vaxvms_setddir "" (string string) string)
    )


