(* $Id: color.ml,v 8.2 91/06/19 19:41:16 ddr Exp $
 *
 * Rogloglo Toolkit: colors and patterns
 *
 * $Log:	color.ml,v $
 * Revision 8.2  91/06/19  19:41:16  ddr
 * - merge avec zinc 1.5
 * 
 * Revision 8.1  91/06/15  10:07:48  ddr
 * - merge avec zinc
 * 
 * Revision 7.3  91/05/31  17:20:22  ddr
 * - sauvegarde version
 *)

#standard arith false;;
#fast arith false;;

let CM = 65535;;

let rt_change_color =
  let xcol = mallocated_var alloc_XColor (ref None) in
function (col, red_val, green_val, blue_val) ->
  let xdm = col.col_xdm
  and xcol = xcol() in
  set_XColor_pixel(col.pixel, xcol);
  let red_val = max 0 (min CM (256*red_val))
  and green_val = max 0 (min CM (256*green_val))
  and blue_val = max 0 (min CM (256*blue_val)) in
  set_XColor_red(CSHORT red_val, xcol);
  set_XColor_green(CSHORT green_val, xcol);
  set_XColor_blue(CSHORT blue_val, xcol);
  set_XColor_flags(DoRed_DoGreen_DoBlue, xcol);
  XStoreColor(xdm.dpy, xdm.cmap, xcol);
  ()
;;

let rt_create_color =
  let pp = mallocated_var (fun _ -> alloc_LongRef void, alloc_LongRef void)
    (ref None) in
function (xd, red_val, green_val, blue_val) ->
  let (pixels, plane_masks) = pp() in
  let xdm = xd.xdm in
  if is_null(XAllocColorCells(
    xdm.dpy, xdm.cmap, Zero_Int, plane_masks, Zero_Int, pixels, One_Int
  )) then failwith "rt_create_color";
  let col = {
    col_xdm = xdm;
    pixel = LongRef_value pixels
  } in
  rt_change_color(col, red_val, green_val, blue_val);
  col

and rt_black_color xd =
  let xdm = xd.xdm in {col_xdm = xdm; pixel = xdm.black}
and rt_white_color xd =
  let xdm = xd.xdm in {col_xdm = xdm; pixel = xdm.white}
and color_pixel col = num_of_C_Long col.pixel
;;

let rt_select_color col =
  let xdm = col.col_xdm in
  XSetForeground(xdm.dpy, xdm.gc, col.pixel);
  XSetFillStyle(xdm.dpy, xdm.gc, FillSolid);
  ()
;;
