(* $Id: misc.ml,v 8.6 91/08/06 17:56:43 ddr Exp $
 *
 * Rogloglo toolkit: miscellaneous functions
 *
 * $Log:	misc.ml,v $
 * Revision 8.6  91/08/06  17:56:43  ddr
 * - placage des widgets transients
 * 
 * Revision 8.5  91/08/05  15:20:19  ddr
 * - pb openwin
 * 
 * Revision 8.4  91/08/05  15:18:39  ddr
 * *** empty log message ***
 * 
 * Revision 8.3  91/06/19  19:49:15  ddr
 * - merge avec zinc 1.6
 * 
 * Revision 8.2  91/06/17  10:11:33  ddr
 * - merge avec zinc
 * 
 * Revision 8.1  91/06/15  10:16:28  ddr
 * - merge avec zinc
 * 
 * Revision 7.6  91/06/07  20:14:47  ddr
 * - redistrib
 *)

#standard arith false;;
#fast arith false;;

let rt_create_subwidget (pwid, x, y, wdesc) =
  let xd = pwid.wid_xd in
  let (width, height, border) = wdesc.wsize xd.xdm in
  let wid = wdesc.wcreate(xd, pwid.win, wdesc, x, y, width, height, border) in
  pwid.children <- wid::pwid.children;
  wid

and rt_move_widget =
  let mask = it_list (curry Int_Add) (Zero_Int) [CWX; CWY; CWStackMode]
  and xwc = mallocated_var alloc_XWindowChanges (ref None) in
function (wid, x, y) ->
  let xdm = wid.wid_xd.xdm in
  let xwc = xwc() in
  set_XWindowChanges_x(CINT x, xwc);
  set_XWindowChanges_y(CINT y, xwc);
  set_XWindowChanges_stack_mode(Above, xwc);
  XConfigureWindow(xdm.dpy, wid.win, mask, xwc);
  wid.x <- x; wid.y <- y;
  ()

and rt_reparent_widget(wid, pwid, x, y) =
  XReparentWindow(wid.wid_xd.xdm.dpy, wid.win, pwid.win, CINT x, CINT y);
  ()

and rt_resize_widget(wid, width, height) =
  let width = max 1 width and height = max 1 height in
  XResizeWindow(wid.wid_xd.xdm.dpy, wid.win, CINT width, CINT height);
  ()
;;

let rt_move_resize_widget(wid, x, y, width, height) =
  let xdm = wid.wid_xd.xdm in
  let width = max 1 width and height = max 1 height in
  XRaiseWindow(xdm.dpy, wid.win);
  XMoveResizeWindow(
    xdm.dpy, wid.win,
    CINT x, CINT y, CINT width, CINT height
  );
  wid.x <- x; wid.y <- y;
  ()
;;

let xswa = mallocated_var alloc_XSetWindowAttributes (ref None);;

type position =
  C'AutoPosition
| C'UserPosition of num * num
;;

let UserPosition(x, y) = C'UserPosition(x, y)
and AutoPosition = C'AutoPosition
;;

let rt_create_located_widget =
  let xsh = mallocated_var alloc_XSizeHints (ref None) in
function(xd, wname, iname, position, wdesc) ->
  let xdm = xd.xdm in
  let xsh = xsh() in
  let (x, y) = (match position with
    C'UserPosition(x, y) ->
      set_XSizeHints_x(CINT x, xsh);
      set_XSizeHints_y(CINT y, xsh);
      set_XSizeHints_flags(USPosition, xsh);
      x, y
  | C'AutoPosition ->
      set_XSizeHints_flags(PPosition, xsh);
      0, 0
  ) in
  let (width, height, border) = wdesc.wsize xdm in
  let wid = wdesc.wcreate(
    xd, xdm.rootw, wdesc, x, y, width, height, border
  ) in
  XStoreName(xdm.dpy, wid.win, wname);
  XSetIconName(xdm.dpy, wid.win, iname);
  XSetNormalHints(wid.wid_xd.xdm.dpy, wid.win, xsh);
  set_wm_hints(xd, wid);
  wid
;;

let rt_create_transient_widget(pwid, wname, wdesc) =
  let xd = pwid.wid_xd in
  let xdm = xd.xdm in
  let (width, height, border) = wdesc.wsize xdm in
  let wid = wdesc.wcreate(
    xd, xdm.rootw, wdesc, 0, 0, width, height, border
  ) in
  XStoreName(xdm.dpy, wid.win, wname);
  let xswa = xswa() in
  set_XSetWindowAttributes_save_under(One_Int, xswa);
  XChangeWindowAttributes(xdm.dpy, wid.win, CWSaveUnder, xswa);
  XSetTransientForHint(xdm.dpy, wid.win, pwid.win);
  set_wm_hints(xd, wid);
  wid
;;

let rt_map_transient_widget =
  let xsh = mallocated_var alloc_XSizeHints (ref None) in
function (wid, x, y) ->
  let xdm = wid.wid_xd.xdm in
  let x = min (xdm.root_width-wid.width) (max 0 x)
  and y = min (xdm.root_height-wid.height) (max 0 y) in
  wid.is_mapped <- true;
  XUnmapWindow(xdm.dpy, wid.win);
  XMoveWindow(xdm.dpy, wid.win, CINT x, CINT y);
  let xsh = xsh() in
  set_XSizeHints_x(CINT x, xsh);
  set_XSizeHints_y(CINT y, xsh);
  set_XSizeHints_flags(USPosition, xsh);
  XSetNormalHints(xdm.dpy, wid.win, xsh);
  XMapRaised(xdm.dpy, wid.win);
  ()
;;

let popup_border = ref 2
;;

let rt_create_popup_widget(xd, wdesc) =
  let xdm = xd.xdm in
  let (width, height, border) = wdesc.wsize xdm in
  let wid = wdesc.wcreate(
    xd, xdm.rootw, wdesc, 0, 0, width, height, !popup_border
  ) in
  let xswa = xswa() in
  set_XSetWindowAttributes_save_under(One_Int, xswa);
  set_XSetWindowAttributes_override_redirect(One_Int, xswa);
  XChangeWindowAttributes(
    xdm.dpy, wid.win, Long_OR (CWSaveUnder, CWOverrideRedirect), xswa
  );
  wid
;;

let rt_map_popup_widget(wid, x, y, lev) =
  let xdm = wid.wid_xd.xdm in
  let x = min (xdm.root_width-wid.width) (max 0 x)
  and y = min (xdm.root_height-wid.height) (max 0 y) in
  xdm.popped_up <- iterate (fun
    (win::winl) ->
      XUnmapWindow(xdm.dpy, win);
      winl
  | [] -> []
  ) (length xdm.popped_up - lev) xdm.popped_up;
  xdm.popped_up <- wid.win::xdm.popped_up;
  XMoveWindow(xdm.dpy, wid.win, CINT x, CINT y);
  XMapRaised(xdm.dpy, wid.win);
  ()
;;
