(* $Id: pattern.ml,v 8.1 91/06/15 10:29:27 ddr Exp $
 *
 * Rogloglo Toolkit: patterns
 *
 * $Log:	pattern.ml,v $
 * Revision 8.1  91/06/15  10:29:27  ddr
 * - merge avec zinc
 * 
 *)

#standard arith false;;
#fast arith false;;

type pattern = {
  patt_xdm    : xdata_m;
  pattern     : Pixmap
}
;;

let rt_create_pattern(xd, data, width, height) =
  let xdm = xd.xdm in
  let pixm = XCreateBitmapFromData(xdm.dpy, xdm.rootw, data,
    CINT width, CINT height
  ) in
  {patt_xdm = xdm; pattern = pixm}  
;;

let rt_select_pattern patt =
  let xdm = patt.patt_xdm in
  XSetStipple(xdm.dpy, xdm.gc, patt.pattern);
  XSetFillStyle(xdm.dpy, xdm.gc, FillOpaqueStippled);
  ()
;;
