(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                            CAML                                       *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            Inria                                      *)
(*                      Domaine de Voluceau                              *)
(*                      78150  Rocquencourt                              *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* gtype_gram The grammar of gtype's and mltype's                        *)
(*            Michel Mauny                                               *)
(*            Ascander Suarez                                            *)
(*            Pierre Weis                                                *)
(*            (Last edit date : Thu Mar 30 10:39:39 1989)                *)

system module gtype_gram;;

#standard arith true;;
#fast arith true;;

(*|
Value reset_vars_in_parsing : (unit -> unit)
Value mkvar_in_parsing : (string -> int)
prelude.ml{assoc,incr}
|*)
(* Used to associate a type variable number to a character string while parsing
   a type *)
let reset_vars_in_parsing,mkvar_in_parsing =
    let l,i = ref ([]:(string * int) list),ref 1 in
    (fun ()  ->  l:=[];i:=1;()),
    (fun s  ->  assoc s !l ?
	  	(let j=!i in l:= (s,j)::!l;incr i;j));;

type type_tag = Tag_gtype | Tag_mltype;;
let constr_of = function Tag_gtype -> "Gconsttype" | Tag_mltype -> "Consttype"
and var_of =
    function Tag_gtype -> "Gvartype" |
    Tag_mltype -> raise parse "variables forbidden in syntax of mltypes"
;;

let type_of_infix (i,t1,t2) =
 fun tag -> MLapply
             (MLvar (constr_of tag),
              MLpair(MLconst (mk_type (i, [t1 tag;t2 tag])),
                     MLlist(t1 tag,[t2 tag])),
              [])
;;

let type_of_constr1 (gtyc,gtarg) =
 fun tag -> MLapply
             (MLvar (constr_of tag),
              MLpair(MLconst (mk_type (gtyc,[gtarg tag])),
                     MLlist(gtarg tag,[])),
              [])
;;

let type_of_constr0 id =
 fun tag -> MLapply
             (MLvar (constr_of tag),
              MLpair(MLconst (mk_type (id,[])),MLvar ""),
              [])
;;

let type_of_constr2 (gtl,gt,gtyc) =
 fun tag ->
  let tyl =
   let tyl1 = gtl tag in
   let ty = gt tag in ty::tyl1 in
   MLapply
   (MLvar (constr_of tag),
    MLpair(MLconst (mk_type (gtyc, tyl)),
           MLlist (uncons (rev tyl))),
    [])
;;

let type_of_var v =
 fun Tag_gtype -> MLapply
                   (MLvar "Gvartype",
                    MLconst (mlint (mkvar_in_parsing v)),
                    [])
   | Tag_mltype -> raise parse "variables forbidden in syntax of mltypes"
;;

let type_of_escape_var esc =
 fun Tag_gtype -> MLapply(MLvar "Gvartype",esc,[])
   | Tag_mltype -> raise parse "variables forbidden in syntax of mltypes"
;;

let type_of_escape (gtyc,gtarg) =
 fun tag ->
  MLapply
   (MLvar (constr_of tag),
    MLpair (gtyc,gtarg tag),
    [])
;;

grammar for values Type =
precedences
    right "~}" ">>";    (* To make sure of going back to caml *)
    right "->";
    right "or";
    right "&";
    right ",";
    right INFIX;
    right "@";
    right "::";
    left "+" "-";
    left "*" "/"
;

rule entry gtype =
    parse GGtype gty accept gty(Tag_gtype)

and entry mltype =
    parse GGtype gty accept gty(Tag_mltype)

and Gtype1 =
    parse Varty vty -> vty
	| Escape esc -> (fun tag -> esc)
	| IDENT id -> type_of_constr0 id
	| Literal "("; GGtype gt; Literal ")" -> gt
	| Gtype1 gtarg; IDENT gtyc -> type_of_constr1 (gtyc, gtarg)
	| Gtype1 gtarg; Literal "^"; {parse_caml_expr0 ()} gtyc
	  -> type_of_escape (gtyc,gtarg)
	| Literal "("; Gtypel gtl; GGtype gt; Literal ")"; IDENT gtyc
	  -> type_of_constr2 (gtl,gt,gtyc)

and Gtypel =
    parse Gtypel gtl; GGtype gt; Literal ","
          -> (fun tag -> (gt tag)::(gtl tag))
	| GGtype gt; Literal "," -> (fun tag -> [gt tag])

and Gtype2 =
    parse Gtype1 t1; Type_infixes i; Gtype2 t2 -> type_of_infix (i,t1,t2)
	| Gtype1 t -> t

and GGtype =
    parse GGtype t1; Literal ("->" as i); GGtype t2 -> type_of_infix (i,t1,t2)
        | Gtype2 t1; Literal ("*" as i); GGtype t2 -> type_of_infix (i,t1,t2)
	| Gtype2 gt -> gt

and Varty =
    parse Literal "'"; IDENT v -> type_of_var v
        | Literal "'"; INFIX v -> type_of_var v
	| Literal "'"; Escape esc -> type_of_escape_var esc

and Escape =
    parse Literal "^"; {parse_caml_expr0 ()} e -> e
        | Literal "{^"; {parse_caml_expr()} prg; Literal "^}" -> prg

and Inf =
    parse INFIX i -> i
        | Literal ("+" as p) -> p  | Literal ("&" as m) -> m
        | Literal ("/" as d) -> d  | Literal ("<=" as l) -> l
        | Literal (">=" as g) -> g | Literal ("<>" as d) -> d
        | Literal ("<" as l) -> l  | Literal (">" as g) -> g
        | Literal ("::" as c) -> c | Literal ("@" as a) -> a
        | Literal ("or" as d) -> d

and Type_infixes =
    parse Inf i -> i | Literal ("-" as m) -> m | Literal (":=" as a) -> a

(* Missing MLIdent2 ? (cf. caml_gram.ml) *)
;;

let parse_gtype = (Type "gtype").Parse_raw
and parse_mltype = (Type "mltype").Parse_raw
;;

let gtype = Type;;

end module with
 value parse_gtype
   and parse_mltype
   and gtype
;;
