/*************************************************************************/
/*                                                                       */
/*                     Projet      Formel                                */
/*                                                                       */
/*                            CAML                                       */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*                            Inria                                      */
/*                      Domaine de Voluceau                              */
/*                      78150  Rocquencourt                              */
/*                            France                                     */
/*                                                                       */
/*************************************************************************/

/* talkingto.c	Communication between Unix processes                     */
/*		Robert Ehrlich						 */

/* This file must be compiled using the command                          */
/*                    cc -o talking_to talkingto.c                       */

#include <sys/ioctl.h>
struct sgttyb sgttybuf;

char letters[] = "pqr";
char num [] = "0123456789abcdef";
char tty[] = "/dev/pty..";
/*	      0123456789	*/
char ttyin[] = "OPTY=/dev/tty..";
char ttyout[] = "IPTY=/dev/tty..";

#define LETTER 8
#define NUM 9
#define TYPE 5
#define ENVPLUS 5
#define endof(x) ((x)+(sizeof x))

char *ttyio[] = { ttyout+ENVPLUS, ttyin+ENVPLUS };
char *io[] = { "input", "output" };


int fds[2];
int lisppid, maplepid,status,pid;

extern int errno;
extern char **environ;

main (argc, argv, envp) char **argv; char **envp;
{
	register int fd, nfd = 0;
	register char *pl, *pn;

	for(pl = endof(letters)-1; pl > letters;) {
		tty[LETTER] = *--pl;
		for(pn = endof(num)-1; pn > num;) {
			tty[NUM] = *--pn;
			if ((fd = open(tty,nfd)) >= 0) {
				ttyio[nfd][NUM] = *pn;
				ttyio[nfd][LETTER] = *pl;
				fds[nfd] = fd;
				if(++nfd == 2) goto found;
			}
		}
	}
	printf("Can't find free pty's\n");
	exit(1);
found:
	close(fds[0]); close(fds[1]);
	if((maplepid = fork()) < 0) exit(errno);
	if(!maplepid) {
		fd = open("/dev/tty",2);
		ioctl(fd, TIOCNOTTY);
		close(fd);
		setpgrp(0,0);
		for (nfd = 0; nfd < 2; ++nfd) {
			close(nfd);
			if ((fd = open(ttyio[1-nfd],nfd)) != nfd) {
				dup2(2,1);
				printf("%s %s: error while redirecting standard %s\n",
					argv[0], argv[1], io[nfd]);
				perror(ttyio[1-nfd]);
				exit(errno);
			}
		}
		ioctl(1, TIOCGETP, &sgttybuf);
		sgttybuf.sg_flags |= CRMOD|CBREAK;
		sgttybuf.sg_flags &= ~ECHO;
		ioctl(1, TIOCSETP, &sgttybuf);
		execlp(argv[1],argv[1],0);
		perror("argv[1]");
		exit(errno);
	}
	if ((lisppid = fork()) < 0) {
		kill(maplepid,9);
		killpg(maplepid,9);
		printf("%s: can't create %s process\n", argv[0], argv[2]);
		perror("fork");
		exit(errno);
	}
	if (!lisppid) {
		register char **cppto, **cppfrom, **av = argv, **ep = envp;
		cppto = av - 2;
		cppfrom = av;
		while (*cppto++ = *cppfrom++);
		cppto = ep - 2;
		cppfrom = ep;
		while (*cppto++ = *cppfrom++);
		ttyin[TYPE+ENVPLUS] = 'p';
		ttyout[TYPE+ENVPLUS] = 'p';
		*cppto = ttyout;
		*--cppto = ttyin;
		environ = ep - 2;
		execvp(*av, av);
		printf("%s:can't exec %s\n", av[-2], av[0]);
		perror("exec");
		exit(errno);
	}
	setpgrp(0,0);
	while ((pid = wait(&status)) > 0) {
		if(pid == lisppid) {
			kill(maplepid,9);
			killpg(maplepid,9);
		}
	}
}
