/*************************************************************************/
/*                                                                       */
/*                     Projet      Formel                                */
/*                                                                       */
/*                            CAML                                       */
/*                                                                       */
/*************************************************************************/
/*                                                                       */
/*                            Inria                                      */
/*                      Domaine de Voluceau                              */
/*                      78150  Rocquencourt                              */
/*                            France                                     */
/*                                                                       */
/*************************************************************************/

/* xdr_get.ml    Define in C the function get                            */
/*		 Gilles Dowek						 */

#include <rpc/rpc.h>

typedef struct bitstring { int size; char *ptr; } bitstring;

bool_t xdr_fake(xdrs, objp)
XDR *xdrs;
char **objp;
{
    switch (xdrs->x_op) {
      case XDR_ENCODE:
	return (XDR_PUTBYTES(xdrs,
			     ((bitstring *)objp)->ptr,
			     ((bitstring *)objp)->size));

      case XDR_DECODE:
	*objp = (char *)xdrs;

      case XDR_FREE:
	return TRUE;
    }
    return FALSE;
}

int caml_xdr_getbytes(xdrs, sptr, ssize)
XDR *xdrs;
char *sptr;
int ssize;
{
    return (XDR_GETBYTES(xdrs, sptr, ssize));
}
