module turtle_graphics
using
value moveto_PS : float * float -> unit;
value lineto_PS : float * float -> unit;
value rlineto_PS : float * float -> unit;
value rmoveto_PS : float * float -> unit;
value stroke_PS : unit -> unit;;

#arith float;;
#arith int;;

let Pi = 2.0*(acos 0.0);;
let cva a = Pi*a/180.0;;
let sinus = sin o cva;;
let cosinus = cos o cva;;


(* Drawing Conventions  *)

let coef = 0.2
and dcoef = 0.6;;


(* State *)

let a = ref 0.0
and d =ref 10.0
and xm=ref 1.0
and ym=ref 0.0
and cpoint= ref (0.0,0.0)
and spoint= ref (0.0,0.0);;

let set_starting_angle n =
  a:= n;
  xm:=cosinus !a;
  ym:=sinus !a;;  

let set_starting_point ((x,y) as p) =
  cpoint := p;
  spoint := (x+!xm*!d*coef,y+!ym*!d*coef);
  moveto_PS p;;



let stroke () =
  lineto_PS !spoint;
  let X= fst !spoint + !xm*!d*dcoef
  and Y = snd !spoint + !ym*!d*dcoef
  in
    lineto_PS (X,Y);
    cpoint:= (fst !cpoint + !xm * !d,snd !cpoint + !ym * !d);
    spoint:= (fst !cpoint + !xm * !d*coef,snd !cpoint + !ym * !d*coef);
    stroke_PS();
    moveto_PS(X,Y);;

let move () =
  lineto_PS !cpoint;
  rmoveto_PS (!xm*!d,!ym*!d);
  cpoint:= (fst !cpoint + !xm * !d,snd !cpoint + !ym * !d);
  spoint:= (fst !cpoint + !xm * !d*coef,snd !cpoint + !ym * !d*coef);;


let turn b =
  a:=!a+b;
  xm:=cosinus !a;
  ym:=sinus !a;
  spoint:= (fst !cpoint + !xm * !d*coef,snd !cpoint + !ym * !d*coef);
  ();;




let rec snake =
  fun 0 -> ()
    | n -> snake(n-1);
           stroke();
           turn (-90.0);
           stroke();
           turn (-90.0);
           stroke();
           turn (90.0);
           snake(n-1);           
           stroke();
           turn (90.0);
           stroke();
           turn (90.0);
           snake(n-1);           
           stroke();
           turn (-90.0);
           stroke();
           turn (-90.0);
           stroke();
           turn (90.0);
           snake(n-1);;

let Snake n (x,y) =
           set_starting_angle 0.0;
           set_starting_point (x,y);
           stroke();
           turn (90.0);
           snake(n);
           stroke();
           turn (90.0);
           stroke();
           turn (90.0);
           snake(n);
           stroke();;

let rec anklets =
   fun 0 ->  ()
     | n ->  anklets (n-1);
             stroke();
             anklets (n-1);
             turn (-45.0);
             turn (-45.0);
             anklets (n-1);
             stroke();
             anklets (n-1);;

let Anklets n (x,y) =
           set_starting_angle 0.0;
           set_starting_point (x,y);
           turn (-45.0);
           anklets (n);
           turn (-45.0);
           turn (-45.0);
           anklets (n);;

let f()=  rlineto_PS(!xm*!d,!ym*!d);
          stroke_PS();
          cpoint:= (fst !cpoint + !xm*!d
                   ,snd !cpoint + !ym*!d);
          moveto_PS !cpoint;;
let l()=  a:=!a+90.0;
  xm:=cosinus !a;
  ym:=sinus !a;;
let r()=  a:=!a-90.0;
  xm:=cosinus !a;
  ym:=sinus !a;;


let rec crosses =
  fun 0 -> f()
    | n -> crosses(n-1);
           l();
           crosses(n-1);
           r();
           crosses(n-1);
           l();
           crosses(n-1);
           r();f();r();
           crosses(n-1);
           l();
           crosses(n-1);
           r();
           crosses(n-1);
           l();
           crosses(n-1);;

let Crosses n (x,y) =
           set_starting_angle 0.0;
           cpoint:= (x,y);
           moveto_PS(x,y);
           crosses n;
           l();f();r();f();l();
           crosses n;
           l();f();r();f();l();
           crosses n;
           l();f();r();f();l();
           crosses n;
           l();f();r();f();;



let rec A =
    fun 0 -> ()
      | n -> move();
             turn (-60.0);
             stroke();
             turn (60.0);
             Z(n);
             turn (60.0);
             stroke();
             turn (-60.0);
             move();
             A(n-1)
and Z =
     fun 0 -> ()
       | n -> stroke();
              turn (-60.0);
              stroke();
              stroke();
              turn (-60.0);
              stroke();
              turn (-60.0);
              turn (-60.0);

              turn (-60.0);
              turn (-60.0);
              Z(n-1);

              turn (-60.0);
              stroke();
              stroke();
              turn (-60.0);
              stroke();
              turn (-60.0);
              turn (-60.0);
              stroke();
              turn (-60.0);
              stroke();
              stroke();
              turn (-60.0);
              stroke();
              turn (-60.0);
              turn (-60.0);;


let Mango_leaves n (x,y) =
           set_starting_point (x,y);
           A(n);
           turn (-60.0);
           turn (-60.0);
           turn (-60.0);
           A(n);;




end module
with
value set_starting_point
  and Snake
  and Anklets
  and Crosses
  and d;;
