\begin{caml_primitive}
is_int_big_int : big_int -> bool
int_of_big_int : big_int -> int
big_int_of_int : int -> big_int
\end{caml_primitive}
\conceptindex{coercion between types \verb"int" and \verb"big_int"}

\verb"is_int_big_int bi" yields true if and only if the \verb"big_int"
\verb"bi" fits in an \verb"int". 

\verb"int_of_big_int bi" is the \verb"int" representing the
\verb"big_int" \verb"bi" if \verb"bi" fits in an \verb"int". 

\verb"big_int_of_int" maps an \verb"int" onto the corresponding
\verb"big_int".

\exple
\begin{small}
\begin{verbatim}
#is_int_big_int (big_int_of_int biggest_int);;
true : bool

#is_int_big_int (big_int_of_int monster_int);;
true : bool

#is_int_big_int (abs_big_int (big_int_of_int monster_int));;
false : bool

#is_int_big_int (succ_big_int (big_int_of_int biggest_int));;
false : bool

#int_of_big_int (big_int_of_int biggest_int);;
32767 : int

#int_of_big_int (succ_big_int (big_int_of_int biggest_int));;

Evaluation Failed: failure "int_of_big_int"

#big_int_of_int monster_int;;
#(-32768) : big_int
\end{verbatim}
\end{small}
