\begin{caml_primitive}
is_digit_int : nat * int -> bool
is_digit_normalized : nat * int -> bool
is_digit_zero : nat * int -> bool
is_digit_odd : nat * int -> bool
is_zero_nat : nat * int * int -> bool
num_leading_zero_bits_in_digit : nat * int -> int
is_nat_int : nat * int * int -> bool
nth_digit_nat : nat * int -> int
\end{caml_primitive}
\verb"is_digit_int (nat, off)" tests if $nat_{off}$ can be coerced
to an \verb"int", i.e. this digit has less than $length\_of\_int$ bits,
i.e. is smaller than $biggest\_int$. 

\verb"is_digit_normalized (nat, off)" returns true if 
\begin{eqnarray*}
nat_{off} \geq \frac{B} {2}.
\end{eqnarray*}
%                    B
%       nat     >=  --- .
%          off       2
%
\verb"is_digit_zero (nat, off)" returns true if $nat_{off}=0$.

\verb"is_digit_odd (nat, off)" returns true if $nat_{off}$ is odd.

\verb"is_zero_nat (nat, off, len)" tests if subnat $nat_{off, len}$ is null.

\verb"num_leading_zero_bits_in_digit (nat, off)" returns the number of
most significant bits consecutively null of $nat_{off}$.

\verb"is_nat_int (nat, off, len)" tests if $nat_{off, len}$ can be coerced
in an \verb"int".

\verb"nth_digit_nat (nat, off)" returns $nat_{off}$. 

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do set_digit_nat (nat, i, i) done;;
() : unit

#debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#is_digit_int (nat, #0);;
true : bool

#is_nat_int (nat, #0, #2);;
false : bool

#nth_digit_nat (nat, #1);;
1 : int

#is_digit_normalized (nat, #1);;
false : bool

#is_digit_zero (nat, #0);;
true : bool

#is_digit_zero (nat, #1);;
false : bool

#is_digit_odd (nat, #1);;
true : bool

#is_digit_odd (nat, #2);;
false : bool

#is_zero_nat (nat, #0, #1);;
true : bool

#is_zero_nat (nat, #0, #4);;
false : bool

#num_leading_zero_bits_in_digit (nat, #0);;
32 : int

#num_leading_zero_bits_in_digit (nat, #1);;
31 : int
\end{verbatim}
\end{small}
