\conceptindex{\verb"#"}
\conceptindex{integer}
\conceptindex{\verb"int"}
\conceptindex{coercion between types \verb"int" and \verb"string"}
\begin{caml_primitive}
sys_int_of_string : int * string * int * int -> int
int_of_string : string -> int
\end{caml_primitive}

CAML is able to read \verb"int"s entered directly, when you type in a
number preceded by a sharp  ``\verb"#"'', following the lexical
convention:

\begin{small}
\begin{verbatim}
INT ::= '#' {'-' | '+'} Digit+
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
##1;;
1 : int

##-1;;
-1 : int

##+1;;
1 : int

##32767;;
32767 : int

##32768;;
32768.0 : float

##-32767;;
-32767 : int

##-32768;;
-32768.0 : float
\end{verbatim}
\end{small}

Using standard arithmetic, the sharp character is optional (see chapter 
~\ref{numdir} for more information).

\verb"sys_int_of_string (base, s, off, len)" maps the substring $s_{off, len}$
in base \verb"base"  ($ 2 \leq \verb"base" \leq 16$) onto a number of
type \protect\verb"int". 

\verb"int_of_string s" is semantically equivalent to:
\begin{small}
\begin{verbatim}
let int_of_string s = 
  sys_int_of_string (#10, s, #0, length_string s)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_int_of_string (#10, "123456789012345678989", #11, #5);;
23456 : int

#int_of_string "12345";;
12345 : int
\end{verbatim}
\end{small}
