\begin{caml_primitive}
sys_latex_print_nat : int * string * nat * int * int * string -> unit
latex_print_nat : nat -> unit
latex_print_for_read_nat : nat -> unit
sys_print_beautiful_nat : int * string * nat * int * int * string -> unit
print_beautiful_nat : nat -> unit
\end{caml_primitive}
These special printing functions for natural numbers can be found into
two libraries: 
\begin{description}
\item[format\_latex\_numbers.ml: ] functions that split numbers into
small lines so \LaTeX \, is able to handle them correctly, 
\item[format\_numbers.ml: ] functions to present the \verb"nat" as
a numerical table according to common conventions.
\end{description}

\verb"sys_latex_print_nat (base, before, nat, off, len, after)" prints 
\verb"base" representation of subnat $nat_{off, len}$ between \verb"before" 
and \verb"after", cutting line each \verb"latex_margin" characters.

\verb"latex_print_nat" and \verb"latex_print_for_read_nat" are equivalent to:
\begin{small}
\begin{verbatim}
let latex_print_nat nat =
  sys_latex_print_nat (#10, "", nat, #0,
                       num_digits_nat (nat, #0, length_nat nat), "")
;;

let latex_print_for_read_nat nat =
  sys_latex_print_nat (#10, "#<", nat, #0,
                       num_digits_nat (nat, #0, length_nat nat), ">")
;;
\end{verbatim}
\end{small}
As an example this manual uses \verb"latex_print_for_read_nat" as the printer
for natural numbers.

\verb"sys_print_beautiful_nat (base, before, nat, off, len, after)" prints 
\verb"base"-radix representation of subnat $nat_{off, len}$ between 
\verb"before" and \verb"after" as a numerical table according to classical 
conventions.

\verb"print_beautiful_nat" is equivalent to:
\begin{small}
\begin{verbatim}
let print_beautiful_nat nat =
  sys_print_beautiful_nat (#10, "", nat, #0,
                       num_digits_nat (nat, #0, length_nat nat), "")
;;
\end{verbatim}
\end{small}

You can load the libraries with:
\begin{small}
\begin{verbatim}
load_lib_file "format_latex_numbers";;
load_lib_file "format_numbers";;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#let nat = make_nat #50;;
Value nat is #<0> : nat

#set_digit_nat (nat, #49, #1);;
() : unit

#print_beautiful_nat nat;;
10352 21304  67682 24942  50182 38987  58125 56497  26918 22829
15323 02783  39025 97280  29067 09060  12854 18454  96784 42287
66593 04257  74796 15304  02560 49867  14394 71495  42742 79767
67721 14810  59401 01347  02920 37191  58120 99936  58212 56286
17621 84379  22016 11343  67961 01316  26312 73818  64212 94556

73571 30891  00244 69518  17226 86663  79357 25012  27715 49253
01910 77163  01297 77340  98941 24750  20844 05834  13946 43737
89454 47786  92139 36390  56949 58460  67318 10387  73284 47182
89469 13683  23793 71211  71506 21872  25034 33123  21446 06272
33274 17368  32441 05465  856
() : unit
\end{verbatim}
\end{small}
