\begin{caml_primitive}
complement_nat : nat * int * int -> unit
decr_nat : nat * int * int * int -> int
sub_nat : nat * int * int * nat * int * int * int -> int
\end{caml_primitive}
\subsubsection{Complement of natural numbers}
\verb"complement_nat (nat, off, len)" replaces each digit of the subnat 
$nat_{off, len}$ with its $B$-complement, corresponding to 
logical inversion of each bit of each concerned digit. 

More formally speaking \verb"complement_nat" performs the following operation~:

\begin{eqnarray*}
\overline{nat_{off, len}} = 
\overline{\sum_{i=0}^{i<len} nat_{off+i}\, B^i} =
\sum_{i=0}^{i<len} \overline{nat_{off+i}}\, B^i =
\sum_{i=0}^{i<len} \left(B - nat_{off+i} - 1 \right)
\, B^i.
\end{eqnarray*}
%                -------------------
%                i < len                i < len
%                -------                ------- /                  \
% -----------     \                i     \      |                  |  i 
% nat         =    )     nat      B   =   )     | B - 1 - nat      | B  .
%    off, len     /         off+i        /      |            off+i |  
%                -------                ------- \                  /
%                 i = 0                  i = 0 

No side effect is performed if $len=0$.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do
#  set_digit_nat (nat, i, i)
#done;
#debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#complement_nat (nat, #1, #2);
#debug_print_nat nat;;
|00000003|FFFFFFFD|FFFFFFFE|00000000|() : unit
\end{verbatim}
\end{small}

\subsubsection{Decrementing natural numbers}
\verb"decr_nat (nat, off, len, b_in)" subtracts in place the borrow in 
$b\_in$ ($b\_in=0$ or $b\_in=1$) to the subnat $nat_{off, len}$ and
returns the borrow out $b\_out$.  

More formally speaking \verb"decr_nat" performs the following operation : 
\begin{eqnarray*}
\lefteqn{nat_{off, len} + B^{len} + b\_in - 1 =} \\
& & \left(\sum_{i=0}^{i<len} nat_{off+i}\, B^i \right) + B^{len} + b\_in - 1
 = \\
& & \left(\sum_{i=0}^{i<len} nat'_{off+i}\, B^i \right) + b\_out\, B^{len}.  
\end{eqnarray*}
%                                 /                    \     
%                                 | i < len            |         
%                                 | -------            |         
%                len              |  \               i |    len     
% nat         + B    + b_in - 1 = |   )     nat     B  | + B    + b_in - 1
%    off, len                     |  /         off+i   |         
%                                 | -------            |         
%                                 |  i = 0             |        
%                                 \                    /
%                         
%                                 /                      \
%                                 | i < len              |
%                                 | -------              |
%                                 |  \                 i |          len
%                               = |   )      nat'     B  | + b_out B    .
%                                 |  /          off+i    |   
%                                 | -------              |
%                                 |  i = 0               |
%                                 \                      /


\verb"decr_nat" replaces each digit $nat_{off+i}$ with its equivalent
digit $nat'_{off+i}$ and returns the borrow out $b\_out$, with value 0 or 1.  

$b\_out=0$ if and only if $nat_{off, len}=0$ and $b\_in=0$.  
$len$ may be null, so the borrow out equals the borrow in.  

\exple
\begin{small}
\begin{verbatim}
#let nat = make_nat #4;;
Value nat is #<0> : nat

#set_digit_nat (nat, #3, #1);;
() : unit

#debug_print_nat nat;;
|00000001|00000000|00000000|00000000|() : unit

#decr_nat (nat, #0, #4, #1);;
1 : int

#debug_print_nat nat;;
|00000001|00000000|00000000|00000000|() : unit

#decr_nat (nat, #0, #4, #0);;
1 : int

#debug_print_nat nat;;
|00000000|FFFFFFFF|FFFFFFFF|FFFFFFFF|() : unit

#decr_nat (nat, #0, #4, #0);;
1 : int

#debug_print_nat nat;;
|00000000|FFFFFFFF|FFFFFFFF|FFFFFFFE|() : unit

#decr_nat (nat, #0, #4, #1);;
1 : int

#debug_print_nat nat;;
|00000000|FFFFFFFF|FFFFFFFF|FFFFFFFE|() : unit
\end{verbatim}
\end{small}

\subsubsection{Subtraction on natural numbers}
\verb"sub_nat (nat1, off1, len1, nat2, off2,len2, b_in)" subtracts 
$nat2_{off2, len2}$ and the borrow in $b\_in$ to $nat1_{off1, len1}$, 
places result in subnat $nat1_{off1, len1}$, propagates the borrow of this 
subtraction on subnat $nat1_{off1+len2, len1-len2}$ and returns the borrow 
out $b\_out$.

More formally speaking \verb"sub_nat" performs the following operation : 
\begin{eqnarray*} 
\lefteqn{nat1_{off1, len1} - nat2_{off2, len2} + B^{len1} + b\_in - 1 =} \\ 
& & \left(\sum_{i=0}^{i<len1} nat1_{off1+i} \,B^i \right) - 
\left(\sum_{i=0}^{i<len2} nat2_{off2+i}\,B^i \right) + B^{len1} + b\_in - 1 
= \\
& & \left(\sum_{i=0}^{i<len1} nat'_{off1+i} \,B^i \right) + b\_out
\,B^{len1}.  
\end{eqnarray*} 
%                                 len1
% nat1         - nat2          + B     + b_in - 1 =
%    off1, len1      off2, len2         
%                         
%    /                       \   /                       \
%    | i < len1              |   | i < len2              |  
%    | --------              |   | --------              | 
%    |  \                  i |   |  \                  i |    len1   
%    |   )      nat1      B  | - |   )      nat2      B  | + B     + b_in - 1 =
%    |  /           off1+i   |   |  /          off2+i    |
%    | --------              |   | --------              |   
%    |  i = 0                |   |  i = 0                |
%    \                       /   \                       /
%
%    /                        \
%    | i < len1               |
%    | --------               |
%    |  \                   i |          len1
%    |   )       nat'      B  | + b_out B     .
%    |  /           off1+i    |   
%    | --------               |
%    |  i = 0                 |
%    \                        /

\verb"sub_nat" replaces each digit $nat1_{off1+i}$ with its equivalent
digit $nat'_{off1+i}$ and returns the borrow out $b\_out$, with value 0 or 1.
This implies $0 \leq b\_in \leq 1$ and $len1 \geq len2$. 

$nat1$ and $nat2$ can be physically the same one under the condition 
$off1 \leq off2$. 

If $len2 = 0$, \verb"sub_nat (nat1, off1, len1, nat2, off2, len2, b_in)" is
equivalent to \verb"decr_nat (nat1, off1, len1, b_in)".

\exple
\begin{small}
\begin{verbatim}
#let nat = make_nat #4;;
Value nat is #<0> : nat

#complement_nat (nat, #3, #1);;
() : unit

#debug_print_nat nat;;
|FFFFFFFF|00000000|00000000|00000000|() : unit

#sub_nat (nat, #0, #1, nat, #1, #1, #0);;
0 : int

#debug_print_nat nat;;
|FFFFFFFF|00000000|00000000|FFFFFFFF|() : unit

#sub_nat (nat, #0, #2, nat, #2, #1, #0);;
1 : int

#debug_print_nat nat;;
|FFFFFFFF|00000000|00000000|FFFFFFFE|() : unit

#sub_nat (nat, #2, #1, nat, #3, #1, #0);;
0 : int

#debug_print_nat nat;;
|FFFFFFFF|00000000|00000000|FFFFFFFE|() : unit

#sub_nat (nat, #0, #3, nat, #0, #1, #0);;
0 : int

#debug_print_nat nat;;
|FFFFFFFF|FFFFFFFF|FFFFFFFF|FFFFFFFF|() : unit
\end{verbatim}
\end{small}
