(* System functions for interactive use *)

value quit : unit -> unit
        (* Exit the toplevel loop. *)
  and include : string -> unit
        (* Read, compile and execute source phrases from the given file.
           Definitions are entered in module [top], as if they were
           read from the keyboard.
           The [.ml] extension is automatically added to the file name,
           if not present. *)
  and load : string -> unit
        (* Load in core the source for a module.
           Read, compile and execute source phrases from the given file.
           Definitions are entered in a new module with the given name.
           The [.ml] extension is automatically added to the file name,
           if not present. *)
  and load_object : string -> unit
        (* Load in core a compiled bytecode file.
           The [.zo] extension is automatically added, if not present. *)
  and trace : string -> unit
        (* After [trace "foo"], all calls to the global function named [foo]
           will be traced.
           That is, the argument and the result are displayed for each call,
           as well as exceptions escaping out of [foo]. *)
  and untrace : string -> unit
        (* [untrace "foo"] stops tracing function [foo]. *)
  and new_printer : string -> ('a -> unit) -> unit
        (* [new_printer "mytype" f] registers function [f] as a printer
           for objects of type [mytype]. That is, the toplevel loop will
           call [f] when it has an object of type [mytype] to print.
           This is not type-safe: the system does not check that [f]
           actually accepts arguments of type [mytype]. *)
  and default_printer : string -> unit
        (* [default_printer "mytype"] reverts to the default printing
           behavior for objects of type [mytype]. *)
  and gc : unit -> int
        (* Finish the current GC cycle and return the number of free bytes
	   in the heap. *)
  and cd : string -> unit
        (* Change the current working directory. *)
;;    
