typedef struct lab_use
{
  instruction *inst;		/* NULL => Data, not code */
  mem_addr addr;
  struct lab_use *next;
} label_use;

/* Symbol table information on a label. */
typedef struct lab
{
  char *name;			/* Name of label */
  int addr;			/* Address of label or 0 if not yet defined */
  unsigned char global_flag;	/* Non-zero => declared global */
  unsigned char gp_flag;	/* Non-zero => referenced off gp */
  struct lab *next;		/* Hash table link */
  struct lab *next_local;	/* Link in list of local labels */
  label_use *uses;		/* List of instructions that reference */
} label;			/* label that has not yet been defined */


#define SYMBOL_IS_DEFINED(SYM) ((SYM)->addr != 0)
#ifndef OLDC
extern void initialize_symbol_table(void);
extern label *lookup_label(char *);
extern label *record_label(char *, mem_addr);
extern label *make_label_global(char *);
extern void record_inst_uses_symbol(instruction *, mem_addr, label *);
extern void record_data_uses_symbol(mem_addr, label *);
extern void resolve_a_label(label *, instruction *, mem_addr);
extern void flush_local_labels(void);
extern void print_symbols(void);
extern mem_addr find_symbol_address(char *);
#endif
