
######################################################################
## $Id: Content.pm 3668 2006-03-11 20:51:13Z spadkins $
######################################################################

package App::SessionObject::Content;
$VERSION = (q$Revision: 3668 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App::SessionObject;
@ISA = ( "App::SessionObject" );

use strict;

=head1 NAME

App::SessionObject::Content - an chunk of binary content representing data to be returned to a browser instead of the HTML content that gets returned by an App::Widget (i.e. Excel, PDF, CSV, etc.)

=head1 SYNOPSIS

   use App::SessionObject::Content;

=cut

#############################################################################
# PUBLIC METHODS
#############################################################################

=head1 Public Methods:

=cut

#############################################################################
# Method: content()
#############################################################################

=head2 content()

    * Signature: $content = $self->content();
    * Param:     void
    * Return:    $content   any
    * Throws:    App::Exception
    * Since:     0.01

    $content = $so->content();
    if (ref($content)) {
        App::Reference->print($content);
        print "\n";
    }
    else {
        print $content, "\n";
    }

=cut

sub content {
    &App::sub_entry if ($App::trace);
    my $self = shift;
    my $contentref = $self->{content};
    if (!$contentref) {
        my $content = "";
        $contentref = \$content;
    }
    elsif (!ref($contentref)) {
        $contentref = \$contentref;
    }
    elsif (ref($contentref) ne "SCALAR") {
        my $content = "";
        $contentref = \$content;
    }
    &App::sub_exit($$contentref) if ($App::trace);
    return($$contentref);
}

#############################################################################
# content_type()
#############################################################################

=head2 content_type()

    * Signature: $content_type = $service->content_type();
    * Param:     void
    * Return:    $content_type   string
    * Throws:    App::Exception
    * Since:     0.01

    Sample Usage:

    $content_type = $service->content_type();

=cut

my %content_type = (
    html => "text/html",
    txt  => "text/plain",
    pdf  => "application/pdf\nContent-disposition: attachment; filename=\"data.pdf\"",
    xls  => "application/vnd.ms-excel\nContent-disposition: attachment; filename=\"data.xls\"",
    xml  => "application/xml",
    csv  => "application/octet-stream\nContent-disposition: attachment; filename=\"data.csv\"",
    bin  => "application/octet-stream\nContent-disposition: attachment; filename=\"data.bin\"",
);

sub content_type {
    &App::sub_entry if ($App::trace);
    my ($self) = @_;
    my $extension = $self->{extension} || "html";
    my $content_type = $content_type{$extension};
    if (!$content_type) {
        $content_type = $content_type{bin};
    }
    &App::sub_exit($content_type) if ($App::trace);
    return($content_type);
}

1;

