/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.ErrorCode;

class VerbosityCommandExecutor
implements CommandExecutor {
    VerbosityCommandExecutor() {
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        Level level;
        int req = cmd.getInputBuffer().getInt(24);
        switch (req) {
            case 0: {
                level = Level.OFF;
                break;
            }
            case 1: {
                level = Level.SEVERE;
                break;
            }
            case 2: {
                level = Level.INFO;
                break;
            }
            default: {
                level = Level.FINEST;
            }
        }
        Logger.getLogger("org.couchbase.mock").setLevel(level);
        client.sendResponse(new BinaryResponse(cmd, ErrorCode.SUCCESS));
    }
}

