/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADAV	 = 10,
	OP_PADHV	 = 11,
	OP_PADANY	 = 12,
	OP_PUSHRE	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_TRANSR	 = 36,
	OP_SASSIGN	 = 37,
	OP_AASSIGN	 = 38,
	OP_CHOP		 = 39,
	OP_SCHOP	 = 40,
	OP_CHOMP	 = 41,
	OP_SCHOMP	 = 42,
	OP_DEFINED	 = 43,
	OP_UNDEF	 = 44,
	OP_STUDY	 = 45,
	OP_POS		 = 46,
	OP_PREINC	 = 47,
	OP_I_PREINC	 = 48,
	OP_PREDEC	 = 49,
	OP_I_PREDEC	 = 50,
	OP_POSTINC	 = 51,
	OP_I_POSTINC	 = 52,
	OP_POSTDEC	 = 53,
	OP_I_POSTDEC	 = 54,
	OP_POW		 = 55,
	OP_MULTIPLY	 = 56,
	OP_I_MULTIPLY	 = 57,
	OP_DIVIDE	 = 58,
	OP_I_DIVIDE	 = 59,
	OP_MODULO	 = 60,
	OP_I_MODULO	 = 61,
	OP_REPEAT	 = 62,
	OP_ADD		 = 63,
	OP_I_ADD	 = 64,
	OP_SUBTRACT	 = 65,
	OP_I_SUBTRACT	 = 66,
	OP_CONCAT	 = 67,
	OP_STRINGIFY	 = 68,
	OP_LEFT_SHIFT	 = 69,
	OP_RIGHT_SHIFT	 = 70,
	OP_LT		 = 71,
	OP_I_LT		 = 72,
	OP_GT		 = 73,
	OP_I_GT		 = 74,
	OP_LE		 = 75,
	OP_I_LE		 = 76,
	OP_GE		 = 77,
	OP_I_GE		 = 78,
	OP_EQ		 = 79,
	OP_I_EQ		 = 80,
	OP_NE		 = 81,
	OP_I_NE		 = 82,
	OP_NCMP		 = 83,
	OP_I_NCMP	 = 84,
	OP_SLT		 = 85,
	OP_SGT		 = 86,
	OP_SLE		 = 87,
	OP_SGE		 = 88,
	OP_SEQ		 = 89,
	OP_SNE		 = 90,
	OP_SCMP		 = 91,
	OP_BIT_AND	 = 92,
	OP_BIT_XOR	 = 93,
	OP_BIT_OR	 = 94,
	OP_NEGATE	 = 95,
	OP_I_NEGATE	 = 96,
	OP_NOT		 = 97,
	OP_COMPLEMENT	 = 98,
	OP_SMARTMATCH	 = 99,
	OP_ATAN2	 = 100,
	OP_SIN		 = 101,
	OP_COS		 = 102,
	OP_RAND		 = 103,
	OP_SRAND	 = 104,
	OP_EXP		 = 105,
	OP_LOG		 = 106,
	OP_SQRT		 = 107,
	OP_INT		 = 108,
	OP_HEX		 = 109,
	OP_OCT		 = 110,
	OP_ABS		 = 111,
	OP_LENGTH	 = 112,
	OP_SUBSTR	 = 113,
	OP_VEC		 = 114,
	OP_INDEX	 = 115,
	OP_RINDEX	 = 116,
	OP_SPRINTF	 = 117,
	OP_FORMLINE	 = 118,
	OP_ORD		 = 119,
	OP_CHR		 = 120,
	OP_CRYPT	 = 121,
	OP_UCFIRST	 = 122,
	OP_LCFIRST	 = 123,
	OP_UC		 = 124,
	OP_LC		 = 125,
	OP_QUOTEMETA	 = 126,
	OP_RV2AV	 = 127,
	OP_AELEMFAST	 = 128,
	OP_AELEMFAST_LEX = 129,
	OP_AELEM	 = 130,
	OP_ASLICE	 = 131,
	OP_KVASLICE	 = 132,
	OP_AEACH	 = 133,
	OP_AKEYS	 = 134,
	OP_AVALUES	 = 135,
	OP_EACH		 = 136,
	OP_VALUES	 = 137,
	OP_KEYS		 = 138,
	OP_DELETE	 = 139,
	OP_EXISTS	 = 140,
	OP_RV2HV	 = 141,
	OP_HELEM	 = 142,
	OP_HSLICE	 = 143,
	OP_KVHSLICE	 = 144,
	OP_MULTIDEREF	 = 145,
	OP_UNPACK	 = 146,
	OP_PACK		 = 147,
	OP_SPLIT	 = 148,
	OP_JOIN		 = 149,
	OP_LIST		 = 150,
	OP_LSLICE	 = 151,
	OP_ANONLIST	 = 152,
	OP_ANONHASH	 = 153,
	OP_SPLICE	 = 154,
	OP_PUSH		 = 155,
	OP_POP		 = 156,
	OP_SHIFT	 = 157,
	OP_UNSHIFT	 = 158,
	OP_SORT		 = 159,
	OP_REVERSE	 = 160,
	OP_GREPSTART	 = 161,
	OP_GREPWHILE	 = 162,
	OP_MAPSTART	 = 163,
	OP_MAPWHILE	 = 164,
	OP_RANGE	 = 165,
	OP_FLIP		 = 166,
	OP_FLOP		 = 167,
	OP_AND		 = 168,
	OP_OR		 = 169,
	OP_XOR		 = 170,
	OP_DOR		 = 171,
	OP_COND_EXPR	 = 172,
	OP_ANDASSIGN	 = 173,
	OP_ORASSIGN	 = 174,
	OP_DORASSIGN	 = 175,
	OP_METHOD	 = 176,
	OP_ENTERSUB	 = 177,
	OP_LEAVESUB	 = 178,
	OP_LEAVESUBLV	 = 179,
	OP_CALLER	 = 180,
	OP_WARN		 = 181,
	OP_DIE		 = 182,
	OP_RESET	 = 183,
	OP_LINESEQ	 = 184,
	OP_NEXTSTATE	 = 185,
	OP_DBSTATE	 = 186,
	OP_UNSTACK	 = 187,
	OP_ENTER	 = 188,
	OP_LEAVE	 = 189,
	OP_SCOPE	 = 190,
	OP_ENTERITER	 = 191,
	OP_ITER		 = 192,
	OP_ENTERLOOP	 = 193,
	OP_LEAVELOOP	 = 194,
	OP_RETURN	 = 195,
	OP_LAST		 = 196,
	OP_NEXT		 = 197,
	OP_REDO		 = 198,
	OP_DUMP		 = 199,
	OP_GOTO		 = 200,
	OP_EXIT		 = 201,
	OP_METHOD_NAMED	 = 202,
	OP_METHOD_SUPER	 = 203,
	OP_METHOD_REDIR	 = 204,
	OP_METHOD_REDIR_SUPER = 205,
	OP_ENTERGIVEN	 = 206,
	OP_LEAVEGIVEN	 = 207,
	OP_ENTERWHEN	 = 208,
	OP_LEAVEWHEN	 = 209,
	OP_BREAK	 = 210,
	OP_CONTINUE	 = 211,
	OP_OPEN		 = 212,
	OP_CLOSE	 = 213,
	OP_PIPE_OP	 = 214,
	OP_FILENO	 = 215,
	OP_UMASK	 = 216,
	OP_BINMODE	 = 217,
	OP_TIE		 = 218,
	OP_UNTIE	 = 219,
	OP_TIED		 = 220,
	OP_DBMOPEN	 = 221,
	OP_DBMCLOSE	 = 222,
	OP_SSELECT	 = 223,
	OP_SELECT	 = 224,
	OP_GETC		 = 225,
	OP_READ		 = 226,
	OP_ENTERWRITE	 = 227,
	OP_LEAVEWRITE	 = 228,
	OP_PRTF		 = 229,
	OP_PRINT	 = 230,
	OP_SAY		 = 231,
	OP_SYSOPEN	 = 232,
	OP_SYSSEEK	 = 233,
	OP_SYSREAD	 = 234,
	OP_SYSWRITE	 = 235,
	OP_EOF		 = 236,
	OP_TELL		 = 237,
	OP_SEEK		 = 238,
	OP_TRUNCATE	 = 239,
	OP_FCNTL	 = 240,
	OP_IOCTL	 = 241,
	OP_FLOCK	 = 242,
	OP_SEND		 = 243,
	OP_RECV		 = 244,
	OP_SOCKET	 = 245,
	OP_SOCKPAIR	 = 246,
	OP_BIND		 = 247,
	OP_CONNECT	 = 248,
	OP_LISTEN	 = 249,
	OP_ACCEPT	 = 250,
	OP_SHUTDOWN	 = 251,
	OP_GSOCKOPT	 = 252,
	OP_SSOCKOPT	 = 253,
	OP_GETSOCKNAME	 = 254,
	OP_GETPEERNAME	 = 255,
	OP_LSTAT	 = 256,
	OP_STAT		 = 257,
	OP_FTRREAD	 = 258,
	OP_FTRWRITE	 = 259,
	OP_FTREXEC	 = 260,
	OP_FTEREAD	 = 261,
	OP_FTEWRITE	 = 262,
	OP_FTEEXEC	 = 263,
	OP_FTIS		 = 264,
	OP_FTSIZE	 = 265,
	OP_FTMTIME	 = 266,
	OP_FTATIME	 = 267,
	OP_FTCTIME	 = 268,
	OP_FTROWNED	 = 269,
	OP_FTEOWNED	 = 270,
	OP_FTZERO	 = 271,
	OP_FTSOCK	 = 272,
	OP_FTCHR	 = 273,
	OP_FTBLK	 = 274,
	OP_FTFILE	 = 275,
	OP_FTDIR	 = 276,
	OP_FTPIPE	 = 277,
	OP_FTSUID	 = 278,
	OP_FTSGID	 = 279,
	OP_FTSVTX	 = 280,
	OP_FTLINK	 = 281,
	OP_FTTTY	 = 282,
	OP_FTTEXT	 = 283,
	OP_FTBINARY	 = 284,
	OP_CHDIR	 = 285,
	OP_CHOWN	 = 286,
	OP_CHROOT	 = 287,
	OP_UNLINK	 = 288,
	OP_CHMOD	 = 289,
	OP_UTIME	 = 290,
	OP_RENAME	 = 291,
	OP_LINK		 = 292,
	OP_SYMLINK	 = 293,
	OP_READLINK	 = 294,
	OP_MKDIR	 = 295,
	OP_RMDIR	 = 296,
	OP_OPEN_DIR	 = 297,
	OP_READDIR	 = 298,
	OP_TELLDIR	 = 299,
	OP_SEEKDIR	 = 300,
	OP_REWINDDIR	 = 301,
	OP_CLOSEDIR	 = 302,
	OP_FORK		 = 303,
	OP_WAIT		 = 304,
	OP_WAITPID	 = 305,
	OP_SYSTEM	 = 306,
	OP_EXEC		 = 307,
	OP_KILL		 = 308,
	OP_GETPPID	 = 309,
	OP_GETPGRP	 = 310,
	OP_SETPGRP	 = 311,
	OP_GETPRIORITY	 = 312,
	OP_SETPRIORITY	 = 313,
	OP_TIME		 = 314,
	OP_TMS		 = 315,
	OP_LOCALTIME	 = 316,
	OP_GMTIME	 = 317,
	OP_ALARM	 = 318,
	OP_SLEEP	 = 319,
	OP_SHMGET	 = 320,
	OP_SHMCTL	 = 321,
	OP_SHMREAD	 = 322,
	OP_SHMWRITE	 = 323,
	OP_MSGGET	 = 324,
	OP_MSGCTL	 = 325,
	OP_MSGSND	 = 326,
	OP_MSGRCV	 = 327,
	OP_SEMOP	 = 328,
	OP_SEMGET	 = 329,
	OP_SEMCTL	 = 330,
	OP_REQUIRE	 = 331,
	OP_DOFILE	 = 332,
	OP_HINTSEVAL	 = 333,
	OP_ENTEREVAL	 = 334,
	OP_LEAVEEVAL	 = 335,
	OP_ENTERTRY	 = 336,
	OP_LEAVETRY	 = 337,
	OP_GHBYNAME	 = 338,
	OP_GHBYADDR	 = 339,
	OP_GHOSTENT	 = 340,
	OP_GNBYNAME	 = 341,
	OP_GNBYADDR	 = 342,
	OP_GNETENT	 = 343,
	OP_GPBYNAME	 = 344,
	OP_GPBYNUMBER	 = 345,
	OP_GPROTOENT	 = 346,
	OP_GSBYNAME	 = 347,
	OP_GSBYPORT	 = 348,
	OP_GSERVENT	 = 349,
	OP_SHOSTENT	 = 350,
	OP_SNETENT	 = 351,
	OP_SPROTOENT	 = 352,
	OP_SSERVENT	 = 353,
	OP_EHOSTENT	 = 354,
	OP_ENETENT	 = 355,
	OP_EPROTOENT	 = 356,
	OP_ESERVENT	 = 357,
	OP_GPWNAM	 = 358,
	OP_GPWUID	 = 359,
	OP_GPWENT	 = 360,
	OP_SPWENT	 = 361,
	OP_EPWENT	 = 362,
	OP_GGRNAM	 = 363,
	OP_GGRGID	 = 364,
	OP_GGRENT	 = 365,
	OP_SGRENT	 = 366,
	OP_EGRENT	 = 367,
	OP_GETLOGIN	 = 368,
	OP_SYSCALL	 = 369,
	OP_LOCK		 = 370,
	OP_ONCE		 = 371,
	OP_CUSTOM	 = 372,
	OP_REACH	 = 373,
	OP_RKEYS	 = 374,
	OP_RVALUES	 = 375,
	OP_COREARGS	 = 376,
	OP_RUNCV	 = 377,
	OP_FC		 = 378,
	OP_PADCV	 = 379,
	OP_INTROCV	 = 380,
	OP_CLONECV	 = 381,
	OP_PADRANGE	 = 382,
	OP_REFASSIGN	 = 383,
	OP_LVREF	 = 384,
	OP_LVREFSLICE	 = 385,
	OP_LVAVREF	 = 386,
	OP_ANONCONST	 = 387,
	OP_max		
} opcode;

#define MAXO 388
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)	\
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)	\
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

/* ex: set ro: */
