### nth-degree Bezier curve definition

### The NURBS book p. 9 

use parent 'algorithm';

sub new {
	my $class = shift;

	$self = SUPER::new->(@_);
}

### B_{i,n} are Bernstein polynomials, see bernsteinpolynomialsalgorithm.pm
### it uses a simple xyz coordinate list as a point for the bezier curve
### One can use this with a nested list of points
sub calculate {
	my ($self, @Bin, @Pointxyz) = @_;

	my $p = point->new(0,0,0);
	my $l = length(@Pointxyz); 

	while (--$l >= 0) {
		$p->setx($p->getx + @Bin[$l]*@Pointxyz[$l]);
		$p->sety($p->gety + @Bin[$l]*@Pointxyz[$l]);
		$p->setz($p->getz + @Bin[$l]*@Pointxyz[$l]);
	}

	return $p;
}

### this works somehwat for non-sorted polygons in 3D space
sub calculate_for_z_order {
	my ($self, @Bin, @Pointxyz) = @_;

	my $z = 0;
	my $l = length(@Pointxyz); 

	while (--$l >= 0) {
		$z += @Bin[$l]*@Pointzyz[$l];
	}

	return $z;
}

1;
